/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchdata;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import org.apache.commons.lang3.ObjectUtils;

public class ItpTaxLossDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    private static Log logger = LogFactory.getLog(ItpTaxLossDynamicCustomFormulaPlugin.class);

    public Map<String, FormulaVo> queryByDeclareRequestModel(DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> formulaMap = new HashMap<String, FormulaVo>();
        if (ObjectUtils.isNotEmpty(dynList)) {
            String taxlossIsmbsnzgsk = "0";
            if (ObjectUtils.isNotEmpty((Object)requestModel) && ObjectUtils.isNotEmpty((Object)requestModel.getBusinessMap())) {
                taxlossIsmbsnzgsk = (String)requestModel.getBusinessMap().get("taxlosssmbsnzgsk");
            }
            logger.info("ItpTaxLossDynamicCustomFormulaPlugin queryByDeclareRequestModel taxlossIsmbsnzgsk :{}", (Object)taxlossIsmbsnzgsk);
            String skssqq = requestModel.getSkssqq();
            int yearOfDate = DateUtils.getYearOfDate((Date)DateUtils.stringToDate((String)skssqq));
            for (DynamicRowModel dyn : dynList) {
                String dynRowNo = dyn.getDynRowNo();
                if (!"tax_loss_jzgl_xm#1".equalsIgnoreCase(dynRowNo)) continue;
                List rowList = dyn.getRowList();
                this.buildDynFormulaBnqc(rowList, formulaMap);
                this.buildDqsdsYqndks(rowList, formulaMap, taxlossIsmbsnzgsk, yearOfDate);
            }
        }
        logger.info("ItpTaxLossDynamicCustomFormulaPlugin formulaMap : {}", (Object)JsonUtil.toJson(formulaMap));
        return formulaMap;
    }

    private void buildDqsdsYqndks(List<Map<String, String>> rowList, Map<String, FormulaVo> formulaMap, String taxlossIsmbsnzgsk, int yearOfDate) {
        String prefix = "tax_loss_jzgl_xm#";
        for (int i = 0; i < rowList.size(); ++i) {
            String formulavokey;
            FormulaVo vo;
            if (!rowList.get(i).containsKey("tax_loss_jzgl_xm#" + (i + 1) + "#tax_loss_cropyear") && !rowList.get(i).containsKey("tax_loss_jzgl_xm#tax_loss_cropyear")) continue;
            int cropyear = 0;
            if (rowList.get(i).containsKey("tax_loss_jzgl_xm#tax_loss_cropyear")) {
                cropyear = Integer.parseInt(rowList.get(i).get("tax_loss_jzgl_xm#tax_loss_cropyear"));
            } else if (rowList.get(i).containsKey("tax_loss_jzgl_xm#" + (i + 1) + "#tax_loss_cropyear")) {
                cropyear = Integer.parseInt(rowList.get(i).get("tax_loss_jzgl_xm#" + (i + 1) + "#tax_loss_cropyear"));
            }
            if (yearOfDate == cropyear) {
                vo = new FormulaVo();
                vo.setFormulaType("1");
                formulavokey = "dqsds_yqndknbks#dqsds_bndb_zdqs";
                vo.setFormulaKey(formulavokey);
                String formulavo = "";
                formulavo = "1".equalsIgnoreCase(taxlossIsmbsnzgsk) ? "{Q[" + prefix + (i + 1) + "#tax_loss_qcye_skqc_hj]}" : "if({Q[tax_loss_hj#tax_loss_lapseyear]} == 1,{Q[" + prefix + (i + 1) + "#tax_loss_qcye_skqc_hj]},{C[0.00]})";
                vo.setFormula(formulavo);
                formulaMap.put(formulavokey, vo);
                FormulaVo v = new FormulaVo();
                v.setFormulaType("1");
                String formulavkey = "zcycgl_kmbss#zcycgl_bnbd_zdqs";
                v.setFormulaKey(formulavkey);
                String formulav = "";
                formulav = "{Q[" + prefix + (i + 1) + "#tax_loss_qcye_bqbd_hj]}";
                v.setFormula(formulav);
                formulaMap.put(formulavkey, v);
                FormulaVo fv = new FormulaVo();
                fv.setFormulaType("1");
                String formulafvkey = prefix + (i + 1) + "#tax_loss_bqbd_dnmbks";
                fv.setFormulaKey(formulafvkey);
                String formulafv = "-{Q[dqsds_bnmbks#dqsds_hj]}";
                fv.setFormula(formulafv);
                formulaMap.put(formulafvkey, fv);
                continue;
            }
            vo = new FormulaVo();
            vo.setFormulaType("1");
            formulavokey = "tax_loss_jzgl_xm#" + (i + 1) + "#tax_loss_bqbd_dnmbks";
            vo.setFormulaKey(formulavokey);
            String value = rowList.get(i).containsKey("tax_loss_jzgl_xm#tax_loss_bqbd_dnmbks") ? rowList.get(i).get("tax_loss_jzgl_xm#tax_loss_bqbd_dnmbks") : "0.00";
            String formulavo = "{C[" + value + "]}";
            vo.setFormula(formulavo);
            formulaMap.put(formulavokey, vo);
        }
    }

    private void buildDynFormulaBnqc(List<Map<String, String>> rowList, Map<String, FormulaVo> formulaMap) {
        String prefix = "tax_loss_jzgl_xm#";
        if (ObjectUtils.isNotEmpty(rowList)) {
            for (int i = 0; i < rowList.size(); ++i) {
                FormulaVo formulaVo = new FormulaVo();
                formulaVo.setFormulaType("1");
                String formulaKey = prefix + (i + 1) + "#tax_loss_qcye_kmbskqc";
                formulaVo.setFormulaKey(formulaKey);
                String formula = "";
                if (i == 0) {
                    String value = rowList.get(i).containsKey("tax_loss_jzgl_xm#tax_loss_qcye_kmbskqc") ? rowList.get(i).get("tax_loss_jzgl_xm#tax_loss_qcye_kmbskqc") : "0.00";
                    formula = "{C[" + value + "]}";
                } else {
                    formula = "if({Q[" + prefix + i + "#tax_loss_qmye_jzkdkskye]} > 0,{Q[" + prefix + i + "#tax_loss_qmye_jzkdkskye]},0.00)";
                }
                formulaVo.setFormula(formula);
                formulaMap.put(formulaKey, formulaVo);
            }
        }
    }
}

