/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceHandler;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.rulefetch.QueryRuleFetchParam;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.itp.business.baseinfo.ItpFirstConfirmDysdsPlanBussiness;
import kd.taxc.itp.business.baseinfo.NotConfirmDysdsPlanBussiness;
import kd.taxc.itp.business.fetchdata.ItpFetchDataBussiness;
import kd.taxc.itp.business.papers.ItpDeclareReportTabBussiness;
import kd.taxc.itp.business.papers.ItpDraftEmployeeNumbersBussiness;
import kd.taxc.itp.business.papers.ItpMultiDataQueryBussiness;
import kd.taxc.itp.business.systemParameter.ItpSystemParameterBussiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import kd.taxc.itp.common.enums.ItpJtDeclareReportLockEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SdsjtInitParams
implements InitParams {
    private static final String PRE_YEAR_END_SBBID = "preyearendsbbid";
    private static final String IS_FIRST_PERIOD = "isfirstperiod";
    private static final String PRE_PERIOD_SBBID = "preperiodsbbid";
    private static final String IS_YJXCY_GYXJZ = "is_yjx_gyxjz";
    private static final String IS_YJXCY_ZGYJJF = "is_yjx_zgyjjf";
    private static final Long GYXJZ_ID = 1544973716101142528L;
    private static final Long ZGYJJF_ID = 1544973716981946369L;

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map param = super.buildBizParam(requestModel);
        Date startDate = DateUtils.stringToDate((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate((String)requestModel.getSkssqz());
        param.put("taxationsys", "1");
        param.put("templatetype", requestModel.getTemplateType());
        param.put("draftpurpose", "sjjt");
        if (requestModel.getRefresh().booleanValue()) {
            requestModel.getBusinessMap().putAll(ItpFetchDataBussiness.getFetchConfigParams(requestModel));
        }
        ArrayList<String> lockCellList = new ArrayList<String>(12);
        int monthDiff = DateUtils.getMonthDiff((Date)startDate, (Date)endDate);
        String str = new SimpleDateFormat("yyyy").format(DateUtils.addYear((Date)endDate, (int)-1).getTime()) + "-12-31 00:00:00";
        Date preEndData = DateUtils.stringToDate((String)str, (String)"yyyy-MM-dd HH:mm:ss");
        String isFirstPeriod = this.isFirstPeriod(requestModel).toString();
        param.put(IS_FIRST_PERIOD, isFirstPeriod);
        param.put("isfirstperiodnew", "true".equalsIgnoreCase(isFirstPeriod) ? "1" : "0");
        param.put("curyear#sedmyear", String.valueOf(DateUtils.getYearOfDate((Date)startDate)));
        if (Boolean.TRUE.toString().equalsIgnoreCase(isFirstPeriod)) {
            param.put(PRE_PERIOD_SBBID, "-1");
        } else {
            String isadjustperiod = requestModel.getExtendParams().containsKey("isadjustperiod") ? requestModel.getExtendParams().get("isadjustperiod") : "0";
            String preSbbid = "-1";
            preSbbid = "1".equals(isadjustperiod) ? this.getPreSbbId(requestModel.getOrgId(), requestModel.getTemplateId(), requestModel.getTaxationsys(), null, endDate, false, null) : this.getPreSbbId(requestModel.getOrgId(), requestModel.getTemplateId(), requestModel.getTaxationsys(), DateUtils.addMonth((Date)startDate, (int)(-monthDiff)), DateUtils.getLastDateOfMonth2((Date)DateUtils.addMonth((Date)endDate, (int)(-monthDiff))), false, null);
            if (ObjectUtils.isNotEmpty((Object)preSbbid)) {
                param.put(PRE_PERIOD_SBBID, preSbbid);
            } else {
                param.put(PRE_PERIOD_SBBID, "-1");
            }
        }
        String itpNcyeDatasource = ItpSystemParameterBussiness.getItpNcyeDatasource(requestModel.getOrgId());
        boolean isadjustperiod = !"12".equals(itpNcyeDatasource);
        String preSbbid = this.getPreSbbId(requestModel.getOrgId(), requestModel.getTemplateId(), requestModel.getTaxationsys(), null, preEndData, isadjustperiod, isadjustperiod ? itpNcyeDatasource : null);
        if (ObjectUtils.isNotEmpty((Object)preSbbid)) {
            param.put(PRE_YEAR_END_SBBID, preSbbid);
        } else {
            param.put(PRE_YEAR_END_SBBID, "-1");
        }
        QFilter fetchItemsFilter = new QFilter("id", "in", Arrays.asList(GYXJZ_ID, ZGYJJF_ID));
        DynamicObjectCollection fetchItems = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,name,taxationsys,biztype.number as biztype", (QFilter[])new QFilter[]{fetchItemsFilter});
        String isYjxcyGyxjz = null;
        String isYjxcyZgyjjf = null;
        for (DynamicObject fetchItem : fetchItems) {
            if (GYXJZ_ID.longValue() == fetchItem.getLong("id")) {
                isYjxcyGyxjz = String.valueOf("YWLB0002".equalsIgnoreCase(fetchItem.getString("biztype")));
                continue;
            }
            isYjxcyZgyjjf = String.valueOf("YWLB0002".equalsIgnoreCase(fetchItem.getString("biztype")));
        }
        param.put(IS_YJXCY_GYXJZ, isYjxcyGyxjz);
        param.put(IS_YJXCY_ZGYJJF, isYjxcyZgyjjf);
        Object wqrIsShow = SystemParamUtil.getAppParameter((String)"itp", (String)"xsdysdswqrdg", (long)requestModel.getOrgId());
        param.put("xsdysdswqrdg", "0");
        if (ObjectUtils.isNotEmpty((Object)wqrIsShow) && "true".equalsIgnoreCase(wqrIsShow.toString())) {
            param.put("isShowWqr", "true");
            param.put("xsdysdswqrdg", "1");
        } else {
            param.put("isShowWqr", "false");
        }
        boolean itpXssedmdg = ItpSystemParameterBussiness.getItpXssedmdg(requestModel.getOrgId());
        param.put("itpXssedmdg", "0");
        if (itpXssedmdg) {
            param.put("itpXssedmdg", "1");
        }
        boolean itpXsxwqyy = ItpSystemParameterBussiness.getItpXsxwqyyh(requestModel.getOrgId());
        param.put("itpXsxwqyy", "0");
        if (itpXsxwqyy) {
            param.put("itpXsxwqyy", "1");
        }
        this.verifyNotConfirmKmbksDysdsPlan(requestModel.getOrgId(), requestModel.getTaxationsys(), DateUtils.stringToDate2((String)requestModel.getSkssqq()), DateUtils.stringToDate2((String)requestModel.getSkssqz()), 1777705564327943168L, requestModel.getTemplateType(), param);
        boolean isHighTechCompany = ItpTaxOrgCommonBusiness.checkTaxcMainIsHighTechCompany(requestModel.getOrgId(), requestModel.getTaxationsys(), DateUtils.stringToDate2((String)requestModel.getSkssqq()), DateUtils.stringToDate2((String)requestModel.getSkssqz()));
        param.put("isHighTechCompany", isHighTechCompany ? "1" : "0");
        param.put("dysds_dysdsl#dysds_snqnjts", isHighTechCompany ? "15.00" : "25.00");
        String dysdszcfzfkrzParamValue = String.valueOf(SystemParamUtil.getAppParameter((String)"itp", (String)"dysdszcfzfkrz", (long)requestModel.getOrgId()));
        param.put("sjjs_dysdszcfzfkrz#sjjs_empty", dysdszcfzfkrzParamValue);
        int yearOfDate = DateUtils.getYearOfDate((Date)startDate);
        param.put("taxlosscropyear", String.valueOf(yearOfDate));
        String taxlossIsmbsnzgsk = String.valueOf(SystemParamUtil.getAppParameter((String)"itp", (String)"taxlossismbsnzgsk", (long)requestModel.getOrgId()));
        param.put("taxlosssmbsnzgsk", ObjectUtils.isNotEmpty((Object)taxlossIsmbsnzgsk) && "true".equalsIgnoreCase(taxlossIsmbsnzgsk) ? "1" : "0");
        param.put("tax_loss_hj#tax_loss_lapseyear", "0");
        Map<String, String> firstConfirmDysdsPlanMap = ItpFirstConfirmDysdsPlanBussiness.loadItpFirstConfirmDysdsPlanByOrgAndTaxationsysId(requestModel.getOrgId(), requestModel.getTaxationsys(), startDate, endDate);
        param.putAll(firstConfirmDysdsPlanMap);
        List<Map<String, String>> treeNodeList = ItpDeclareReportTabBussiness.buildDraftLightTree(requestModel, param);
        param.put("treeNodeList", "");
        if (ObjectUtils.isNotEmpty(treeNodeList)) {
            param.put("treeNodeList", JsonUtil.toJson(treeNodeList));
        }
        param.put("restrictbanindustry", "0");
        param.put("employeeNumbers", "-1");
        param.put("xwqyyh_zcze", "-1");
        param.put("quarter", "-1");
        param.put("xwqyyh_zcze_value", "0");
        param.put("thidDraftid", "-1");
        param.put("sixDraftid", "-1");
        param.put("nineDraftid", "-1");
        param.put("xwqyyh_header#xwqyyh_gjxzhjzhy", "-1");
        if ("1".equals(requestModel.getTaxationsys().toString()) && itpXsxwqyy) {
            boolean restrictbanindustry;
            param.put("xwqyyh_header#xwqyyh_gjxzhjzhy", "0");
            DynamicObject taxcMainOrg = ItpTaxOrgCommonBusiness.queryTaxcMainByOrgId(requestModel.getOrgId());
            if (ObjectUtils.isNotEmpty((Object)taxcMainOrg) && (restrictbanindustry = taxcMainOrg.getBoolean("restrictbanindustry"))) {
                param.put("xwqyyh_header#xwqyyh_gjxzhjzhy", "1");
            }
            Integer quarterNumber = ItpFetchDataBussiness.calculateQuarter(requestModel.getSkssqq(), requestModel.getSkssqz());
            Integer employeeNumbers = 0;
            if (quarterNumber > 0 && quarterNumber != 5) {
                employeeNumbers = ItpDraftEmployeeNumbersBussiness.queryEmployeeNumbersByOrgAndDate(requestModel.getOrgId(), DateUtils.stringToDate2((String)requestModel.getSkssqz()));
                Map<String, String> seasonEndDraftMap = this.querySeasonEndDraft(requestModel);
                param.putAll(seasonEndDraftMap);
            }
            param.put("quarter", quarterNumber.toString());
            if (ObjectUtils.isNotEmpty((Object)employeeNumbers)) {
                param.put("employeeNumbers", employeeNumbers.toString());
            }
            if (requestModel.getBusinessMap().containsKey("xwqyyh_zcze")) {
                param.put("xwqyyh_zcze", requestModel.getBusinessMap().get("xwqyyh_zcze"));
                String quartertemp = quarterNumber.toString();
                param.put("xwqyyh_zcze_value", requestModel.getBusinessMap().containsKey(ItpFetchDataBussiness.cellMap.get(quartertemp)) ? (String)requestModel.getBusinessMap().get(ItpFetchDataBussiness.cellMap.get(quartertemp)) : "0");
            } else {
                RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
                HashMap<String, Object> requestparamMap = new HashMap<String, Object>(16);
                requestparamMap.put("isCal", requestModel.getRefresh());
                requestparamMap.put("templateId", requestModel.getTemplateId());
                requestparamMap.put("org", requestModel.getOrgId());
                requestparamMap.put("skssqq", requestModel.getSkssqq());
                requestparamMap.put("skssqz", requestModel.getSkssqz());
                requestparamMap.put("businessParams", param);
                DynamicObject fetchDetail = ruleFetchService.getFetchDetail(new QueryRuleFetchParam(RuleFetchServiceHandler.getRuleFetchMainId((RuleFetchMainDto)new RuleFetchMainDto(requestparamMap)), ItpFetchDataBussiness.cellMap.get(quarterNumber.toString())));
                if (ObjectUtils.isNotEmpty((Object)fetchDetail)) {
                    param.put("xwqyyh_zcze", "1");
                }
            }
            List<String> xwqyyhLockCellList = ItpJtDeclareReportLockEnum.getXwqyyhLockCellList(quarterNumber.toString());
            lockCellList.addAll(xwqyyhLockCellList);
        }
        param.put("lockCellList", JsonUtil.toJson(lockCellList));
        return param;
    }

    private Map<String, String> querySeasonEndDraft(DeclareRequestModel requestModel) {
        HashMap<String, String> resultMap = new HashMap<String, String>(12);
        String skssqq = requestModel.getSkssqq();
        int monthOfDate = DateUtils.getMonthOfDate((Date)DateUtils.stringToDate2((String)skssqq));
        if (monthOfDate > 3) {
            Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)DateUtils.stringToDate2((String)skssqq));
            QFilter qFilter = new QFilter("skssqz", "in", Arrays.asList(DateUtils.addMonth((Date)lastDateOfYear, (int)-9), DateUtils.addMonth((Date)lastDateOfYear, (int)-6), DateUtils.addMonth((Date)lastDateOfYear, (int)-3)));
            qFilter.and("isadjustperiod", "=", (Object)false);
            DynamicObject[] dynamicObjects = ItpMultiDataQueryBussiness.queryDraftId(requestModel.getTemplateType(), requestModel.getOrgId(), qFilter);
            if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Date skssqz = dynamicObject.getDate("skssqz");
                    String did = dynamicObject.getString("id");
                    if (DateUtils.getMonthOfDate((Date)skssqz) == 3) {
                        resultMap.put("thidDraftid", did);
                        continue;
                    }
                    if (DateUtils.getMonthOfDate((Date)skssqz) == 6) {
                        resultMap.put("sixDraftid", did);
                        continue;
                    }
                    if (DateUtils.getMonthOfDate((Date)skssqz) != 9) continue;
                    resultMap.put("nineDraftid", did);
                }
            }
        }
        return resultMap;
    }

    private Boolean isFirstPeriod(DeclareRequestModel requestModel) {
        String skssqq = requestModel.getSkssqq();
        return skssqq.endsWith("-01-01");
    }

    private String getPreSbbId(Long orgId, Long templateId, Long taxSystemId, Date startDate, Date endDate, boolean isadjustperiod, String adjustperiod) {
        DynamicObject preMain;
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templateid", "=", (Object)templateId)).and(new QFilter("skssqz", "=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("isadjustperiod", "=", (Object)isadjustperiod));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", "=", (Object)startDate));
        }
        if (adjustperiod != null) {
            declareMainFilter.and(new QFilter("adjustperiod", "=", (Object)adjustperiod));
        }
        return (preMain = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{declareMainFilter})) == null ? null : preMain.getString("id");
    }

    private void verifyNotConfirmKmbksDysdsPlan(Long orgId, Long taxSystemId, Date startDate, Date endDate, Long bbxmId, String templatetype, Map<String, String> param) {
        ArrayList<Long> items = new ArrayList<Long>(12);
        String start = new SimpleDateFormat("yyyy").format(DateUtils.addYear((Date)startDate, (int)-1).getTime()) + "-12-31 00:00:00";
        items.addAll(NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanItemsByOrgAndPeriod(orgId, taxSystemId, DateUtils.stringToDate2((String)start), DateUtils.stringToDate2((String)start)));
        if (items.contains(bbxmId)) {
            param.put("kmbksWqr", "true");
        } else {
            param.put("kmbksWqr", "false");
        }
        String start1 = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)startDate));
        boolean isFirstPeriod = false;
        if (DateUtils.getFirstDateOfYear((Date)endDate).getTime() == startDate.getTime()) {
            isFirstPeriod = true;
        }
        List<Map<String, Object>> planList = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanOrderByOrgAndTaxationsys(orgId, taxSystemId, DateUtils.stringToDate2((String)start1), startDate, endDate);
        Map<String, Map<String, Object>> calculateFetchitemsPlan = NotConfirmDysdsPlanBussiness.calculateFetchitemsPlan(planList, Collections.singletonList(bbxmId), startDate, endDate, isFirstPeriod);
        Map<String, Map<String, Map<String, String>>> queryHistoryPeriodCellVaule = this.queryHistoryPeriodCellVaule(calculateFetchitemsPlan, Collections.singletonList(bbxmId), templatetype, orgId, startDate, endDate, isFirstPeriod);
        int month = DateUtils.getMonthOfDate((Date)endDate) - DateUtils.getMonthOfDate((Date)startDate);
        Map<String, Object> currentPlan = calculateFetchitemsPlan.get("currentPlan");
        List dqwqrList = (List)currentPlan.get("wqrList");
        List dqqrList = (List)currentPlan.get("qrList");
        Map<String, Object> wqrToQrMap = calculateFetchitemsPlan.get("wqrToQr");
        Map<String, Object> qrToWqrMap = calculateFetchitemsPlan.get("qrToWqr");
        Map<String, Map<String, String>> kmbksHisToryDataMap = queryHistoryPeriodCellVaule.get("kmbksHisToryDataMap");
        param.put("historyKmbksZdqsValue", "0.00");
        param.put("historyKmbksBntzValue", "0.00");
        String isFirstQr = "false";
        if (isFirstPeriod) {
            if (dqqrList.contains(bbxmId)) {
                isFirstQr = "true";
            }
            param.put("isFirstPeriod", "true");
            param.put("isFirstQr", isFirstQr);
        } else {
            param.put("isFirstQr", isFirstQr);
            param.put("isFirstPeriod", "false");
            if (dqqrList.contains(bbxmId)) {
                param.put("isDqQr", "true");
                param.put("isDqWqr", "false");
                if (wqrToQrMap.containsKey(String.valueOf(bbxmId))) {
                    Map<String, String> cellValue = this.calculateHistoryCellValue(wqrToQrMap, String.valueOf(bbxmId), kmbksHisToryDataMap, month);
                    param.put("isWqrToQrMap", "true");
                    param.put("historyKmbksZdqsValue", ObjectUtils.isNotEmpty((Object)cellValue.get("zdqs")) ? cellValue.get("zdqs") : "0.00");
                    param.put("historyKmbksBntzValue", ObjectUtils.isNotEmpty((Object)cellValue.get("bntz")) ? cellValue.get("bntz") : "0.00");
                } else {
                    param.put("isWqrToQrMap", "false");
                }
                param.put("isQrToWqrMap", "false");
            } else if (dqwqrList.contains(bbxmId)) {
                param.put("isDqWqr", "true");
                param.put("isDqQr", "false");
                if (qrToWqrMap.containsKey(String.valueOf(bbxmId))) {
                    Map<String, String> cellValue = this.calculateHistoryCellValue(qrToWqrMap, String.valueOf(bbxmId), kmbksHisToryDataMap, month);
                    param.put("isQrToWqrMap", "true");
                    param.put("historyKmbksZdqsValue", ObjectUtils.isNotEmpty((Object)cellValue.get("zdqs")) ? cellValue.get("zdqs") : "0.00");
                    param.put("historyKmbksBntzValue", ObjectUtils.isNotEmpty((Object)cellValue.get("bntz")) ? cellValue.get("bntz") : "0.00");
                } else {
                    param.put("isQrToWqrMap", "false");
                }
                param.put("isWqrToQrMap", "false");
            }
        }
    }

    private Map<String, String> calculateHistoryCellValue(Map<String, Object> planMap, String bbId, Map<String, Map<String, String>> cellvalueMap, int month) {
        HashMap<String, String> resultMap = new HashMap<String, String>(12);
        resultMap.put("zdqs", "0.00");
        resultMap.put("bntz", "0.00");
        ImmutablePair immutablePair = (ImmutablePair)planMap.get(bbId);
        Date left = (Date)immutablePair.left;
        Date right = (Date)immutablePair.right;
        String value = "0";
        if (ObjectUtils.isNotEmpty((Object)right)) {
            String format = "";
            if (month == 0) {
                format = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)right)) + "_" + DateUtils.format((Date)right);
            } else {
                Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)right);
                Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)firstDateOfSeason);
                format = DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)firstDateOfSeason)) + "_" + DateUtils.format((Date)lastDateOfSeason);
            }
            if (cellvalueMap.containsKey(format)) {
                Map<String, String> bdxmMap = cellvalueMap.get(format);
                String dysds_bnbd_tz = bdxmMap.get("dysds_dysdsl#dysds_bnbd_tz") != null ? bdxmMap.get("dysds_dysdsl#dysds_bnbd_tz") : "0";
                String zcycgl_bnbd_tz = bdxmMap.get("zcycgl_kmbss#zcycgl_bnbd_tz") != null ? bdxmMap.get("zcycgl_kmbss#zcycgl_bnbd_tz") : "0";
                String zcycgl_bnbd_zdqs = bdxmMap.get("zcycgl_kmbss#zcycgl_bnbd_zdqs") != null ? bdxmMap.get("zcycgl_kmbss#zcycgl_bnbd_zdqs") : "0";
                String dysds_bnbd_zdqs = bdxmMap.get("dysds_dysdsl#dysds_bnbd_zdqs") != null ? bdxmMap.get("dysds_dysdsl#dysds_bnbd_zdqs") : "0";
                resultMap.put("bntz", new BigDecimal(dysds_bnbd_tz).multiply(new BigDecimal(zcycgl_bnbd_tz)).divide(new BigDecimal("100"), 2, 4).toString());
                resultMap.put("zdqs", new BigDecimal(zcycgl_bnbd_zdqs).multiply(new BigDecimal(dysds_bnbd_zdqs)).divide(new BigDecimal("100"), 2, 4).toString());
            }
        }
        return resultMap;
    }

    private Map<String, Map<String, Map<String, String>>> queryHistoryPeriodCellVaule(Map<String, Map<String, Object>> calculateFetchitemsPlan, List<Long> bbxmIdList, String templatetype, Long orgId, Date skssqq, Date skssqz, boolean isFirstPeriod) {
        if (isFirstPeriod) {
            return new HashMap<String, Map<String, Map<String, String>>>();
        }
        String accountsettype = "sdsjt_jt".equalsIgnoreCase(templatetype) ? "jtzt" : "bdzt";
        QFilter filter = new QFilter("accountsettype", "=", (Object)accountsettype);
        return this.queryMultiDetailDynCellValue(templatetype, orgId, skssqq, skssqz, filter, Arrays.asList("zcycgl_kmbss#zcycgl_bnbd_zdqs", "zcycgl_kmbss#zcycgl_bnbd_tz", "dysds_dysdsl#dysds_bnbd_zdqs", "dysds_dysdsl#dysds_bnbd_tz"));
    }

    private Map<String, Map<String, Map<String, String>>> queryMultiDetailDynCellValue(String templatetype, Long orgId, Date skssqq, Date skssqz, QFilter qFilter, List<String> cellItemList) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(12);
        int month = DateUtils.getMonthOfDate((Date)skssqz) - DateUtils.getMonthOfDate((Date)skssqq);
        DynamicObject[] dynamicObjects = ItpMultiDataQueryBussiness.queryMutliMainTableData(templatetype, orgId, DateUtils.getFirstDateOfYear((Date)skssqq), skssqz, qFilter);
        ArrayList<Long> idList = new ArrayList<Long>(12);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Date skssqq1 = dynamicObject.getDate("skssqq");
                Date skssqz1 = dynamicObject.getDate("skssqz");
                if (DateUtils.getMonthOfDate((Date)skssqz1) - DateUtils.getMonthOfDate((Date)skssqq1) != month) continue;
                idList.add(dynamicObject.getLong("id"));
            }
        }
        Map<String, Map<String, String>> historyDataMap = ItpMultiDataQueryBussiness.queryMultiDetailFixCellValue(idList, cellItemList);
        HashMap resultHistoryDataMap = new HashMap(12);
        if (ObjectUtils.isNotEmpty(historyDataMap)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String id = dynamicObject.getString("id");
                Date skssqq1 = dynamicObject.getDate("skssqq");
                Date skssqz1 = dynamicObject.getDate("skssqz");
                String mapkey = DateUtils.format((Date)skssqq1) + "_" + DateUtils.format((Date)skssqz1);
                if (!historyDataMap.containsKey(id)) continue;
                if (!resultHistoryDataMap.containsKey(mapkey)) {
                    HashMap objectObjectHashMap = new HashMap(2);
                    resultHistoryDataMap.put(mapkey, objectObjectHashMap);
                }
                ((Map)resultHistoryDataMap.get(mapkey)).putAll(historyDataMap.get(id));
                ((Map)resultHistoryDataMap.get(mapkey)).put("startDate", DateUtils.format((Date)skssqq1));
                ((Map)resultHistoryDataMap.get(mapkey)).put("endDate", DateUtils.format((Date)skssqz1));
            }
        }
        resultMap.put("kmbksHisToryDataMap", resultHistoryDataMap);
        return resultMap;
    }
}

