/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.fetchitem;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class FetchItemPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit kmdm = (BasedataEdit)this.getControl("parent");
        kmdm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"taxationsys"});
    }

    public void loadData(LoadDataEventArgs e) {
        this.setSaveButton();
    }

    private void setSaveButton() {
        String parentEntityId;
        long userId = RequestContext.get().getCurrUserId();
        IFormView view = this.getView();
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
        List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.getAllPermOrgs(this.getView(), "4715a0df000000ac");
        boolean canEdit = allPermOrgs.contains(RequestContext.get().getOrgId());
        this.getView().setEnable(Boolean.valueOf(canEdit), new String[]{"btnok"});
        if (this.getView().getParentView() != null && "itp_accessconfig".equalsIgnoreCase(parentEntityId = this.getView().getParentView().getEntityId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxationsys"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("parent".equals(key)) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys != null) {
                QFilter filter = new QFilter("taxationsys", "=", (Object)taxationsys.getLong("id"));
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
                formShowParameter.getTreeFilterParameter().getQFilters().add(filter);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"FetchItemPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxationsys".equals(name)) {
            this.getModel().setValue("parent", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            long bizTypeId;
            boolean isLeaf;
            Object id = this.getModel().getValue("id");
            if (Objects.isNull(id)) {
                return;
            }
            QFilter idFilter = new QFilter("id", "=", id);
            DynamicObject dbFetchItem = QueryServiceHelper.queryOne((String)"itp_fetchitem", (String)"id,number,name,isleaf,biztype", (QFilter[])new QFilter[]{idFilter});
            if (Objects.isNull(dbFetchItem)) {
                return;
            }
            boolean bl = isLeaf = dbFetchItem.get("isleaf") == null || dbFetchItem.getBoolean("isleaf");
            if (isLeaf) {
                return;
            }
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            long l = bizTypeId = bizType == null ? 0L : bizType.getLong("id");
            if (bizTypeId != dbFetchItem.getLong("biztype")) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("save", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u6570\u9879\u76ee\u5b58\u5728\u4e0b\u7ea7\u9879\u76ee\uff0c\u66f4\u6539\u4e1a\u52a1\u7c7b\u522b\u4f1a\u540c\u6b65\u66f4\u65b0\u4e0b\u7ea7\u9879\u76ee\u7684\u4e1a\u52a1\u7c7b\u522b\uff0c\u786e\u5b9a\u66f4\u6539\u5417\uff1f", (String)"FetchItemPlugin_2", (String)"taxc-itp", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        DynamicObject dataEntity;
        OperationResult operationResult;
        if ("save".equalsIgnoreCase(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult()) && (operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"itp_fetchitem", (DynamicObject[])new DynamicObject[]{dataEntity = this.getModel().getDataEntity()}, (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().close();
        }
    }
}

