/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.jtysbthan;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.itp.business.fetchdata.ItpJtThanFetchDataBussiness;
import kd.taxc.itp.business.license.ItpLicenseCheckBusiness;
import kd.taxc.itp.business.provision.jtplan.ItpJtPlanBussiness;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class AccrualDeclareThanMultiPlugin
extends AbstractDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public String getTemplateType() {
        return "jtzt".equalsIgnoreCase((String)this.getModel().getValue("zt_type")) ? "jtysbbd_jt" : "jtysbbd_bd";
    }

    protected String[] getTaxLimits() {
        return new String[]{"year"};
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String parameterValue;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = this.getPageCache().get("orgid");
        String endDate = this.getPageCache().get("skssqz");
        DeclareCompanyTypeUtils.getDeclareCompanyType((String)orgid, (String)endDate);
        if (customParams.get("checkisopenbyworkflow") != null) {
            this.getModel().setValue("checkisopenbyworkflow", (Object)true);
        }
        if ("tsbd".equalsIgnoreCase(parameterValue = this.getJtsdshjsbdParamValue())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"comparisontype"});
        }
    }

    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date endDate;
        Date startDate;
        this.initStartAndEndDate(true);
        String number = null;
        Long taxtionsysId = 1L;
        String zt_type = "bdzt";
        String papers_status = "A";
        getModel.setValue("zt_type", (Object)zt_type);
        getPageCache.put("zt_type", zt_type);
        List<Long> validTaxationsys = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
        if (validTaxationsys.size() > 0) {
            if (!validTaxationsys.contains(taxtionsysId)) {
                taxtionsysId = validTaxationsys.get(0);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AccrualDeclareThanMultiPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
        }
        getModel.setValue("taxationsys", (Object)taxtionsysId);
        getPageCache.put("taxationsys", String.valueOf(taxtionsysId));
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            papers_status = (String)customParams.get("papers_status");
        } else {
            startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
            endDate = DateUtils.getLastDateOfYear((Date)startDate);
        }
        getPageCache.put("dateChanged", "false");
        getModel.setValue("papers_status", (Object)papers_status);
        getPageCache.put("papers_status", papers_status);
        getModel.setValue("skssqq", (Object)startDate);
        getModel.setValue("skssqz", (Object)endDate);
        getPageCache.put("skssqq", DateUtils.format((Date)startDate));
        getPageCache.put("skssqz", DateUtils.format((Date)endDate));
        String parameterValue = this.getJtsdshjsbdParamValue();
        if ("fkbd".equalsIgnoreCase(parameterValue)) {
            this.getModel().setValue("comparisontype", (Object)"sdbd");
        } else {
            this.getModel().setValue("comparisontype", (Object)"sdhjbd");
        }
        number = this.createBillNumber(DateUtils.format((Date)startDate), DateUtils.format((Date)endDate));
        getModel.setValue("number", (Object)number);
        getPageCache.put("number", number);
    }

    private String getJtsdshjsbdParamValue() {
        String orgId = this.getPageCache().get("orgid");
        if (orgId == null) {
            return "";
        }
        return (String)SystemParamUtil.getAppParameter((String)"itp", (String)"jtsdshjsbd", (long)Long.parseLong(orgId));
    }

    private DynamicObject checkRecordIsexist(String maintable, String orgid, String type, String startDate, String endDate, QFilter qFilter) {
        DynamicObject dyo = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (long)Long.parseLong(orgid), (String)type, (String)startDate, (String)endDate, (QFilter)this.getDeclareMainQueryParams());
        return dyo;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        if ("org".equalsIgnoreCase(name)) {
            List<Long> isTaxpayerOrg = ItpTaxOrgCommonBusiness.queryTaxcMainOrgIdByIsTaxpayerWithPerm();
            qFilter = new QFilter("id", "in", isTaxpayerOrg);
            formShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            List<Long> validTaxationsys = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            qFilter.and("id", "in", validTaxationsys);
        }
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        if ("taxationsys".equalsIgnoreCase(name)) {
            if (null == this.getModel().getValue("org")) {
                this.getView().getPageCache().put("taxationsys", this.getModel().getDataEntity().getString("taxationsys.id"));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AccrualDeclareThanMultiPlugin_11", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getDataEntity().getDate("skssqq") == null) {
                this.getView().getPageCache().put("taxationsys", this.getModel().getDataEntity().getString("taxationsys.id"));
                return;
            }
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            String number = null;
            if (taxationsys == null) {
                this.getModel().setValue("taxationsys", (Object)((DynamicObject)changeData[0].getOldValue()).getLong("id"));
                return;
            }
            number = taxationsys.getString("number");
            if ("001".equalsIgnoreCase(number)) {
                Date startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
                Date endDate = DateUtils.getLastDateOfYear1((Date)startDate);
                this.getModel().setValue("skssqq", (Object)startDate);
                this.getModel().setValue("skssqz", (Object)endDate);
                this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
                this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            }
            this.getPageCache().put("taxationsys", taxationsys.getString("id"));
            this.getBillNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            if (this.setDefaultComparisonType(((DynamicObject)this.getModel().getValue("org")).getLong("id"), this.getModel().getValue("zt_type"), this.getModel().getValue("skssqq"), this.getModel().getValue("skssqz"), String.valueOf(this.getModel().getValue("comparisontype")), this.getTemplateType(), ((DynamicObject)changeData[0].getNewValue()).getLong("id"))) {
                return;
            }
            this.loadData(DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), DateUtils.stringToDate((String)this.getPageCache().get("skssqz")), true, this.isNeedRefresh());
        } else if ("zt_type".equalsIgnoreCase(name)) {
            if (null == this.getModel().getValue("org")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AccrualDeclareThanMultiPlugin_11", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().get("taxationsys") == null) {
                return;
            }
            this.getPageCache().put("zt_type", (String)this.getModel().getValue("zt_type"));
            this.getBillNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            if (this.setDefaultComparisonType(((DynamicObject)this.getModel().getValue("org")).getLong("id"), changeData[0].getNewValue(), this.getModel().getValue("skssqq"), this.getModel().getValue("skssqz"), String.valueOf(this.getModel().getValue("comparisontype")), this.getTemplateType(), ((DynamicObject)this.getModel().getValue("taxationsys")).getLong("id"))) {
                return;
            }
            this.loadData(DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), DateUtils.stringToDate((String)this.getPageCache().get("skssqz")), true, this.isNeedRefresh());
        } else if ("org".equalsIgnoreCase(name)) {
            if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("norefresh"))) {
                this.getPageCache().put("norefresh", null);
                return;
            }
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                boolean checkResult = ItpTaxOrgCommonBusiness.check(((DynamicObject)changeData[0].getOldValue()).get("id").toString(), appid, TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
                this.getPageCache().put("norefresh", "true");
                this.getModel().getDataEntity().set("org", changeData[0].getOldValue());
                if (checkResult) {
                    return;
                }
            }
            if (this.getModel().getDataEntity().getDate("skssqq") == null || this.getModel().getDataEntity().get("taxationsys") == null) {
                this.getPageCache().put("orgid", this.getModel().getDataEntity().getString("org.id"));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String orgid = org.getString("id");
            boolean checkResult = ItpTaxOrgCommonBusiness.check(this.getView(), orgid, appid, TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getPageCache().put("norefresh", "true");
                this.getModel().getDataEntity().set("org", changeData[0].getOldValue());
                return;
            }
            this.getPageCache().put("orgid", orgid);
            if (ObjectUtils.isEmpty((Object)this.getPageCache().get("orgid")) && ObjectUtils.isEmpty((Object)this.getModel().getValue("org"))) {
                return;
            }
            this.getBillNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            if (this.setDefaultComparisonType(this.getModel().getDataEntity().getLong("org.id"), this.getModel().getValue("zt_type"), this.getModel().getValue("skssqq"), this.getModel().getValue("skssqz"), String.valueOf(this.getModel().getValue("comparisontype")), this.getTemplateType(), ((DynamicObject)this.getModel().getValue("taxationsys")).getLong("id"))) {
                return;
            }
            this.loadData(DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), DateUtils.stringToDate((String)this.getPageCache().get("skssqz")), true, this.isNeedRefresh());
        } else if ("skssqq".equalsIgnoreCase(name)) {
            if (null == this.getModel().getValue("org")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AccrualDeclareThanMultiPlugin_11", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue("skssqq") == null) {
                this.getModel().setValue("skssqq", changeData[0].getOldValue());
                return;
            }
            if (this.getModel().getDataEntity().get("taxationsys") == null) {
                return;
            }
            this.getModel().setValue("skssqz", (Object)DateUtils.getLastDateOfYear((Date)this.getModel().getDataEntity().getDate("skssqq")));
            this.getBillNumber(DateUtils.format((Date)((Date)changeData[0].getNewValue())), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            if (this.setDefaultComparisonType(((DynamicObject)this.getModel().getValue("org")).getLong("id"), this.getModel().getValue("zt_type"), changeData[0].getNewValue(), this.getModel().getValue("skssqz"), String.valueOf(this.getModel().getValue("comparisontype")), this.getTemplateType(), ((DynamicObject)this.getModel().getValue("taxationsys")).getLong("id"))) {
                return;
            }
            this.loadData((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue("skssqz"), true, this.isNeedRefresh());
        } else if ("comparisontype".equalsIgnoreCase(name)) {
            if (!this.verifyComparisonTypeValue(String.valueOf(changeData[0].getNewValue()))) {
                this.getModel().setValue("comparisontype", changeData[0].getOldValue());
                return;
            }
            this.getModel().setValue("comparisontype", changeData[0].getNewValue());
            this.getBillNumber(DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))), DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))));
            this.loadData(DateUtils.stringToDate((String)this.getPageCache().get("skssqq")), DateUtils.stringToDate((String)this.getPageCache().get("skssqz")), true, this.isNeedRefresh());
        }
    }

    public void loadData(Date startDate, Date endDate, Boolean needMsg, boolean refresh) {
        ItpLicenseCheckBusiness.orgLicenseCheck(this.getModel().getDataEntity().getLong("org.id"));
        super.loadData(startDate, endDate, needMsg, refresh);
    }

    private boolean setDefaultComparisonType(Object orgId, Object ztType, Object skssqq, Object skssqz, String comparisonType, Object templateType, Object taxationSysId) {
        String paramValue = this.getJtsdshjsbdParamValue();
        this.getView().setVisible(Boolean.valueOf("fkbd".equalsIgnoreCase(paramValue)), new String[]{"comparisontype"});
        QFilter filter = new QFilter("org", "=", orgId).and("skssqq", "=", skssqq).and("skssqz", "=", skssqz).and("accountsettype", "=", ztType).and("templatetype", "=", templateType).and("taxsystem", "=", taxationSysId);
        Boolean checkResult = "fkbd".equalsIgnoreCase(paramValue) && Stream.of("sdbd", "hjbd").noneMatch(p -> p.equalsIgnoreCase(comparisonType)) || "tsbd".equalsIgnoreCase(paramValue) && !"sdhjbd".equalsIgnoreCase(comparisonType);
        if (checkResult.booleanValue() && !QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{filter, new QFilter("comparisontype", "=", (Object)comparisonType)})) {
            String defaultComparisonTypeValue = "tsbd".equalsIgnoreCase(paramValue) ? "sdhjbd" : ("fkbd".equalsIgnoreCase(paramValue) ? "sdbd" : "");
            this.getModel().setValue("comparisontype", (Object)defaultComparisonTypeValue);
            return true;
        }
        if ("fkbd".equalsIgnoreCase(paramValue) && "hjbd".equalsIgnoreCase(comparisonType) && !QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{filter, new QFilter("comparisontype", "=", (Object)"sdbd")})) {
            this.getModel().setValue("comparisontype", (Object)"sdbd");
            return true;
        }
        return false;
    }

    private boolean verifyComparisonTypeValue(String comparisonType) {
        if ("hjbd".equalsIgnoreCase(comparisonType)) {
            IDataModel model = this.getModel();
            QFilter qFilter = new QFilter("org", "=", (Object)((DynamicObject)model.getValue("org")).getLong("id")).and("skssqq", "=", model.getValue("skssqq")).and("skssqz", "=", model.getValue("skssqz")).and("accountsettype", "=", model.getValue("zt_type")).and("comparisontype", "=", (Object)"sdbd").and("billstatus", "=", (Object)"C").and("templatetype", "=", (Object)this.getTemplateType()).and("taxsystem", "=", (Object)((DynamicObject)model.getValue("taxationsys")).getLong("id"));
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (object == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u8bf7\u5148\u751f\u6210\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5ba1\u5b9a\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u3002", (String)"AccrualDeclareThanMultiPlugin_12", (String)"taxc-itp", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean beforeClickCheckStatus(String operateKey) {
        String orgId = this.getPageCache().get("orgid");
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)orgId)) {
            return false;
        }
        List<Long> isTaxpayerOrg = ItpTaxOrgCommonBusiness.queryTaxcMainOrgIdByIsTaxpayerWithPerm();
        if (!isTaxpayerOrg.contains(Long.valueOf(orgId.toString()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8be5\u7a0e\u5236\u7684\u7eb3\u7a0e\u4e3b\u4f53\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AccrualDeclareThanMultiPlugin_7", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        if (super.beforeClickCheckStatus(operateKey)) {
            if ("edit".equalsIgnoreCase(operateKey)) {
                String paramValue = this.getJtsdshjsbdParamValue();
                String comparisonType = String.valueOf(this.getModel().getValue("comparisontype"));
                Boolean checkResult = "fkbd".equalsIgnoreCase(paramValue) && Stream.of("sdbd", "hjbd").noneMatch(p -> p.equalsIgnoreCase(comparisonType)) || "tsbd".equalsIgnoreCase(paramValue) && "sdhjbd".equalsIgnoreCase(comparisonType);
                if (checkResult.booleanValue()) {
                    String defaultComparisonTypeValue = "tsbd".equalsIgnoreCase(paramValue) ? "sdhjbd" : ("fkbd".equalsIgnoreCase(paramValue) ? "sdbd" : "");
                    this.getModel().setValue("comparisontype", (Object)defaultComparisonTypeValue);
                }
            }
            return true;
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return;
        }
        ItpLicenseCheckBusiness.orgLicenseCheck(orgId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (this.getModel().getValue("org") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AccrualDeclareThanMultiPlugin_11", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("unaudit".equals(key)) {
            String isadjuest;
            DynamicObject auditedDeclareThanDraft = this.getAuditedDeclareThanDraft();
            if (!ObjectUtils.isEmpty((Object)auditedDeclareThanDraft) && !ObjectUtils.isEmpty((Object)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity")) && "yes".equals(isadjuest = ((DynamicObject)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity").get(0)).getString("isadjuest"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6821\u51c6\u5e95\u7a3f\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"AccrualDeclareThanMultiPlugin_5", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            QFilter checkFilter = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get("orgid"))).and("taxsystem", "=", (Object)((DynamicObject)this.getModel().getValue("taxationsys")).getLong("id")).and("accountsettype", "=", this.getModel().getValue("zt_type")).and("skssqq", "=", this.getModel().getValue("skssqq")).and("skssqz", "=", this.getModel().getValue("skssqz")).and("templatetype", "=", (Object)this.getTemplateType()).and("comparisontype", "=", (Object)"hjbd");
            if ("sdbd".equals(this.getModel().getValue("comparisontype")) && QueryServiceHelper.exists((String)this.getMainTable(), (QFilter[])new QFilter[]{checkFilter})) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s:\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u8bf7\u5148\u5220\u9664\u6c47\u7f34\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u3002", (String)"AccrualDeclareThanMultiPlugin_8", (String)"taxc-itp", (Object[])new Object[0]), this.getModel().getValue("number")));
                return;
            }
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private DynamicObject getAuditedDeclareThanDraft() {
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        QFilter qFilter = this.getUniversalQfilter().and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        qFilter.and("templatetype", "=", (Object)this.getTemplateType());
        return BusinessDataServiceHelper.loadSingle((String)"itp_accrualdec_than_list", (String)"id,taxsystem,accountsettype,billno,billstatus,org,skssqq,skssqz,templatetype,remarks,entryentity.isadjuest,entryentity,entryentity.seq", (QFilter[])new QFilter[]{qFilter});
    }

    private QFilter getUniversalQfilter() {
        Long orgid = this.getModel().getDataEntity().getLong("org.id");
        QFilter Qfilter = this.getDeclareMainQueryParams();
        return Qfilter.and("org", "=", (Object)this.getView().getModel().getDataEntity().getLong("org.id"));
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(4);
        bizParamsMap.put("billno", this.getView().getPageCache().get("number"));
        bizParamsMap.put("taxsystem", this.getView().getPageCache().get("taxationsys"));
        bizParamsMap.put("accountsettype", this.getView().getPageCache().get("zt_type"));
        bizParamsMap.put("billstatus", "A");
        bizParamsMap.put("createtime", new Date().toString());
        bizParamsMap.put("comparisontype", String.valueOf(this.getModel().getValue("comparisontype")));
        bizParamsMap.put("draftpurpose", "sbjtThan");
        bizParamsMap.put("taxtype", "3");
        bizParamsMap.put("taxareagroup", ItpJtPlanBussiness.getProvisionTaxareagroup(this.getModel().getDataEntity().getLong("org.id"), this.getModel().getDataEntity().getLong("taxationsys.id"), 3L, this.getModel().getDataEntity().getString("zt_type"), this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz")));
        return bizParamsMap;
    }

    public String createNumber(Date startDate, Date endDate) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_accrualdec_than_list");
        dynamicObject.set("org", (Object)this.getPageCache().get("orgid"));
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber("itp_accrualdec_than_list", dynamicObject, null);
        boolean isExists = QueryServiceHelper.exists((String)"itp_accrualdec_than_list", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (isExists) {
            codeRuleService.getNumber("itp_accrualdec_than_list", dynamicObject, null);
            number = codeRuleService.readNumber("itp_accrualdec_than_list", dynamicObject, null);
        }
        return number;
    }

    private String createBillNumber(String skssqq, String sksqz) {
        DynamicObject dynamicObject = this.checkRecordIsexist(MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), this.getPageCache().get("orgid"), this.getTemplateType(), skssqq, sksqz, this.getDeclareMainQueryParams());
        String cnumber = null;
        cnumber = dynamicObject != null ? dynamicObject.getString("billno") : this.createNumber(DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)sksqz));
        return cnumber;
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)this.getView().getPageCache().get("orgid"))) {
            return false;
        }
        return super.isValidDates(startDate, endDate, needMsg);
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        DynamicObject taxationSys = (DynamicObject)this.getModel().getValue("taxationsys");
        requestModel.setTaxationsys(taxationSys == null ? null : Long.valueOf(taxationSys.getLong("id")));
        if (requestModel.getRefresh().booleanValue()) {
            requestModel.getBusinessMap().putAll(ItpJtThanFetchDataBussiness.getFetchConfigParams(requestModel, ItpJtThanFetchDataBussiness.getFixedRowFetchDataItemIds()));
        }
        return requestModel;
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String number = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        String zt_type = customParams.get("zt_type") == null ? null : customParams.get("zt_type").toString();
        String papers_status = customParams.get("papers_status") == null ? null : customParams.get("papers_status").toString();
        String taxtionsysId = customParams.get("taxationsys") == null ? null : customParams.get("taxationsys").toString();
        String comparisonType = customParams.get("comparisontype") == null ? null : customParams.get("comparisontype").toString();
        this.setViewFiledVule(number, zt_type, papers_status, null, taxtionsysId, comparisonType);
        return customParams;
    }

    public void setViewFiledVule(String number, String zt_type, String papers_status, String comment, String taxtionsysId, String comparisonType) {
        this.getModel().setValue("number", (Object)number);
        this.getPageCache().put("number", number);
        this.getModel().setValue("zt_type", (Object)zt_type);
        this.getPageCache().put("zt_type", zt_type);
        this.getModel().setValue("papers_status", (Object)(papers_status == null ? "A" : papers_status));
        this.getPageCache().put("papers_status", papers_status == null ? "A" : papers_status);
        this.getModel().setValue("taxationsys", (Object)taxtionsysId);
        this.getPageCache().put("taxationsys", String.valueOf(taxtionsysId));
        this.getModel().setValue("comparisontype", (Object)comparisonType);
        this.getPageCache().put("comparisontype", comparisonType);
    }

    protected QFilter getDeclareMainQueryParams() {
        Long taxationsysId = Long.valueOf(this.getView().getPageCache().get("taxationsys"));
        String zt = this.getPageCache().get("zt_type");
        QFilter extendQflters = new QFilter("taxsystem", "=", (Object)taxationsysId);
        extendQflters.and("accountsettype", "=", (Object)zt);
        String comparisonType = String.valueOf(this.getModel().getValue("comparisontype"));
        extendQflters.and("comparisontype", "=", (Object)(comparisonType == null ? "" : comparisonType));
        return extendQflters;
    }

    private QFilter setDefaultQfilter() {
        Long taxationsysId = Long.valueOf(this.getView().getPageCache().get("taxationsys"));
        String zt = this.getPageCache().get("zt_type");
        QFilter defaultQfilter = new QFilter("org", "=", (Object)Long.valueOf(this.getView().getPageCache().get("orgid"))).and("skssqq", "=", (Object)DateUtils.stringToDate((String)this.getView().getPageCache().get("skssqq"))).and("skssqz", "=", (Object)DateUtils.stringToDate((String)this.getView().getPageCache().get("skssqz"))).and("templatetype", "=", (Object)this.getTemplateType()).and("taxsystem", "=", (Object)taxationsysId).and("accountsettype", "=", (Object)zt).and("comparisontype", "=", this.getModel().getValue("comparisontype"));
        return defaultQfilter;
    }

    private void getBillNumber(String sksqq, String sksqz) {
        String cnumber = this.createBillNumber(sksqq, sksqz);
        this.getModel().setValue("number", (Object)cnumber);
        this.getModel().setDataChanged(false);
        this.getPageCache().put("number", cnumber);
    }

    private boolean isNeedRefresh() {
        boolean isExists = QueryServiceHelper.exists((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (QFilter[])new QFilter[]{this.setDefaultQfilter()});
        boolean refresh = Boolean.FALSE;
        if (!isExists) {
            refresh = Boolean.TRUE;
        }
        return refresh;
    }

    private boolean isAnIntersection(Long orgId, Long taxsystemId, Date sksqq, Date sksqz, String zt, String comparisonType) {
        boolean refresh = Boolean.FALSE;
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)this.getTemplateType()).and("taxsystem", "=", (Object)taxsystemId).and("accountsettype", "=", (Object)zt).and("comparisontype", "=", (Object)comparisonType);
        QFilter dateQfilter = new QFilter("skssqq", ">=", (Object)sksqq).and("skssqq", "<=", (Object)sksqz);
        QFilter q1 = new QFilter("skssqq", "<=", (Object)sksqq).and("skssqz", ">=", (Object)sksqz);
        QFilter q2 = new QFilter("skssqz", ">=", (Object)sksqq).and("skssqz", "<=", (Object)sksqz);
        dateQfilter.or(q1);
        dateQfilter.or(q2);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter, dateQfilter});
        if (dynamicObject == null) {
            refresh = Boolean.TRUE;
        }
        return refresh;
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        if ("A".equals(billstatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"comment"});
        } else if ("B".equals(billstatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"comment"});
        } else if ("C".equals(billstatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"comment"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"comment"});
        }
    }

    public void save() {
        String number = this.getPageCache().get("number");
        Long orgId = Long.valueOf(this.getPageCache().get("orgid"));
        List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.getAllPermOrgs(this.getView(), "4715a0df000000ac");
        if (!allPermOrgs.contains(orgId)) {
            return;
        }
        Long taxsystem = Long.valueOf(this.getPageCache().get("taxationsys"));
        Date skssq = (Date)this.getModel().getValue("skssqq");
        Date skssz = (Date)this.getModel().getValue("skssqz");
        String zt = this.getPageCache().get("zt_type");
        String comparisonType = String.valueOf(this.getModel().getValue("comparisontype"));
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("accountsettype", "=", (Object)zt).and("comparisontype", "=", (Object)comparisonType);
        qFilter.and(new QFilter("templatetype", "=", (Object)this.getTemplateType()));
        String entityName = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,org,number,skssqq,skssqz,taxsystem,accountsettype,comparisontype", (QFilter[])new QFilter[]{qFilter});
        if (obj != null && taxsystem.longValue() != obj.getLong("taxsystem.id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u7ec4\u7ec7\u540c\u4e00\u6bd4\u5bf9\u5e74\u5ea6\u540c\u4e00\u6bd4\u5bf9\u7c7b\u578b\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AccrualDeclareThanMultiPlugin_9", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,org,number,skssqq,skssqz,taxsystem,accountsettype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (dynamicObject != null) {
            long orgid = dynamicObject.getLong("org.id");
            long taxsystemId = dynamicObject.getLong("taxsystem.id");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            String accountsettype = dynamicObject.getString("accountsettype");
            if (!(orgId == orgid && taxsystem == taxsystemId && skssq.equals(skssqq) && skssz.equals(skssqz) && zt.equalsIgnoreCase(accountsettype))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u53f7\u5df2\u5b58\u5728\u3002", (String)"AccrualDeclareThanMultiPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
        } else {
            boolean intersection = this.isAnIntersection(orgId, taxsystem, skssq, skssz, zt, comparisonType);
            if (!intersection) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u7684\u6bd4\u5bf9\u5e74\u5ea6\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\u3002", (String)"AccrualDeclareThanMultiPlugin_4", (String)"taxc-itp", (Object[])new Object[0]), new Object[0]));
                return;
            }
        }
        QFilter checkFilter = new QFilter("org", "=", (Object)orgId).and("taxsystem", "=", (Object)taxsystem).and("accountsettype", "=", (Object)zt).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("templatetype", "=", (Object)this.getTemplateType()).and("billno", "!=", (Object)number);
        List comparisonTypes = Stream.of("sdbd", "hjbd").collect(Collectors.toList());
        if (comparisonTypes.contains(comparisonType)) {
            checkFilter.and("comparisontype", "=", (Object)"sdhjbd");
        } else if ("sdhjbd".equalsIgnoreCase(comparisonType)) {
            checkFilter.and("comparisontype", "in", comparisonTypes);
        }
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{checkFilter})) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u8868\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"AccrualDeclareThanMultiPlugin_10", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        if (!this.verifyComparisonTypeValue(comparisonType)) {
            return;
        }
        super.save();
    }

    protected String getUniKey() {
        String orgId = this.getPageCache().get("orgid");
        String taxsystem = this.getPageCache().get("taxationsys");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        String zt = this.getPageCache().get("zt_type");
        return String.format("%s_%s_%s_%s_%s_%s", orgId, taxsystem, skssq, skssz, zt, this.getTemplateType());
    }

    protected boolean viewDialog() {
        return Boolean.FALSE;
    }
}

