/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.jtysbthan;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.fetchdata.ItpJtThanFetchDataBussiness;
import kd.taxc.itp.business.papers.ItpDraftBussiness;
import kd.taxc.itp.business.systemParameter.ItpSystemParameterBussiness;
import org.apache.commons.lang3.ObjectUtils;

public class JtysbThanInitParams
implements InitParams {
    private static final Log logger = LogFactory.getLog(JtysbThanInitParams.class);
    public static final String PRE_YEAR_END_SBBID = "preyearendsbbid";
    public static final String INITDATA_SDSDYJTS = "sdsdyjts";
    public static final String CUR_YEAR_SDBD_SBBID = "curyearsdbdsbbid";

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> fetchAccessconfigMap;
        Map param = super.buildBizParam(requestModel);
        param.put("draftpurpose", "sbjtThan");
        Date endDate = DateUtils.stringToDate((String)requestModel.getSkssqz());
        String str = new SimpleDateFormat("yyyy").format(endDate.getTime()) + "-12-31 00:00:00";
        Date preEndData = DateUtils.stringToDate((String)str, (String)"yyyy-MM-dd HH:mm:ss");
        String accountsetType = (String)requestModel.getBusinessMap().get("accountsettype");
        String templateType = "sdsjt_bd";
        if (StringUtil.isNotEmpty((CharSequence)accountsetType) && StringUtil.equalsIgnoreCase((CharSequence)accountsetType, (CharSequence)"jtzt")) {
            templateType = "sdsjt_jt";
        }
        String itpZcjtsqz = ItpSystemParameterBussiness.getItpZcjtsqz(requestModel.getOrgId());
        param.put("itpZcjtsqz", itpZcjtsqz);
        QFilter qFilter = null;
        boolean isadjustperiod = false;
        if ("qmyeThirteen".equals(itpZcjtsqz) || "bnjtThirteen".equals(itpZcjtsqz)) {
            qFilter = new QFilter("adjustperiod", "=", (Object)"13");
            isadjustperiod = true;
        }
        String preSbbid = ItpDraftBussiness.getPreSbbId(requestModel.getOrgId(), templateType, requestModel.getTaxationsys(), null, preEndData, isadjustperiod, qFilter);
        param.put(PRE_YEAR_END_SBBID, "-1");
        if (ObjectUtils.isNotEmpty((Object)preSbbid)) {
            param.put(PRE_YEAR_END_SBBID, preSbbid);
        }
        param.put(INITDATA_SDSDYJTS, "0");
        String initdataParam = ItpSystemParameterBussiness.getItpInitdata(requestModel.getOrgId());
        param.put(INITDATA_SDSDYJTS, initdataParam);
        String thirteenSbbid = "-1";
        if (isadjustperiod) {
            thirteenSbbid = preSbbid;
        } else {
            QFilter filter = new QFilter("adjustperiod", "=", (Object)"13");
            thirteenSbbid = ItpDraftBussiness.getPreSbbId(requestModel.getOrgId(), templateType, requestModel.getTaxationsys(), null, preEndData, true, filter);
        }
        param.put("thirteenSbbid", thirteenSbbid);
        Map businessMap = requestModel.getBusinessMap();
        if ("hjbd".equals(businessMap.get("comparisontype"))) {
            QFilter filter = new QFilter("org", "=", (Object)requestModel.getOrgId()).and("skssqq", "=", (Object)DateUtils.stringToDate((String)requestModel.getSkssqq())).and("skssqz", "=", (Object)DateUtils.stringToDate((String)requestModel.getSkssqz())).and("accountsettype", "=", (Object)accountsetType).and("templatetype", "=", (Object)requestModel.getTemplateType()).and("taxsystem", "=", (Object)Long.parseLong((String)businessMap.get("taxsystem"))).and("comparisontype", "=", (Object)"sdbd");
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{filter});
            param.put(CUR_YEAR_SDBD_SBBID, dynamicObject == null ? "" : dynamicObject.getString("id"));
        }
        if ((fetchAccessconfigMap = ItpJtThanFetchDataBussiness.getFetchAccessconfigMap(requestModel, ItpJtThanFetchDataBussiness.getFixedRowFetchDataItemIds())).containsKey("1544976649957721088_entryentity")) {
            param.put("dqsds_sqlr_bd", "1");
        } else {
            param.put("dqsds_sqlr_bd", "0");
        }
        if (fetchAccessconfigMap.containsKey("1544976649957721088_entryentity1")) {
            param.put("dqsds_sqlr_bd_hjs", "1");
        } else {
            param.put("dqsds_sqlr_bd_hjs", "0");
        }
        if (fetchAccessconfigMap.containsKey("1544976651065366528_entryentity")) {
            param.put("dqsds_sqlr_jt", "1");
        } else {
            param.put("dqsds_sqlr_jt", "0");
        }
        if (fetchAccessconfigMap.containsKey("1544976651065366528_entryentity1")) {
            param.put("dqsds_sqlr_jt_hjs", "1");
        } else {
            param.put("dqsds_sqlr_jt_hjs", "0");
        }
        if (fetchAccessconfigMap.containsKey("1947992929025288192_entryentity")) {
            param.put("dqsds_sedm_sds", "1");
        } else {
            param.put("dqsds_sedm_sds", "0");
        }
        if (fetchAccessconfigMap.containsKey("1947992929025288192_entryentity1")) {
            param.put("dqsds_sedm_hjs", "1");
        } else {
            param.put("dqsds_sedm_hjs", "0");
        }
        logger.info("JtysbThanInitParams initParams : {}", (Object)JsonUtil.toJson((Object)param));
        return param;
    }
}

