/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.jtysbthan.dyn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import org.apache.commons.lang3.ObjectUtils;

public abstract class BaseThanDynRowPlugin
extends AbstractDynamicListBasePlugin {
    protected abstract String useBizTypeNumber();

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String preYearEndSbbId = (String)bussinessParamsVo.getExtendParams().get("preyearendsbbid");
        Object taxSysyemO = bussinessParamsVo.getExtendParams().get("taxsystem");
        Long taxSystem = taxSysyemO instanceof Long ? (Long)taxSysyemO : Long.valueOf(taxSysyemO.toString());
        FetchItemBizTypeEnum bizTypeEnum = FetchItemBizTypeEnum.getEnumByNumber(this.useBizTypeNumber());
        if (null == bizTypeEnum) {
            return null;
        }
        return bizTypeEnum.buildDynMap(Long.parseLong(bussinessParamsVo.getOrgId()), preYearEndSbbId, taxSystem);
    }

    static enum FetchItemBizTypeEnum {
        YWLB0001("YWLB0001", "dqsds_zsxcy_cyxm#1"){

            @Override
            protected Map<String, Map<String, String>> queryCellValue(long orgId, String preYearEndSbbId, String dynRowNo, String bbxmEndNumber, String amountEndNumber) {
                String zcjtsqzParam = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"zcjtsqz", (long)orgId);
                if (StringUtil.equalsIgnoreCase((CharSequence)zcjtsqzParam, (CharSequence)"bnjt")) {
                    return super.queryCellValue(orgId, preYearEndSbbId, dynRowNo, bbxmEndNumber, amountEndNumber);
                }
                String zchycglDynRowNo = "zcycgl_zsxcy_cyxm#1";
                return super.queryCellValue(orgId, preYearEndSbbId, zchycglDynRowNo, this.zcycglBbxmEndNumber, this.queryQmyeEndNumber);
            }
        }
        ,
        YWLB0002("YWLB0002", "dqsds_yjxcy_cyxm#1"),
        YWLB0003("YWLB0003", "dqsds_jnsejm_xm#1"),
        YWLB0010("YWLB0010", "dqsds_jwsedm_xm#1"),
        YWLB0004("YWLB0004", "dqsds_gaaptz_cyxm#1"){

            @Override
            protected Map<String, Map<String, String>> queryCellValue(long orgId, String preYearEndSbbId, String dynRowNo, String bbxmEndNumber, String amountEndNumber) {
                String zcjtsqzParam = (String)SystemParamUtil.getAppParameter((String)"itp", (String)"zcjtsqz", (long)orgId);
                if (StringUtil.equalsIgnoreCase((CharSequence)zcjtsqzParam, (CharSequence)"bnjt")) {
                    return super.queryCellValue(orgId, preYearEndSbbId, dynRowNo, bbxmEndNumber, amountEndNumber);
                }
                HashMap<String, Map<String, String>> totalMap = new HashMap<String, Map<String, String>>();
                String zchycglDynRowNo = "zcycgl_gaap_zsxcy_cyxm#1";
                String zchycglyjxcyDynRowNo = "zcycgl_gaap_yjxcy_cyxm#1";
                totalMap.putAll(super.queryCellValue(orgId, preYearEndSbbId, zchycglDynRowNo, this.zcycglBbxmEndNumber, this.queryQmyeEndNumber));
                totalMap.putAll(super.queryCellValue(orgId, preYearEndSbbId, zchycglyjxcyDynRowNo, this.zcycglBbxmEndNumber, this.queryQmyeEndNumber));
                return totalMap;
            }

            @Override
            protected List<Map<String, Object>> buildDynMap(long orgId, String preYearEndSbbId, Long taxSystem) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                ArrayList<String> allFetchItemList = new ArrayList<String>();
                allFetchItemList.addAll(this.queryFetchItem(YWLB0004.getNumber(), taxSystem));
                allFetchItemList.addAll(this.queryFetchItem(YWLB0005.getNumber(), taxSystem));
                allFetchItemList.addAll(this.queryFetchItem(YWLB0006.getNumber(), taxSystem));
                String dynRowNo = this.getDynRowNo();
                if (ObjectUtils.isNotEmpty(allFetchItemList)) {
                    Map<String, Map<String, String>> map = this.queryCellValue(orgId, preYearEndSbbId, dynRowNo, this.bbxmEndNumber, this.queryHjEndNumber);
                    LinkedHashMap<String, String> fetchItemValueMap = new LinkedHashMap<String, String>(allFetchItemList.size());
                    if (ObjectUtils.isNotEmpty(map)) {
                        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                            Map<String, String> subMap = entry.getValue();
                            fetchItemValueMap.put(subMap.get(FetchItemBizTypeEnum.KEY_BBXM), subMap.get(FetchItemBizTypeEnum.KEY_AMOUNT));
                        }
                    }
                    allFetchItemList.stream().filter(id -> !fetchItemValueMap.containsKey(id)).forEach(id -> fetchItemValueMap.put((String)id, String.valueOf(0)));
                    int index = 1;
                    for (Map.Entry row : fetchItemValueMap.entrySet()) {
                        HashMap<String, Object> dynRowMap = new HashMap<String, Object>(2);
                        dynRowMap.put(dynRowNo.substring(0, dynRowNo.lastIndexOf("1")) + index + "#" + this.bbxmEndNumber, row.getKey());
                        dynRowMap.put(dynRowNo.substring(0, dynRowNo.lastIndexOf("1")) + index + "#" + this.JTYSBBD_JTS, row.getValue());
                        ++index;
                        list.add(dynRowMap);
                    }
                }
                return list;
            }
        }
        ,
        YWLB0005("YWLB0005", "dqsds_gaaptz_cyxm#1"),
        YWLB0006("YWLB0006", "dqsds_gaaptz_cyxm#1");

        private String number;
        private String dynRowNo;
        protected String zcycglBbxmEndNumber = "zcycgl_bbxm";
        protected String queryQmyeEndNumber = "zcycgl_qmye";
        protected String bbxmEndNumber = "dqsds_bbxm";
        protected String queryHjEndNumber = "dqsds_hj";
        protected String JTYSBBD_JTS = "jtysbbd_jts";
        private static final String KEY_BBXM = "bbxm";
        private static final String KEY_AMOUNT = "amount";

        protected List<Map<String, Object>> buildDynMap(long orgId, String preYearEndSbbId, Long taxSystem) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            List<String> fetchItemList = this.queryFetchItem(this.number, taxSystem);
            if (ObjectUtils.isNotEmpty(fetchItemList)) {
                Map<String, Map<String, String>> map = this.queryCellValue(orgId, preYearEndSbbId, this.dynRowNo, this.bbxmEndNumber, this.queryHjEndNumber);
                LinkedHashMap<String, String> fetchItemValueMap = new LinkedHashMap<String, String>(fetchItemList.size());
                if (ObjectUtils.isNotEmpty(map)) {
                    for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                        Map<String, String> subMap = entry.getValue();
                        fetchItemValueMap.put(subMap.get(KEY_BBXM), subMap.get(KEY_AMOUNT));
                    }
                }
                fetchItemList.stream().filter(id -> !fetchItemValueMap.containsKey(id)).forEach(id -> fetchItemValueMap.put((String)id, "0"));
                int index = 1;
                for (Map.Entry row : fetchItemValueMap.entrySet()) {
                    HashMap<String, Object> dynRowMap = new HashMap<String, Object>(2);
                    dynRowMap.put(this.dynRowNo.substring(0, this.dynRowNo.lastIndexOf("1")) + index + "#" + this.bbxmEndNumber, row.getKey());
                    dynRowMap.put(this.dynRowNo.substring(0, this.dynRowNo.lastIndexOf("1")) + index + "#" + this.JTYSBBD_JTS, row.getValue());
                    ++index;
                    list.add(dynRowMap);
                }
            }
            return list;
        }

        protected Map<String, Map<String, String>> queryCellValue(long orgId, String preYearEndSbbId, String dynRowNo, String bbxmEndNumber, String amountEndNumber) {
            HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(8);
            if (StringUtil.isEmpty((CharSequence)preYearEndSbbId)) {
                return resultMap;
            }
            QFilter entryidQ = new QFilter("entryid", "=", (Object)Long.parseLong(preYearEndSbbId));
            QFilter dynRowNoQ = new QFilter("dynrowno", "=", (Object)dynRowNo);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"index,cellnumber,value", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ});
            collection.stream().forEach(row -> {
                String index = row.getString("index");
                if (!resultMap.containsKey(index)) {
                    HashMap map = new HashMap();
                    resultMap.put(index, map);
                }
                if (row.getString("cellnumber").endsWith(bbxmEndNumber)) {
                    ((Map)resultMap.get(index)).put(KEY_BBXM, row.getString("value"));
                } else if (row.getString("cellnumber").endsWith(amountEndNumber)) {
                    ((Map)resultMap.get(index)).put(KEY_AMOUNT, row.getString("value"));
                }
            });
            return resultMap;
        }

        protected List<String> queryFetchItem(String bizTypeNumber, Long taxationSys) {
            QFilter enableQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter taxSystemQ = new QFilter("taxationsys", "=", (Object)taxationSys);
            QFilter bizTypeNumberQ = new QFilter("biztype.number", "=", (Object)bizTypeNumber);
            QFilter isLeafQ = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{enableQ, taxSystemQ, bizTypeNumberQ, isLeafQ});
            return collection.stream().map(row -> row.getString("id")).collect(Collectors.toList());
        }

        private FetchItemBizTypeEnum(String number, String dynRowNo) {
            this.number = number;
            this.dynRowNo = dynRowNo;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDynRowNo() {
            return this.dynRowNo;
        }

        public static FetchItemBizTypeEnum getEnumByNumber(String number) {
            for (FetchItemBizTypeEnum bizTypeEnum : FetchItemBizTypeEnum.values()) {
                if (!bizTypeEnum.getNumber().equals(number)) continue;
                return bizTypeEnum;
            }
            return null;
        }
    }
}

