/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.jtysbthan.dyn;

import com.google.common.collect.ImmutableBiMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.itp.business.fetchitem.FetchItemsBussiness;
import kd.taxc.itp.business.jtysbthanrule.ItpJtThanDynCalculateServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class NewBaseThanDynRowPlugin
extends AbstractDynamicListBasePlugin {
    private static final Log logger = LogFactory.getLog(NewBaseThanDynRowPlugin.class);
    private static Map<String, String> fetchEntryAndReportItemMapping = new HashMap<String, String>(12);

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        AccessProjectBizTypeEnum accessProjectBizType = this.getAccessProjectBizType();
        return this.buildDynMap(bussinessParamsVo, accessProjectBizType);
    }

    protected abstract AccessProjectBizTypeEnum getAccessProjectBizType();

    public List<Map<String, Object>> buildDynMap(BussinessParamsVo bussinessParamsVo, AccessProjectBizTypeEnum accessProjectBizTypeEnum) {
        AccessProjectBizTypeEnum accessProjectBizType = this.getAccessProjectBizType();
        logger.info("AccessProjectBizTypeEnum:{}", (Object)accessProjectBizType);
        long taxSystem = Long.parseLong(bussinessParamsVo.getExtendParams().get("taxsystem").toString());
        List<String> fetchItemIds = this.queryFetchItemIds(accessProjectBizType.getNumber(), taxSystem);
        if (CollectionUtils.isEmpty(fetchItemIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        Map<String, Map<String, String>> allCellValue = this.getAllCellValue(bussinessParamsVo, accessProjectBizTypeEnum, fetchItemIds);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(allCellValue.size());
        int index = 1;
        for (Map.Entry<String, Map<String, String>> row : allCellValue.entrySet()) {
            if (!fetchItemIds.contains(row.getKey())) continue;
            HashMap<String, String> rowCellValues = new HashMap<String, String>(row.getValue().size());
            for (Map.Entry<String, String> cellValue : row.getValue().entrySet()) {
                rowCellValues.put(accessProjectBizTypeEnum.getDynRowNo().substring(0, accessProjectBizTypeEnum.getDynRowNo().lastIndexOf("1")) + index + "#" + cellValue.getKey(), cellValue.getValue());
            }
            result.add(rowCellValues);
            ++index;
        }
        Long templateId = (Long)bussinessParamsVo.getExtendParams().get("templateId");
        Long taxSystemId = Long.parseLong((String)bussinessParamsVo.getExtendParams().get("taxsystem"));
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        List<Long> fids = fetchItemIds.stream().mapToLong(o -> Long.parseLong(o)).boxed().collect(Collectors.toList());
        DynamicObjectCollection fetchItemByIds = FetchItemsBussiness.getFetchItemByIds(fids);
        if (ObjectUtils.isNotEmpty((Object)fetchItemByIds)) {
            RuleFetchMainDto ruleFetchMainDto = this.calculateRuleAccess(orgId, templateId, taxSystemId, startDate, endDate, fetchItemByIds);
            if (ObjectUtils.isNotEmpty((Object)ruleFetchMainDto)) {
                Set<Map.Entry<String, String>> entries;
                if (!"hjbd".equalsIgnoreCase(bussinessParamsVo.getExtendParams().get("comparisontype").toString()) && ObjectUtils.isNotEmpty(fetchEntryAndReportItemMapping)) {
                    entries = fetchEntryAndReportItemMapping.entrySet();
                    entries.stream().forEach(o -> {
                        if ("entryentity".equals(o.getKey())) {
                            this.calculateRuleAccessResultByFetchEntity(result, ruleFetchMainDto, accessProjectBizTypeEnum, (String)o.getKey(), (String)o.getValue());
                        }
                    });
                }
                if (!"sdbd".equalsIgnoreCase(bussinessParamsVo.getExtendParams().get("comparisontype").toString()) && ObjectUtils.isNotEmpty(fetchEntryAndReportItemMapping)) {
                    entries = fetchEntryAndReportItemMapping.entrySet();
                    entries.stream().forEach(o -> {
                        if ("entryentity1".equals(o.getKey())) {
                            this.calculateRuleAccessResultByFetchEntity(result, ruleFetchMainDto, accessProjectBizTypeEnum, (String)o.getKey(), (String)o.getValue());
                        }
                    });
                }
            }
            if (ObjectUtils.isNotEmpty((Object)ruleFetchMainDto) && ruleFetchMainDto.getRuleFetchCellSummaryList().size() > 0) {
                RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
                List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
                logger.info("ruleFetchCellSummaryList:{}", (Object)ruleFetchCellSummaryList.size());
                ArrayList ruleFetchCardDtoList = new ArrayList(12);
                for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
                    if (!ObjectUtils.isNotEmpty((Object)ruleFetchCellSummaryDto.getRuleFetchCardList())) continue;
                    ruleFetchCardDtoList.addAll(ruleFetchCellSummaryDto.getRuleFetchCardList());
                }
                logger.info("ruleFetchCellSummaryDto : {}", (Object)JsonUtil.toJson(ruleFetchCardDtoList));
                ruleFetchService.addCellData(ruleFetchMainDto);
                logger.info("ruleFetchCellSummaryList save success");
            }
        }
        return result;
    }

    public void calculateRuleAccessResultByFetchEntity(List<Map<String, Object>> result, RuleFetchMainDto ruleFetchMainDto, AccessProjectBizTypeEnum accessProjectBizTypeEnum, String fetchEntity, String suffix) {
        Map<Long, BigDecimal> calculateRuleAccessResult = ruleFetchMainDto.getRuleFetchCellSummaryList().stream().filter(o -> fetchEntity.equals(o.getFetchEntryentity())).collect(Collectors.toMap(cell -> Long.parseLong(cell.getRuleItem()), cell -> cell.getAmount() == null ? BigDecimal.ZERO : cell.getAmount().setScale(2, RoundingMode.HALF_UP)));
        if (ObjectUtils.isEmpty(calculateRuleAccessResult)) {
            return;
        }
        logger.info("\u5f97\u5230\u53d6\u6570\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJson(calculateRuleAccessResult));
        Iterator<Map<String, Object>> iterator = result.iterator();
        int i = 0;
        String bbxPrefix = accessProjectBizTypeEnum.getDynRowNo().substring(0, accessProjectBizTypeEnum.getDynRowNo().lastIndexOf("1"));
        while (iterator.hasNext()) {
            Map<String, Object> next = iterator.next();
            Long bbxmId = ObjectUtils.isNotEmpty((Object)next.get(bbxPrefix + ++i + "#dqsds_bbxm")) ? Long.parseLong(next.get(bbxPrefix + i + "#dqsds_bbxm").toString()) : 0L;
            if (!calculateRuleAccessResult.containsKey(bbxmId)) continue;
            next.put(bbxPrefix + i + suffix, calculateRuleAccessResult.get(bbxmId));
            this.setReportItem(next.get(bbxPrefix + i + "#dqsds_bbxm").toString(), bbxPrefix + i + suffix, ruleFetchMainDto, fetchEntity);
        }
    }

    private void setReportItem(String xmId, String coordinate, RuleFetchMainDto fetchMainDto, String fetchEntity) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (!summaryDto.getRuleItem().equalsIgnoreCase(xmId) || !fetchEntity.equals(summaryDto.getFetchEntryentity())) continue;
            summaryDto.setReportItem(coordinate);
        }
    }

    public List<String> queryFetchItemIds(String bizTypeNumber, Long taxationSys) {
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("taxationsys", "=", (Object)taxationSys).and("biztype.number", "=", (Object)bizTypeNumber).and("isleaf", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id", (QFilter[])new QFilter[]{queryFilter});
        return collection.stream().map(row -> row.getString("id")).collect(Collectors.toList());
    }

    public Map<String, Map<String, String>> getAllCellValue(BussinessParamsVo businessParamsVo, AccessProjectBizTypeEnum accessProjectBizTypeEnum, List<String> fetchItemIds) {
        Map extendParams = businessParamsVo.getExtendParams();
        if ("hjbd".equalsIgnoreCase(extendParams.get("comparisontype").toString())) {
            Map<String, Map<String, String>> cellValues = this.querySdbdCellValue(businessParamsVo, accessProjectBizTypeEnum);
            Map<String, Map<String, String>> noneDataValues = this.handleNotExistDataFetchItem(fetchItemIds, cellValues, accessProjectBizTypeEnum, Stream.of(accessProjectBizTypeEnum.getReportItemMark(), "jtysbbd_jts", "jtysbbd_sds").collect(Collectors.toList()));
            noneDataValues.putAll(cellValues);
            return noneDataValues;
        }
        long sbbid = Long.parseLong(extendParams.get("preyearendsbbid").toString());
        HashMap<String, String> columnDimensionMap = new HashMap<String, String>(2);
        columnDimensionMap.put("dqsds_hj", "jtysbbd_jts");
        columnDimensionMap.put("dqsds_bbxm", accessProjectBizTypeEnum.getReportItemMark());
        Map<String, Map<String, String>> cellValues = this.queryCellValue(sbbid, accessProjectBizTypeEnum, accessProjectBizTypeEnum.getDynRowNo(), columnDimensionMap);
        Map<String, Map<String, String>> noneDataValues = this.handleNotExistDataFetchItem(fetchItemIds, cellValues, accessProjectBizTypeEnum, Stream.of(accessProjectBizTypeEnum.getReportItemMark(), "jtysbbd_jts").collect(Collectors.toList()));
        noneDataValues.putAll(cellValues);
        HashMap<String, Map<String, String>> thirteenDraftCellValues = new HashMap<String, Map<String, String>>(12);
        if (this.checkSdsIsFetchDataFromThirteen(extendParams)) {
            long thirteenSbbid = Long.parseLong(extendParams.get("thirteenSbbid").toString());
            thirteenDraftCellValues.putAll(this.queryCellValue(thirteenSbbid, accessProjectBizTypeEnum, accessProjectBizTypeEnum.getDynRowNo(), columnDimensionMap));
        }
        for (Map.Entry<String, Map<String, String>> cellValue : noneDataValues.entrySet()) {
            String sdsValue = BigDecimal.ZERO.toString();
            if (this.checkSdsIsEqualToJts(extendParams)) {
                sdsValue = cellValue.getValue().get("jtysbbd_jts");
            } else if (this.checkSdsIsFetchDataFromThirteen(extendParams)) {
                sdsValue = thirteenDraftCellValues.containsKey(cellValue.getKey()) ? (String)((Map)thirteenDraftCellValues.get(cellValue.getKey())).get("jtysbbd_jts") : "0.00";
            }
            cellValue.getValue().put("jtysbbd_sds", sdsValue);
        }
        return noneDataValues;
    }

    public Map<String, Map<String, String>> querySdbdCellValue(BussinessParamsVo businessParamsVo, AccessProjectBizTypeEnum accessProjectBizTypeEnum) {
        long sbbid = Long.parseLong(businessParamsVo.getExtendParams().get("curyearsdbdsbbid").toString());
        HashMap<String, String> columnDimensionMap = new HashMap<String, String>(3);
        columnDimensionMap.put("jtysbbd_jts", "jtysbbd_jts");
        columnDimensionMap.put("jtysbbd_sds", "jtysbbd_sds");
        columnDimensionMap.put(accessProjectBizTypeEnum.getReportItemMark(), accessProjectBizTypeEnum.getReportItemMark());
        return this.queryCellValue(sbbid, accessProjectBizTypeEnum, accessProjectBizTypeEnum.getDynRowNo(), columnDimensionMap);
    }

    protected Map<String, Map<String, String>> queryCellValue(Long sbbId, AccessProjectBizTypeEnum accessProjectBizTypeEnum, String dynRowNo, Map<String, String> columnDimensionMap) {
        QFilter queryFilter = new QFilter("entryid", "=", (Object)sbbId).and("dynrowno", "=", (Object)dynRowNo);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_declare_detail_tsd", (String)"index,cellnumber,value", (QFilter[])new QFilter[]{queryFilter});
        HashMap dataMap = new HashMap(8);
        collection.stream().forEach(row -> {
            String index = row.getString("index");
            if (!dataMap.containsKey(index)) {
                HashMap map = new HashMap(2);
                dataMap.put(index, map);
            }
            columnDimensionMap.keySet().stream().filter(columnDimension -> row.getString("cellnumber").endsWith((String)columnDimension)).findFirst().ifPresent(columnDimension -> ((Map)dataMap.get(index)).put(columnDimensionMap.get(columnDimension), row.getString("value")));
        });
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(dataMap.size());
        dataMap.values().forEach(map -> resultMap.put((String)map.get(accessProjectBizTypeEnum.getReportItemMark()), (Map<String, String>)map));
        return resultMap;
    }

    protected Map<String, Map<String, String>> handleNotExistDataFetchItem(List<String> fetchItemIds, Map<String, Map<String, String>> cellValues, AccessProjectBizTypeEnum accessProjectBizTypeEnum, List<String> columnDimensions) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(8);
        for (String fetchItemId : fetchItemIds) {
            if (cellValues.containsKey(fetchItemId)) continue;
            HashMap<String, String> data = new HashMap<String, String>(columnDimensions.size());
            for (String columnDimension : columnDimensions) {
                if (columnDimension.equals(accessProjectBizTypeEnum.getReportItemMark())) {
                    data.put(columnDimension, fetchItemId);
                    continue;
                }
                data.put(columnDimension, BigDecimal.ZERO.toString());
            }
            result.put(fetchItemId, data);
        }
        return result;
    }

    public boolean checkSdsIsEqualToJts(Map<String, Object> extendParams) {
        String sdsdyjts;
        String string = sdsdyjts = extendParams.containsKey("sdsdyjts") ? extendParams.get("sdsdyjts").toString() : "";
        return "1".equalsIgnoreCase(sdsdyjts);
    }

    public boolean checkSdsIsFetchDataFromThirteen(Map<String, Object> extendParams) {
        String sdsdyjts;
        String string = sdsdyjts = extendParams.containsKey("sdsdyjts") ? extendParams.get("sdsdyjts").toString() : "";
        return "2".equalsIgnoreCase(sdsdyjts);
    }

    private RuleFetchMainDto calculateRuleAccess(Long orgId, Long templateId, Long taxSystemId, Date startDate, Date endDate, DynamicObjectCollection fetchItems) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)fetchItems)) {
            return ruleFetchMainDto;
        }
        Set ids = fetchItems.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(new QFilter("enable", "=", (Object)Boolean.TRUE)).and(new QFilter("accessproject", "in", ids));
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        sharingPlanWhereFilter.and(new QFilter("ruleentity.rule.accessproject", "in", ids));
        RuleEngineParamDto paramDto = new RuleEngineParamDto(orgId, Long.valueOf(3L), DateUtils.getFirstDateOfYear((Date)startDate), endDate, templateId, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate), "sbjtThan");
        try {
            ItpJtThanDynCalculateServiceImpl service = new ItpJtThanDynCalculateServiceImpl();
            List ruleFetchMainDtoList = service.calculateRuleAccess(paramDto);
            return (RuleFetchMainDto)ruleFetchMainDtoList.get(0);
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u52a8\u6001\u884c\u53d6\u6570\u62a5\u9519:{}", (Object)exceptionStackTraceMessage);
            return ruleFetchMainDto;
        }
    }

    static {
        fetchEntryAndReportItemMapping.put("entryentity", "#jtysbbd_sds");
        fetchEntryAndReportItemMapping.put("entryentity1", "#jtysbbd_hjs");
    }

    static enum AccessProjectBizTypeEnum {
        YWLB0001("YWLB0001", "dqsds_zsxcy_cyxm#1", "dqsds_bbxm"),
        YWLB0002("YWLB0002", "dqsds_yjxcy_cyxm#1", "dqsds_bbxm"),
        YWLB0003("YWLB0003", "dqsds_jnsejm_xm#1", "dqsds_bbxm"),
        YWLB0010("YWLB0010", "dqsds_jwsedm_xm#1", "dqsds_bbxm"),
        YWLB0004("YWLB0004", "dqsds_gaaptz_cyxm#1", "dqsds_bbxm"),
        YWLB0005("YWLB0005", "dqsds_gaaptz_cyxm#1", "dqsds_bbxm"),
        YWLB0006("YWLB0006", "dqsds_gaaptz_cyxm#1", "dqsds_bbxm");

        private String number;
        private String dynRowNo;
        private String reportItemMark;

        private AccessProjectBizTypeEnum(String number, String dynRowNo, String reportItemMark) {
            this.number = number;
            this.dynRowNo = dynRowNo;
            this.reportItemMark = reportItemMark;
        }

        public String getNumber() {
            return this.number;
        }

        public String getDynRowNo() {
            return this.dynRowNo;
        }

        public String getReportItemMark() {
            return this.reportItemMark;
        }

        public static AccessProjectBizTypeEnum getEnumByNumber(String number) {
            for (AccessProjectBizTypeEnum bizTypeEnum : AccessProjectBizTypeEnum.values()) {
                if (!bizTypeEnum.getNumber().equals(number)) continue;
                return bizTypeEnum;
            }
            return null;
        }
    }
}

