/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.jtysbthan.dyn;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.itp.formplugin.jtysbthan.dyn.NewBaseThanDynRowPlugin;

public class ZsxcyThanDynRowPlugin
extends NewBaseThanDynRowPlugin {
    @Override
    protected NewBaseThanDynRowPlugin.AccessProjectBizTypeEnum getAccessProjectBizType() {
        return NewBaseThanDynRowPlugin.AccessProjectBizTypeEnum.YWLB0001;
    }

    @Override
    public Map<String, Map<String, String>> getAllCellValue(BussinessParamsVo businessParamsVo, NewBaseThanDynRowPlugin.AccessProjectBizTypeEnum accessProjectBizTypeEnum, List<String> fetchItemIds) {
        String dynRowNo;
        String zcjtsqzParam;
        Map extendParams = businessParamsVo.getExtendParams();
        if ("hjbd".equalsIgnoreCase(extendParams.get("comparisontype").toString())) {
            Map<String, Map<String, String>> cellValues = super.querySdbdCellValue(businessParamsVo, accessProjectBizTypeEnum);
            Map<String, Map<String, String>> noneDataValues = super.handleNotExistDataFetchItem(fetchItemIds, cellValues, accessProjectBizTypeEnum, Stream.of(accessProjectBizTypeEnum.getReportItemMark(), "jtysbbd_jts", "jtysbbd_sds").collect(Collectors.toList()));
            noneDataValues.putAll(cellValues);
            return noneDataValues;
        }
        long sbbid = Long.parseLong(extendParams.get("preyearendsbbid").toString());
        HashMap<String, String> columnDimensionMap = new HashMap<String, String>(2);
        String string = zcjtsqzParam = extendParams.containsKey("itpZcjtsqz") ? extendParams.get("itpZcjtsqz").toString() : "bnjt";
        if ("bnjt".equals(zcjtsqzParam) || "bnjtThirteen".equals(zcjtsqzParam)) {
            columnDimensionMap.put("dqsds_hj", "jtysbbd_jts");
            columnDimensionMap.put("dqsds_bbxm", accessProjectBizTypeEnum.getReportItemMark());
            dynRowNo = accessProjectBizTypeEnum.getDynRowNo();
        } else {
            columnDimensionMap.put("zcycgl_qmye", "jtysbbd_jts");
            columnDimensionMap.put("zcycgl_bbxm", accessProjectBizTypeEnum.getReportItemMark());
            dynRowNo = "zcycgl_zsxcy_cyxm#1";
        }
        Map<String, Map<String, String>> cellValues = super.queryCellValue(sbbid, accessProjectBizTypeEnum, dynRowNo, columnDimensionMap);
        Map<String, Map<String, String>> noneDataValues = super.handleNotExistDataFetchItem(fetchItemIds, cellValues, accessProjectBizTypeEnum, Stream.of(accessProjectBizTypeEnum.getReportItemMark(), "jtysbbd_jts").collect(Collectors.toList()));
        noneDataValues.putAll(cellValues);
        HashMap<String, Map<String, String>> thirteenDraftCellValues = new HashMap<String, Map<String, String>>(12);
        long thirteenSbbid = Long.parseLong(extendParams.get("thirteenSbbid").toString());
        if (this.checkSdsIsFetchDataFromThirteen(extendParams)) {
            thirteenDraftCellValues.putAll(super.queryCellValue(thirteenSbbid, accessProjectBizTypeEnum, dynRowNo, columnDimensionMap));
        }
        for (Map.Entry<String, Map<String, String>> cellValue : noneDataValues.entrySet()) {
            String sdsValue = BigDecimal.ZERO.toString();
            if (this.checkSdsIsEqualToJts(extendParams)) {
                sdsValue = cellValue.getValue().get("jtysbbd_jts");
            } else if (this.checkSdsIsFetchDataFromThirteen(extendParams)) {
                sdsValue = thirteenDraftCellValues.containsKey(cellValue.getKey()) ? (String)((Map)thirteenDraftCellValues.get(cellValue.getKey())).get("jtysbbd_jts") : "0.00";
            }
            cellValue.getValue().put("jtysbbd_sds", sdsValue);
        }
        return noneDataValues;
    }

    @Override
    public boolean checkSdsIsEqualToJts(Map<String, Object> extendParams) {
        String itpZcjtsqz;
        String sdsdyjts = extendParams.containsKey("sdsdyjts") ? extendParams.get("sdsdyjts").toString() : "";
        String string = itpZcjtsqz = extendParams.containsKey("itpZcjtsqz") ? extendParams.get("itpZcjtsqz").toString() : "";
        if ("1".equalsIgnoreCase(sdsdyjts)) {
            return true;
        }
        return "2".equalsIgnoreCase(sdsdyjts) && ("qmyeThirteen".equalsIgnoreCase(itpZcjtsqz) || "bnjtThirteen".equalsIgnoreCase(itpZcjtsqz));
    }

    @Override
    public boolean checkSdsIsFetchDataFromThirteen(Map<String, Object> extendParams) {
        String itpZcjtsqz;
        String sdsdyjts = extendParams.containsKey("sdsdyjts") ? extendParams.get("sdsdyjts").toString() : "";
        String string = itpZcjtsqz = extendParams.containsKey("itpZcjtsqz") ? extendParams.get("itpZcjtsqz").toString() : "";
        return "2".equalsIgnoreCase(sdsdyjts) && ("qmye".equalsIgnoreCase(itpZcjtsqz) || "bnjt".equalsIgnoreCase(itpZcjtsqz));
    }
}

