/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.papers;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.UnifiedDeclareReportEditFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.service.UnifiedDeclareReportEditService;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.ProvisionHyperlinkParamsEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.UnifiedDeclareReportEditAdapter;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.UnifiedDeclareReportEditHelper;
import kd.taxc.itp.business.license.ItpLicenseCheckBusiness;
import kd.taxc.itp.business.multideclarereport.ItpMultiDeclareReportBussiness;
import kd.taxc.itp.business.papers.ItpDraftBussiness;
import kd.taxc.itp.business.papers.ItpDraftEncodingBussiness;
import kd.taxc.itp.business.papers.ItpTaxLossDraftBussiness;
import kd.taxc.itp.business.papers.ProvisionDeclarationComparisonBusiness;
import kd.taxc.itp.business.papers.adjust.impl.ItpDraftAdjustBussiness;
import kd.taxc.itp.business.papers.adjust.vo.QueryBussinessVo;
import kd.taxc.itp.business.provision.jtplan.ItpJtPlanBussiness;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class ItpDeclarationEditMultiNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
UnifiedDeclareReportEditAdapter {
    private static Log logger = LogFactory.getLog(ItpDeclarationEditMultiNewPlugin.class);
    private static final Map<String, String> cycleMap = new HashMap<String, String>(4);
    protected static final String ORGID_KEY = "orgid";
    protected static final String ORG_SEL = "org";
    protected static final String RECALC_KEY = "recalc";
    protected static final String EDIT_KEY = "edit";
    private static final List containsPropertychangeFields;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG_SEL);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"adjustncs"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"canceladjust"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = null;
        if (ORG_SEL.equalsIgnoreCase(name)) {
            List<Long> isTaxpayerOrg = ItpTaxOrgCommonBusiness.queryTaxcMainOrgIdByIsTaxpayerWithPerm();
            qFilter = new QFilter("id", "in", isTaxpayerOrg);
            formShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            List<Long> validTaxationsys = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            qFilter.and("id", "in", validTaxationsys);
        }
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        if (!containsPropertychangeFields.contains(name)) {
            return;
        }
        Object newValue = changeData[0].getNewValue();
        if (newValue == null && null != changeData[0].getOldValue()) {
            this.getModel().getDataEntity().set(name, changeData[0].getOldValue());
            return;
        }
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        String ztType = this.getModel().getDataEntity().getString("zt_type");
        boolean isadjustperiod = this.getModel().getDataEntity().getBoolean("isadjustperiod");
        orgId = ObjectUtils.isEmpty((Object)orgId) ? Long.valueOf(0L) : orgId;
        taxationsysId = ObjectUtils.isEmpty((Object)taxationsysId) ? Long.valueOf(0L) : taxationsysId;
        boolean flag = ObjectUtils.isEmpty((Object)this.getPageCache().get("isChange")) || "false".equals(this.getPageCache().get("isChange"));
        this.getPageCache().put("isChange", "false");
        boolean isAdjustDate = true;
        if (ORG_SEL.equalsIgnoreCase(name) && flag) {
            boolean checkResult = ItpTaxOrgCommonBusiness.check(this.getView(), String.valueOf(orgId), "itp", TaxAppEnum.getEnumInstanceByAppid((String)"itp").getCategoryCode());
            if (!checkResult) {
                this.getPageCache().put(ORGID_KEY, orgId.toString());
                this.getPageCache().put("isChange", "false");
            } else {
                this.getPageCache().put("isChange", "true");
                this.getModel().getDataEntity().set(ORG_SEL, changeData[0].getOldValue());
            }
        } else if ("skssqq".equals(name) || "skssqz".equals(name)) {
            isAdjustDate = false;
        } else if ("isadjustperiod".equals(name)) {
            if (isadjustperiod) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"adjustperiod"});
                ((FieldEdit)this.getControl("adjustperiod")).setMustInput(true);
                this.getModel().getDataEntity().set("adjustperiod", (Object)"13");
                this.getView().updateView("adjustperiod");
                Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
                this.getModel().getDataEntity().set("skssqq", (Object)lastDateOfYear);
                this.getModel().getDataEntity().set("skssqz", (Object)lastDateOfYear);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjustperiod"});
                this.getModel().getDataEntity().set("adjustperiod", null);
                this.getView().updateView("adjustperiod");
                this.getModel().getDataEntity().set("skssqq", null);
                this.getModel().getDataEntity().set("skssqz", null);
                ((FieldEdit)this.getControl("adjustperiod")).setMustInput(false);
            }
        } else if ("adjustperiod".equals(name)) {
            Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
            this.getModel().getDataEntity().set("skssqq", (Object)lastDateOfYear);
            this.getModel().getDataEntity().set("skssqz", (Object)lastDateOfYear);
        }
        this.getView().updateView("skssqq");
        this.getView().updateView("skssqz");
        if (0L == orgId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"ItpDeclarationEditMultiNewPlugin_8", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        if (0L == taxationsysId || ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDate("skssqq")) || ObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDate("skssqz")) || ObjectUtils.isEmpty((Object)ztType)) {
            return;
        }
        if (!isadjustperiod) {
            if (isAdjustDate && !this.isBaseJtPlanSetJtDate(orgId, taxationsysId, 3L, ztType, skssqq, skssqz)) {
                return;
            }
        } else {
            String adjustperiod = this.getModel().getDataEntity().getString("adjustperiod");
            if (ObjectUtils.isEmpty((Object)adjustperiod)) {
                return;
            }
            if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("isPeriodChange")) && "false".equals(this.getPageCache().get("isPeriodChange"))) {
                return;
            }
            Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)this.getModel().getDataEntity().getDate("skssqq"));
            this.getPageCache().put("isPeriodChange", "false");
            this.getModel().getDataEntity().set("skssqq", (Object)lastDateOfYear);
            this.getModel().getDataEntity().set("skssqz", (Object)lastDateOfYear);
            this.getPageCache().put("isPeriodChange", null);
        }
        this.getView().updateView(ORG_SEL);
        this.getView().updateView("taxationsys");
        this.getView().updateView("skssqq");
        this.getView().updateView("skssqz");
        skssqq = this.getModel().getDataEntity().getDate("skssqq");
        skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (!ObjectUtils.isEmpty((Object)skssqq) && !ObjectUtils.isEmpty((Object)skssqz)) {
            this.getBillNumber(DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            this.getUnifiedDeclareReportEditHelper().loadData(orgId, skssqq, skssqz, Boolean.valueOf(true), this.isNeedRefresh());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return;
        }
        ItpLicenseCheckBusiness.orgLicenseCheck(orgId);
    }

    public boolean isBaseJtPlanSetJtDate(Long orgId, Long taxationsysId, Long taxtype, String ztType, Date skssqq, Date skssqz) {
        String provisionPeriod = ItpJtPlanBussiness.getProvisionPeriod(orgId, taxationsysId, taxtype, ztType, skssqq, skssqz);
        if (ObjectUtils.isEmpty((Object)provisionPeriod)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"ItpDeclarationEditMultiNewPlugin_22", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void getBillNumber(String sksqq, String sksqz) {
        String cnumber = ItpDraftEncodingBussiness.createBillNumber(MultiTableEnum.TSD001.getDeclareMainTable(), this.getModel().getDataEntity().getString("org.id"), this.getTemplateType(), sksqq, sksqz, this.getUnifiedDeclareReportEditHelper().getDeclareMainQueryParams());
        this.getModel().getDataEntity().set("number", (Object)cnumber);
        this.getView().updateView("number");
        this.getModel().setDataChanged(false);
    }

    private boolean isNeedRefresh() {
        DynamicObject dynamicObject = ItpDraftBussiness.queryDraftInfo(this.getModel().getDataEntity().getLong("org.id"), this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), this.getUnifiedDeclareReportEditHelper().getDeclareMainQueryParams());
        if (dynamicObject == null) {
            this.getView().getPageCache().put("papers_status", "A");
            return Boolean.TRUE;
        }
        this.getView().getPageCache().put("papers_status", dynamicObject.getString("billstatus"));
        return Boolean.FALSE;
    }

    public boolean beforeOpenDeclarePage() {
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        String ztType = this.getModel().getDataEntity().getString("zt_type");
        boolean isadjustperiod = this.getModel().getDataEntity().getBoolean("isadjustperiod");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return false;
        }
        ItpLicenseCheckBusiness.orgLicenseCheck(orgId);
        Integer taxlossyear = ItpTaxLossDraftBussiness.calculate(orgId, taxationsysId, skssqz);
        if (ObjectUtils.isEmpty((Object)taxlossyear)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u7ef4\u62a4\u7a0e\u4e8f\u8bbe\u7f6e\u6216\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u7f16\u5236\u3002", (String)"ItpDeclarationEditMultiNewPlugin_31", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        DynamicObject isexistobj = ItpDraftBussiness.queryDraftInfo(orgId, skssqq, skssqz, this.getUnifiedDeclareReportEditHelper().getDeclareMainQueryParams());
        if (isexistobj != null) {
            this.getModel().setValue("comment", (Object)isexistobj.getString("remarks"));
            this.getPageCache().put("comment", isexistobj.getString("remarks"));
            return Boolean.TRUE;
        }
        if (!isadjustperiod) {
            boolean checkDate = this.checkDate(skssqq, skssqz);
            if (!checkDate) {
                return checkDate;
            }
            boolean ischeckresult = this.isAnIntersection(orgId, taxationsysId, skssqq, skssqz, ztType, isadjustperiod);
            if (!ischeckresult) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7684\u8ba1\u63d0\u671f\u95f4\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\u3002", (String)"ItpDeclarationEditMultiNewPlugin_9", (String)"taxc-itp", (Object[])new Object[0]), new Object[0]));
                return ischeckresult;
            }
        }
        this.getModel().setValue("comment", (Object)"");
        this.getPageCache().put("comment", "");
        return true;
    }

    private boolean checkDate(Date startDate, Date endDate) {
        Date startDay = DateUtils.getFirstDateOfMonth((Date)startDate);
        Date lastDay = DateUtils.getLastDateOfMonth((Date)endDate);
        boolean ischeckresult = DateUtils.format((Date)startDate).equals(DateUtils.format((Date)startDay));
        if (!ischeckresult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u4e3a\u6708\u4efd\u7b2c\u4e00\u5929\u3002", (String)"ItpDeclarationEditMultiNewPlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
            return ischeckresult;
        }
        ischeckresult = DateUtils.format((Date)endDate).equals(DateUtils.format((Date)lastDay));
        if (!ischeckresult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u4e3a\u6708\u4efd\u6700\u540e\u4e00\u5929\u3002", (String)"ItpDeclarationEditMultiNewPlugin_2", (String)"taxc-itp", (Object[])new Object[0]));
            return ischeckresult;
        }
        boolean bl = ischeckresult = DateUtils.getYearOfDate((Date)endDate) - DateUtils.getYearOfDate((Date)startDate) == 0;
        if (!ischeckresult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u533a\u95f4\u4e0d\u5141\u8bb8\u8de8\u5e74\u3002", (String)"ItpDeclarationEditMultiNewPlugin_3", (String)"taxc-itp", (Object[])new Object[0]));
            return ischeckresult;
        }
        return this.checkJtplanAndDate(startDate, endDate);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject auditedDeclareThanDraft;
        String key = args.getOperateKey();
        if (RECALC_KEY.equalsIgnoreCase(key) && !ObjectUtils.isEmpty((Object)(auditedDeclareThanDraft = this.getAuditedDeclareThanDraft("yes", "C", this.getDraftId()))) && !ObjectUtils.isEmpty((Object)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity"))) {
            long did = this.getDraftId();
            if (!ObjectUtils.isEmpty((Object)auditedDeclareThanDraft) && did == ((DynamicObject)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity").get(0)).getLong("draftid")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6821\u51c6\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"ItpDeclarationEditMultiNewPlugin_15", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
        }
        super.afterDoOperation(args);
        switch (key) {
            case "adjustncs": {
                if (!this.beforeCilckCheck()) break;
                Map.Entry<Integer, DynamicObject> tuple = this.getAllAuditedDeclareThanDraft("no", "C", this.getDraftId());
                if (!ObjectUtils.isEmpty(tuple) && tuple.getKey() > 0 && tuple.getValue() == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e74\u5ea6\u5df2\u5b8c\u6210\u6821\u51c6\u3002", (String)"ItpDeclarationEditMultiNewPlugin_32", (String)"taxc-itp", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkAdjustRta(key, tuple.getValue())) break;
                if (tuple.getKey() > 1) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("adjustncs", (IFormPlugin)this);
                    String mainDesc = ResManager.loadKDString((String)"\u5ba1\u5b9a\u6bd4\u5bf9\u548c\u6c47\u7f34\u6bd4\u5bf9\u7684\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u8868\u5747\u672a\u6821\u51c6\u8fc7\u5e74\u521d\u6570\uff0c\u5f53\u524d\u7531\u6c47\u7f34\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u8fdb\u884c\u6821\u51c6\uff0c\u70b9\u786e\u5b9a\u540e\u6b63\u5e38\u6267\u884c\u6821\u51c6\u64cd\u4f5c\u3002", (String)"ItpDeclarationEditMultiNewPlugin_33", (String)"taxc-itp", (Object[])new Object[0]);
                    this.getView().showConfirm(mainDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
                    break;
                }
                this.adjustRta();
                break;
            }
            case "canceladjust": {
                Map.Entry<Integer, DynamicObject> tuple;
                if (!this.beforeCilckCheck() || !this.checkAdjustRta(key, (tuple = this.getAllAuditedDeclareThanDraft("yes", "C", this.getDraftId())).getValue())) break;
                this.cancelAdjustRta();
                break;
            }
            case "viewtable": {
                this.viewAdjustRta();
                break;
            }
            case "edit": {
                this.getPageCache().put("isCancelAdjustRta", null);
                this.getPageCache().put("isAdjustRta", null);
                this.getPageCache().put(RECALC_KEY, null);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (RECALC_KEY.equals(callBackId)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("isCancelAdjustRta", null);
                this.getPageCache().put("isAdjustRta", null);
                this.getPageCache().put(RECALC_KEY, "true");
            }
        } else if ("adjustncs".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.adjustRta();
        }
    }

    private long getDraftId() {
        return ItpDraftBussiness.getDraftId(this.getTemplateType(), this.getModel().getDataEntity().getDate("skssqq"), this.getModel().getDataEntity().getDate("skssqz"), this.getUniversalQfilter());
    }

    private QFilter getUniversalQfilter() {
        QFilter Qfilter = this.getUnifiedDeclareReportEditHelper().getDeclareMainQueryParams();
        return Qfilter.and(ORG_SEL, "=", (Object)this.getView().getModel().getDataEntity().getLong("org.id"));
    }

    private DynamicObject getAuditedDeclareThanDraft(String adjustStatus, String status, Long draftId) {
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        String zt_type = this.getModel().getDataEntity().getString("zt_type");
        Long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        Map.Entry<Integer, DynamicObject> mapEntry = ItpDraftBussiness.getAuditedDeclareThanDraft(this.getTemplateType(), skssqz, taxationsysId, orgId, zt_type, adjustStatus, status, this.getDraftId());
        if (ObjectUtils.isEmpty(mapEntry)) {
            return null;
        }
        return ItpDraftBussiness.getAuditedDeclareThanDraft(this.getTemplateType(), skssqz, taxationsysId, orgId, zt_type, adjustStatus, status, this.getDraftId()).getValue();
    }

    private Map.Entry<Integer, DynamicObject> getAllAuditedDeclareThanDraft(String adjustStatus, String status, Long draftId) {
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        Long taxationsysId = this.getView().getModel().getDataEntity().getLong("taxationsys.id");
        String zt_type = this.getModel().getDataEntity().getString("zt_type");
        Long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        return ItpDraftBussiness.getAuditedDeclareThanDraft(this.getTemplateType(), skssqz, taxationsysId, orgId, zt_type, adjustStatus, status, this.getDraftId());
    }

    public boolean beforeCilckCheck() {
        String billstatus;
        String org = this.getModel().getDataEntity().getString("org.id");
        long taxationsys = this.getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (ObjectUtils.isEmpty((Object)org) || ObjectUtils.isEmpty((Object)taxationsys) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"ItpDeclarationEditMultiNewPlugin_35", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        DynamicObject declare = this.getUnifiedDeclareReportEditHelper().getDeclareMain(org, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
        if (declare != null && !"A".equalsIgnoreCase(billstatus = declare.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"ItpDeclarationEditMultiNewPlugin_39", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void adjustRta() {
        Map<String, String> compareResultMap = this.createCompareResultMap("adjustncs");
        ItpMultiDeclareReportBussiness.changeDataBusiness(this.getView(), compareResultMap, "RTA");
        this.reloadPageAndRecoverCache();
        this.getPageCache().put("isAdjustRta", "true");
        this.getPageCache().put("isCancelAdjustRta", null);
    }

    private void cancelAdjustRta() {
        if (this.getPageCache().get("isAdjustRta") == null) {
            return;
        }
        this.getPageCache().put("isAdjustRta", null);
        this.getPageCache().put("isCancelAdjustRta", "true");
        Map<String, String> compareResultMap = this.createCompareResultMap("canceladjust");
        DynamicObject auditedDeclareThanDraft = this.getAuditedDeclareThanDraft("yes", "C", this.getDraftId());
        String cause = "";
        if (!ObjectUtils.isEmpty((Object)auditedDeclareThanDraft) && !ObjectUtils.isEmpty((Object)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity")) && "yes".equals(((DynamicObject)auditedDeclareThanDraft.getDynamicObjectCollection("entryentity").get(0)).getString("isadjuest"))) {
            cause = ResManager.loadKDString((String)"\u53d6\u6d88RTA", (String)"ItpDeclarationEditMultiNewPlugin_16", (String)"taxc-itp", (Object[])new Object[0]);
        }
        ItpMultiDeclareReportBussiness.changeDataBusiness(this.getView(), compareResultMap, cause);
        this.reloadPageAndRecoverCache();
    }

    private void viewAdjustRta() {
        long org = this.getModel().getDataEntity().getLong("org.id");
        long taxationsys = this.getModel().getDataEntity().getLong("taxationsys.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (ObjectUtils.isEmpty((Object)org) || ObjectUtils.isEmpty((Object)taxationsys) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"ItpDeclarationEditMultiNewPlugin_35", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        Date yearDate = DateUtils.addYear((Date)this.getModel().getDataEntity().getDate("skssqz"), (int)-1);
        String template = "sdsjt_bd".equals(this.getTemplateType()) ? "jtysbbd_bd" : "jtysbbd_jt";
        DynamicObject[] dataCollection = ProvisionDeclarationComparisonBusiness.getData(this.getView().getModel().getDataEntity().getLong("taxationsys.id"), this.getModel().getDataEntity().getLong("org.id"), this.getModel().getDataEntity().getString("zt_type"), yearDate, template, "C", "yes");
        if (dataCollection.length > 1) {
            DynamicObject dynamicObject = Arrays.stream(dataCollection).findFirst().orElse(null);
            ListShowParameter param = new ListShowParameter();
            param.setFormId("bos_list");
            param.setBillFormId("itp_accrualdec_than_list");
            HashMap<String, Object> customParams = new HashMap<String, Object>(5);
            customParams.put("taxsystem", dynamicObject.getLong("taxsystem.id"));
            customParams.put("accountsettype", dynamicObject.getString("accountsettype"));
            customParams.put(ORG_SEL, dynamicObject.getLong("org.id"));
            customParams.put(ORGID_KEY, dynamicObject.getLong("org.id"));
            customParams.put("billstatus", dynamicObject.getString("billstatus"));
            customParams.put("skssqq", dynamicObject.getDate("skssqq"));
            customParams.put("skssqz", dynamicObject.getDate("skssqz"));
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        } else if (dataCollection.length == 1) {
            DynamicObject auditedDeclareThanDraft = Arrays.stream(dataCollection).findFirst().orElse(null);
            FormShowParameter formShowParameter = ProvisionHyperlinkParamsEnum.JTYSBBD_JT.createFormShowParameter(auditedDeclareThanDraft);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9", (String)"ItpDeclarationEditMultiNewPlugin_20", (String)"taxc-itp", (Object[])new Object[0]));
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u8868\u3002", (String)"ItpDeclarationEditMultiNewPlugin_17", (String)"taxc-itp", (Object[])new Object[0]));
        }
    }

    private Map<String, String> createCompareResultMap(String operationType) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        ItpDraftAdjustBussiness adjustBussiness = new ItpDraftAdjustBussiness();
        QueryBussinessVo vo = new QueryBussinessVo();
        vo.setTemplatetype(this.getTemplateType());
        vo.setOrgId(this.getModel().getDataEntity().getLong("org.id"));
        vo.setSkssqq(this.getModel().getDataEntity().getDate("skssqq"));
        vo.setSkssqz(this.getModel().getDataEntity().getDate("skssqz"));
        vo.setTaxsystem(this.getModel().getDataEntity().getLong("taxationsys.id"));
        vo.setAccounttype(this.getModel().getDataEntity().getString("zt_type"));
        vo.setChildrenPagecache(this.getUnifiedDeclareReportEditHelper().getChildPageCache());
        vo.setiPageCache(this.getPageCache());
        vo.setTemplatetype(this.getTemplateType());
        vo.setCacheKey(this.getCacheKey());
        adjustBussiness.adjust(result, vo, operationType);
        return result;
    }

    private boolean checkAdjustRta(String key, DynamicObject dynamicObject) {
        if (this.checkIsexistAfterInterval()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5e74\u540e\u7eed\u671f\u95f4\u5df2\u5b58\u5728\u5e95\u7a3f\uff0c\u4e3a\u4fdd\u6301\u8fde\u7eed\u671f\u95f4\u6570\u636e\u7ee7\u627f\u4e00\u81f4\uff0c\u8bf7\u5148\u5220\u9664\u672c\u5e74\u540e\u7eed\u671f\u95f4\u7684\u5e95\u7a3f\u3002", (String)"ItpDeclarationEditMultiNewPlugin_18", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u63d0\u4e0e\u7533\u62a5\u6bd4\u5bf9\u8868\u3002", (String)"ItpDeclarationEditMultiNewPlugin_17", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        if ("canceladjust".equals(key) && !ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection("entryentity")) && this.getPageCache().get("isCancelAdjustRta") == null) {
            this.getPageCache().put("isAdjustRta", "true");
        }
        return true;
    }

    private boolean checkIsexistAfterInterval() {
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        if (!ObjectUtils.isEmpty((Object)skssqq) && skssqq.getTime() == DateUtils.getLastDateOfYear((Date)skssqq).getTime()) {
            return false;
        }
        Date firstDateOfLastYear = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)skssqz, (int)1));
        QFilter qFilter = this.getUniversalQfilter().and("skssqq", ">=", (Object)skssqz).and("skssqq", "<", (Object)firstDateOfLastYear);
        qFilter.and("templatetype", "=", (Object)this.getTemplateType());
        return QueryServiceHelper.exists((String)MultiTableEnum.TSD001.getDeclareMainTable(), (QFilter[])new QFilter[]{qFilter});
    }

    private void reloadPageAndRecoverCache() {
        IPageCache childPagecache = this.getUnifiedDeclareReportEditHelper().getChildPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"updata_cellid", Map.class);
        Map newData = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"updata_cellid_save", Map.class);
        Map remarkMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"remark_data", Map.class);
        Map showAllMap = (Map)TreeUtils.getCache((IPageCache)childPagecache, (String)"showData", Map.class);
        String customEvent = "adjustncs";
        if (this.getPageCache().get(RECALC_KEY) != null && "true".equals(this.getPageCache().get(RECALC_KEY))) {
            customEvent = RECALC_KEY;
        }
        this.getUnifiedDeclareReportEditHelper().operationSbb(EDIT_KEY, Boolean.FALSE.booleanValue(), customEvent);
        childPagecache = this.getUnifiedDeclareReportEditHelper().getChildPageCache();
        TreeUtils.putCache((IPageCache)childPagecache, (String)"updata_cellid", (Object)updateMap);
        TreeUtils.putCache((IPageCache)childPagecache, (String)"updata_cellid_save", (Object)newData);
        TreeUtils.putCache((IPageCache)childPagecache, (String)"remark_data", (Object)remarkMap);
        TreeUtils.putCache((IPageCache)childPagecache, (String)"showData", (Object)showAllMap);
    }

    private String getCacheKey() {
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        String zt = this.getModel().getDataEntity().getString("zt_type");
        return orgId + DateUtils.format((Date)skssqq) + DateUtils.format((Date)skssqz) + taxationsysId + zt + "_declareData";
    }

    public UnifiedDeclareReportEditService getUnifiedDeclareReportEditService() {
        return UnifiedDeclareReportEditFactory.getInstance((IFormView)this.getView());
    }

    public UnifiedDeclareReportEditHelper getUnifiedDeclareReportEditHelper() {
        return new UnifiedDeclareReportEditHelper(this.getView());
    }

    public String getTemplateType() {
        return this.getUnifiedDeclareReportEditService().getTemplateType();
    }

    public boolean beforeSave() {
        boolean intersection;
        boolean isCheck;
        String comment = this.getModel().getDataEntity().getString("comment");
        if (comment != null && comment.length() > 2000) {
            return false;
        }
        String number = this.getModel().getDataEntity().getString("number");
        Long orgId = this.getView().getModel().getDataEntity().getLong("org.id");
        List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.getAllPermOrgs(this.getView(), "4715a0df000000ac");
        if (!allPermOrgs.contains(orgId)) {
            return false;
        }
        Long taxsystem = this.getModel().getDataEntity().getLong("taxationsys.id");
        Date skssq = (Date)this.getModel().getValue("skssqq");
        Date skssz = (Date)this.getModel().getValue("skssqz");
        String zt = this.getModel().getDataEntity().getString("zt_type");
        boolean isadjustperiod = this.getModel().getDataEntity().getBoolean("isadjustperiod");
        if (!isadjustperiod && !(isCheck = this.checkJtplanAndDate(skssq, skssz))) {
            return false;
        }
        String templateType = this.getTemplateType();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,org,number,skssqq,skssqz,taxsystem,accountsettype", (QFilter[])new QFilter[]{new QFilter(ORG_SEL, "=", (Object)orgId).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("accountsettype", "=", (Object)zt).and("templatetype", "=", (Object)templateType)});
        if (obj != null && taxsystem.longValue() != obj.getLong("taxsystem.id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u7ec4\u7ec7\u540c\u4e00\u8ba1\u63d0\u671f\u95f4\u4e0b\u53ea\u80fd\u6709\u4e00\u4e2a\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpDeclarationEditMultiNewPlugin_34", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,org,number,skssqq,skssqz,taxsystem,accountsettype", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (dynamicObject == null && !(intersection = this.isAnIntersection(orgId, taxsystem, skssq, skssz, zt, isadjustperiod))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7684\u8ba1\u63d0\u671f\u95f4\u4e0d\u5141\u8bb8\u5b58\u5728\u4ea4\u96c6\u3002", (String)"ItpDeclarationEditMultiNewPlugin_9", (String)"taxc-itp", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkJtplanAndDate(Date startDate, Date endDate) {
        boolean ischeckresult = true;
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        String zt = this.getModel().getDataEntity().getString("zt_type");
        String provisionPeriod = ItpJtPlanBussiness.getProvisionPeriod(orgId, taxationsysId, 3L, zt, startDate, endDate);
        if (provisionPeriod != null) {
            ischeckresult = DateUtils.validDateRange((String)provisionPeriod, (Date)startDate, (Date)endDate);
            if (!ischeckresult) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u8ba1\u63d0\u5468\u671f\u4e3a%s\uff0c\u8bf7\u4fee\u6539\u8ba1\u63d0\u671f\u95f4\u3002", (String)"ItpDeclarationEditMultiNewPlugin_4", (String)"taxc-itp", (Object[])new Object[0]), cycleMap.get(provisionPeriod)));
                return ischeckresult;
            }
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"ItpDeclarationEditMultiNewPlugin_22", (String)"taxc-itp", (Object[])new Object[0]), new Object[0]));
            return !ischeckresult;
        }
        return ischeckresult;
    }

    private boolean isAnIntersection(Long orgId, Long taxsystemId, Date sksqq, Date sksqz, String zt, boolean isadjustperiod) {
        return !ItpDraftBussiness.isAnIntersection(MultiTableEnum.TSD001.getDeclareMainTable(), orgId, taxsystemId, sksqq, sksqz, zt, this.getTemplateType(), isadjustperiod);
    }

    public void doAfterSuccessSave() {
        if (this.getPageCache().get("isAdjustRta") != null || this.getPageCache().get("isCancelAdjustRta") != null) {
            String isadjuest = this.getPageCache().get("isAdjustRta") != null ? "yes" : "no";
            Date adjuestdate = this.getPageCache().get("isAdjustRta") != null ? new Date() : null;
            DynamicObject dyn = this.getAuditedDeclareThanDraft("yes".equals(isadjuest) ? "no" : "yes", "C", this.getDraftId());
            long draftId = this.getDraftId();
            if (!ObjectUtils.isEmpty((Object)dyn) && draftId != -1L) {
                if ("no".equals(isadjuest)) {
                    draftId = 0L;
                }
                if (!ObjectUtils.isEmpty((Object)dyn) && !ObjectUtils.isEmpty((Object)dyn.getDynamicObjectCollection("entryentity"))) {
                    ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).set("isadjuest", (Object)isadjuest);
                    ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).set("adjuestdate", (Object)adjuestdate);
                    ((DynamicObject)dyn.getDynamicObjectCollection("entryentity").get(0)).set("draftid", (Object)draftId);
                } else {
                    DynamicObjectCollection collection = dyn.getDynamicObjectCollection("entryentity");
                    DynamicObject dy = collection.addNew();
                    dy.set("seq", (Object)1);
                    dy.set("isadjuest", (Object)isadjuest);
                    dy.set("adjuestdate", (Object)adjuestdate);
                    dy.set("draftid", (Object)draftId);
                    dyn.set("entryentity", (Object)collection);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
            }
            this.getPageCache().put("isAdjustRta", null);
            this.getPageCache().put("isCancelAdjustRta", null);
        }
    }

    static {
        cycleMap.put("month", ResManager.loadKDString((String)"\u6708", (String)"ItpDeclarationEditMultiNewPlugin_5", (String)"taxc-itp", (Object[])new Object[0]));
        cycleMap.put("season", ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"ItpDeclarationEditMultiNewPlugin_6", (String)"taxc-itp", (Object[])new Object[0]));
        cycleMap.put("year", ResManager.loadKDString((String)"\u5e74", (String)"ItpDeclarationEditMultiNewPlugin_7", (String)"taxc-itp", (Object[])new Object[0]));
        containsPropertychangeFields = Arrays.asList(ORG_SEL, "taxationsys", "isadjustperiod", "adjustperiod", "skssqq", "skssqz", "zt_type");
    }
}

