/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.sharedplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.common.db.DynamicObjectCollectionUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.shareplan.AbstractSharePlanFormPlugin;
import kd.taxc.itp.business.sharedplan.ItpJtThanSharingPlanBussiness;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.collections.CollectionUtils;

public class ItpJtThanSharingPlanPlugin
extends AbstractSharePlanFormPlugin {
    private static final String NEWROW = "newRow";
    private static final String OLDROW = "oldRow";
    private static final String TAXATIONSYS_CHANGE = "taxationsys_change";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxationsysEdit = (BasedataEdit)this.getControl("taxationsys");
        taxationsysEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848", (String)"ItpJtThanSharingPlanPlugin_2", (String)"taxc-itp", (Object[])new Object[0]));
    }

    protected void initData() {
        super.initData();
        this.planFieldMap.put("taxationsys", "cardtaxationsys");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("taxationsys".equalsIgnoreCase(key)) {
            HashSet ids = new HashSet();
            DynamicObjectCollection collection = this.getModel().getEntryEntity("planentity");
            DynamicObject newRowObject = (DynamicObject)collection.get(this.getSelectRows());
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection("ruleentity");
            ruleCol.stream().filter(ruleRow -> ruleRow.getString("rule.id") != null).forEach(ruleRow -> ids.add(ruleRow.getString("rule.id")));
            if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(NEWROW), (CharSequence)this.getPageCache().get(OLDROW)) && CollectionUtils.isNotEmpty(ids)) {
                String oldTaxSysId;
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                String string = oldTaxSysId = oldValue == null ? null : oldValue.getString("id");
                if (!"true".equals(this.getPageCache().get(TAXATIONSYS_CHANGE))) {
                    this.getPageCache().put("old-taxationsys", oldTaxSysId);
                    String mainDesc = ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u5236\u5ea6\uff0c\u5c06\u4f1a\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u4e0e\u5171\u4eab\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"ItpJtThanSharingPlanPlugin_3", (String)"taxc-itp", (Object[])new Object[0]);
                    String leftDesc = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ItpJtThanSharingPlanPlugin_4", (String)"taxc-itp", (Object[])new Object[0]);
                    String rightDesc = ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u7a7a", (String)"ItpJtThanSharingPlanPlugin_5", (String)"taxc-itp", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("taxationsys", (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.No.getValue(), leftDesc);
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), rightDesc);
                    MessageBoxOptions options = MessageBoxOptions.YesNo;
                    this.getView().showConfirm(mainDesc, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                } else {
                    this.getPageCache().remove("old-taxationsys");
                    this.getPageCache().put(TAXATIONSYS_CHANGE, "false");
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys")) {
            List<Long> ids = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            QFilter idQFilter = new QFilter("id", "in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(idQFilter);
        }
        super.beforeF7Select(beforeF7SelectEvent);
    }

    protected void setOrgFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter inOrgFilter;
        DynamicObject taxationsys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        if (taxationsys == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpJtThanSharingPlanPlugin_6", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        List<Long> taxOrg = ItpTaxOrgCommonBusiness.queryTaxcOrgIdWithPerm(this.getView());
        HashSet ids = new HashSet();
        DynamicObjectCollection allPlan = this.getModel().getEntryEntity("planentity");
        List<DynamicObject> filterAllPlan = allPlan.stream().filter(m -> m.getLong("cardtaxationsys.id") == taxationsys.getLong("id")).collect(Collectors.toList());
        filterAllPlan.forEach(plan -> ids.addAll(DynamicObjectCollectionUtil.getPkValueSet((DynamicObjectCollection)plan.getDynamicObjectCollection("orgentity"), (String)"org.id")));
        if (CollectionUtils.isNotEmpty(ids)) {
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
        }
        if (ObjectUtils.isEmpty(taxOrg)) {
            ArrayList oids = new ArrayList(1);
            inOrgFilter = new QFilter("id", "in", oids);
        } else {
            inOrgFilter = new QFilter("id", "in", taxOrg);
        }
        beforeF7SelectEvent.getCustomQFilters().add(inOrgFilter);
    }

    protected void setRuleFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject taxationsys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        if (taxationsys == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"ItpJtThanSharingPlanPlugin_6", (String)"taxc-itp", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection rules = this.getModel().getEntryEntity("ruleentity");
        Set ids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject("rule") != null).map(o -> o.getDynamicObject("rule").get("id")).collect(Collectors.toSet());
        Set pids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject("rule") != null).map(o -> o.getDynamicObject("rule").get("accessproject.id")).collect(Collectors.toSet());
        QFilter notInOrgFilter = new QFilter("id", "not in", ids);
        QFilter notInAccessproject = new QFilter("accessproject", "not in", pids);
        QFilter taxationsysFilter = new QFilter("taxationsys", "=", taxationsys.get("id"));
        beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
        beforeF7SelectEvent.getCustomQFilters().add(taxationsysFilter);
    }

    protected void innerLoadData(DynamicObject planRow) {
        int rowIndex = this.getModel().createNewEntryRow("planentity");
        this.getModel().setValue("id", planRow.get("id"), rowIndex);
        this.setCardViewField(planRow, rowIndex);
        this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
        this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
        this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
        this.getModel().setValue("olddata", (Object)DynamicObjectSerializeUtil.serialize((Object[])new Object[]{planRow}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getSharePlanEntityName())), rowIndex);
        this.getModel().setEntryCurrentRowIndex("planentity", rowIndex);
        DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection("ruleentity");
        ruleCol.stream().forEach(ruleRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("ruleentity");
            this.getModel().setValue("rule", ruleRow.get("rule"), subRowIndex);
            this.getModel().setValue("accessproject", ruleRow.get("rule.accessproject"), subRowIndex);
            this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
        });
        DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection("orgentity");
        orgCol.stream().forEach(orgRow -> {
            int subRowIndex = this.getModel().createNewEntryRow("orgentity");
            this.getModel().setValue("org", orgRow.get("org"), subRowIndex);
            this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if ("taxationsys".equalsIgnoreCase(fieldKey)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData("ruleentity");
                this.getModel().createNewEntryRow("ruleentity");
                this.getModel().deleteEntryData("orgentity");
                this.getModel().createNewEntryRow("orgentity");
                this.getPageCache().put("init", "false");
                this.getPageCache().put(TAXATIONSYS_CHANGE, "false");
            } else {
                String oldTaxSys = this.getPageCache().get("old-taxationsys");
                this.getPageCache().put(TAXATIONSYS_CHANGE, "true");
                this.getModel().setValue("taxationsys", (Object)Long.parseLong(oldTaxSys));
            }
        }
    }

    protected void planDel(BeforeDoOperationEventArgs args) {
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("planentity").get(this.getSelectRows());
        long planId = row.getLong("id");
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"itp_jtthan_shardingplan"), (Object[])new Object[]{planId});
        String msg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f\u3002", (String)"ItpJtThanSharingPlanPlugin_0", (String)"taxc-itp", (Object[])new Object[0]), row.getString("carnumber"));
        OperatorDialogUtils.operateDialog((String)"jtysbbd_bd", (String)"itp_jtthan_shardingplan", (String)ResManager.loadKDString((String)"\u5220\u9664", (String)"ItpJtThanSharingPlanPlugin_1", (String)"taxc-itp", (Object[])new Object[0]), (String)msg);
        int i = row.getInt(1) - 1;
        int entryCount = this.getModel().getEntryRowCount("planentity");
        if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
            i = 0;
        }
        this.getPageCache().put("afterSelectRow", String.valueOf(i));
    }

    protected DynamicObject[] loadPlanDatas() {
        return ItpJtThanSharingPlanBussiness.queryItpJtThanSharePlanByIds(null);
    }

    protected DynamicObject loadPlanData(Long id) {
        return ItpJtThanSharingPlanBussiness.queryItpJtThanSharePlanById(id);
    }

    protected String getSharePlanEntityName() {
        return "itp_jtthan_shardingplan";
    }
}

