/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.formplugin.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.db.DynamicObjectCollectionUtil;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.collections.CollectionUtils;

public class SharingPlanPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(SharingPlanPlugin.class);
    private static final String systemType = "taxc-itp";
    private static final String REFRESH = "refresh";
    private static final String IMPORTDATA = "importdata";
    private static final String EXPORTDATA = "exportdata";
    private static final String SAVE = "save";
    private static final String INDEX = "index";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TAXATIONSYS = "taxationsys";
    private static final String ORG = "org";
    private static final String RULE = "rule";
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private static final String OPT_PLANADD = "planadd";
    private static final String OPT_PLANDEL = "plandel";
    private static final String NEWROW = "newRow";
    private static final String OLDROW = "oldRow";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String CARDSWITCH = "cardSwitch";
    private static final String SEARCHAP = "searchap";
    private static Map<String, String> MAP;
    private static final String[] fieldNames;
    private static final String TAXATIONSYS_CHANGE = "taxationsys_change";
    private List<String> lockOperate = Arrays.asList("save", "plandel");

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"labelcreate"});
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl(ORG);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl(RULE);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsysEdit = (BasedataEdit)this.getControl(TAXATIONSYS);
        taxationsysEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        search.addClickListener((ClickListener)this);
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848", (String)"SharingPlanPlugin_0", (String)systemType, (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("init", "true");
        this.loadFormData();
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        String delete = this.getPageCache().get("delete");
        String save = this.getPageCache().get(SAVE);
        if (ObjectUtils.isEmpty((Object)delete)) {
            this.selectListRow(0);
        } else if ("true".equalsIgnoreCase(delete)) {
            String deleteAfterSelectRow = this.getPageCache().get("deleteAfterSelectRow");
            this.selectListRow(Integer.parseInt(deleteAfterSelectRow));
            this.getPageCache().put("delete", null);
        }
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)save) && "true".equalsIgnoreCase(save)) {
            String saveAfterSelectRow = this.getPageCache().get("saveAfterSelectRow");
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)saveAfterSelectRow)) {
                saveAfterSelectRow = "0";
            }
            this.selectListRow(Integer.parseInt(saveAfterSelectRow));
            this.getPageCache().remove(SAVE);
        }
        this.setVisible();
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getPageCache().get("currentSearch"), (CharSequence)searchText)) {
            this.selectListRowAndPutCache();
        } else {
            this.generateCardIndexs(searchText);
            this.selectListRowAndPutCache();
        }
    }

    private void generateCardIndexs(String searchText) {
        this.getPageCache().put("currentSearch", searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap map = new HashMap();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet tempDataSet = dataSet.filter(nameQ.or(numberQ).toString());
        for (Row row : tempDataSet) {
            list.add(row.getInteger(INDEX));
        }
        tempDataSet.close();
        Collections.sort(list);
        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)map.put(String.valueOf(i), list.get((int)i));
        });
        this.getPageCache().put("cardIndexs", SerializationUtils.toJsonString(map));
        if (!map.isEmpty()) {
            this.getPageCache().put("focusCardIndex", "-1");
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.generateCardIndexs(searchText);
        return this.filterDataSet(searchText);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (MAP.containsKey(key)) {
            int selectRow = this.getSelectRows();
            if (!TAXATIONSYS.equalsIgnoreCase(key)) {
                if (selectRow >= 0) {
                    if (newValue instanceof LocaleDynamicObjectCollection) {
                        this.getModel().setValue(MAP.get(key), (Object)this.getLangValue(newValue), selectRow);
                    } else {
                        this.getModel().setValue(MAP.get(key), newValue, selectRow);
                    }
                }
            } else {
                DynamicObject newValueDyo = (DynamicObject)e.getChangeSet()[0].getNewValue();
                Object id = newValueDyo == null ? null : newValueDyo.get("id");
                this.getModel().setValue(MAP.get(key), id, selectRow);
            }
        }
        if (TAXATIONSYS.equalsIgnoreCase(key)) {
            HashSet ids = new HashSet();
            DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
            DynamicObject newRowObject = (DynamicObject)collection.get(this.getSelectRows());
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().filter(ruleRow -> ruleRow.getString("rule.id") != null).forEach(ruleRow -> ids.add(ruleRow.getString("rule.id")));
            if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(NEWROW), (CharSequence)this.getPageCache().get(OLDROW)) && CollectionUtils.isNotEmpty(ids)) {
                String oldTaxSysId;
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                String string = oldTaxSysId = oldValue == null ? null : oldValue.getString("id");
                if (!"true".equals(this.getPageCache().get(TAXATIONSYS_CHANGE))) {
                    this.getPageCache().put("old-taxationsys", oldTaxSysId);
                    String mainDesc = ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u5236\u5ea6\uff0c\u5c06\u4f1a\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u4e0e\u5171\u4eab\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_1", (String)systemType, (Object[])new Object[0]);
                    String leftDesc = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingPlanPlugin_2", (String)systemType, (Object[])new Object[0]);
                    String rightDesc = ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u7a7a", (String)"SharingPlanPlugin_3", (String)systemType, (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(TAXATIONSYS, (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.No.getValue(), leftDesc);
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), rightDesc);
                    MessageBoxOptions options = MessageBoxOptions.YesNo;
                    this.getView().showConfirm(mainDesc, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
                } else {
                    this.getPageCache().remove("old-taxationsys");
                    this.getPageCache().put(TAXATIONSYS_CHANGE, "false");
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject taxationsys = (DynamicObject)this.getModel().getValue(TAXATIONSYS);
        if (StringUtils.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)ORG)) {
            QFilter inOrgFilter;
            List<Long> taxOrg = ItpTaxOrgCommonBusiness.queryTaxcOrgIdWithPerm(this.getView());
            HashSet ids = new HashSet();
            DynamicObjectCollection allPlan = this.getModel().getEntryEntity(PLANENTITY);
            List<DynamicObject> filterAllPlan = allPlan.stream().filter(m -> m.getLong("cardtaxationsys.id") == taxationsys.getLong("id")).collect(Collectors.toList());
            filterAllPlan.forEach(plan -> ids.addAll(DynamicObjectCollectionUtil.getPkValueSet((DynamicObjectCollection)plan.getDynamicObjectCollection(ORGENTITY), (String)"org.id")));
            if (CollectionUtils.isNotEmpty(ids)) {
                QFilter notInOrgFilter = new QFilter("id", "not in", ids);
                beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            }
            if (ObjectUtils.isEmpty(taxOrg)) {
                ArrayList oids = new ArrayList(1);
                inOrgFilter = new QFilter("id", "in", oids);
            } else {
                inOrgFilter = new QFilter("id", "in", taxOrg);
            }
            beforeF7SelectEvent.getCustomQFilters().add(inOrgFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)RULE)) {
            if (taxationsys == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"SharingPlanPlugin_4", (String)systemType, (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
            Set ids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(RULE) != null).map(o -> o.getDynamicObject(RULE).get("id")).collect(Collectors.toSet());
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            QFilter taxationsysFilter = new QFilter(TAXATIONSYS, "=", taxationsys.get("id"));
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            beforeF7SelectEvent.getCustomQFilters().add(taxationsysFilter);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)TAXATIONSYS)) {
            List<Long> ids = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
            QFilter idQFilter = new QFilter("id", "in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(idQFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        Object source = args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        int rowIndex = this.getSelectRows();
        if (this.lockOperate.contains(operateKey) && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)(row = this.getSelectRowObj(rowIndex))) && this.checkLock(String.valueOf(row.getLong("id")))) {
            args.setCancel(true);
            return;
        }
        if (source instanceof NewEntry && StringUtils.equalsIgnoreCase((CharSequence)((NewEntry)source).getOperateKey(), (CharSequence)OPT_PLANADD) && this.checkChangeData(this.getSelectRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingPlanPlugin_5", (String)systemType, (Object[])new Object[0]));
            args.setCancel(true);
        } else if (source instanceof DeleteEntry && StringUtils.equalsIgnoreCase((CharSequence)((DeleteEntry)source).getOperateKey(), (CharSequence)OPT_PLANDEL)) {
            row = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(this.getSelectRows());
            long planId = row.getLong("id");
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"itp_income_shardingplan"), (Object[])new Object[]{planId});
            int i = row.getInt(1) - 1;
            int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
            if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
                i = 0;
            }
            this.getPageCache().put("delete", "true");
            this.getPageCache().put("deleteAfterSelectRow", String.valueOf(i));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.setVisible();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int selectRow = this.getSelectRows();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANADD)) {
            this.selectListRow(selectRow);
            String number = this.getCodeRuleNumber();
            this.getModel().setValue(NUMBER, (Object)number, selectRow);
            this.getModel().setValue(MAP.get(NUMBER), (Object)number, selectRow);
            this.getModel().setValue(MAP.get(NAME), null, selectRow);
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRow);
            this.getModel().createNewEntryRow(RULEENTITY);
            this.getModel().createNewEntryRow(ORGENTITY);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANDEL)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)SAVE)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            int select = this.getSelectRows();
            if (result.isSuccess()) {
                this.save();
                this.selectListRow(select);
                this.getPageCache().put(SAVE, "true");
                this.getPageCache().put("saveAfterSelectRow", String.valueOf(select));
            }
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        List oldRows = evt.getOldRows();
        if (newRows != null && newRows.size() > 0) {
            Integer newRowIndex = (Integer)newRows.get(0);
            Integer oldRowIndex = (Integer)oldRows.get(0);
            if (this.checkChangeData((Integer)evt.getOldRows().get(0)) && !newRowIndex.equals(oldRowIndex)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CARDSWITCH, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_6", (String)systemType, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_7", (String)systemType, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_8", (String)systemType, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
                this.getPageCache().put(OLDROW, String.valueOf(oldRowIndex));
                return;
            }
            this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
            this.getPageCache().put(OLDROW, newRowIndex.equals(oldRowIndex) ? String.valueOf(this.getPageCache().get(OLDROW)) : String.valueOf(oldRowIndex));
            this.resetPlanName(newRowIndex);
            this.getPageCache().put(OLDROW, String.valueOf(newRowIndex));
            this.requireLock(this.getSelectRowObj(newRowIndex));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && this.checkChangeData(this.getSelectRows())) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_6", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_7", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_8", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)REFRESH)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)IMPORTDATA)) {
            this.importData(this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)EXPORTDATA)) {
            this.showExportDataForm();
        }
    }

    private boolean checkChangeData(int row) {
        boolean change = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return change;
        }
        DynamicObject newRowObject = (DynamicObject)collection.get(row);
        DynamicObject planRow = BusinessDataServiceHelper.loadSingle((String)"itp_income_shardingplan", (String)"id,number,name,creator,createtime,ruleentity,ruleentity.rule,ruleentity.id,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newRowObject.getLong("id"))});
        if (ObjectUtils.isEmpty((Object)planRow)) {
            change = true;
        } else {
            List ruleEntityList = planRow.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = planRow.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
            List<String> planEntity = Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection(RULEENTITY);
            ruleCol.forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newRowObject.getDynamicObjectCollection(ORGENTITY);
            orgCol.forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            List<String> plan = Arrays.asList(newRowObject.getString(MAP.get(NUMBER)), newRowObject.getString(MAP.get(NAME)));
            if (!(CollectionUtils.isEqualCollection(plan, planEntity) && CollectionUtils.isEqualCollection(ruleList, ruleEntityList) && CollectionUtils.isEqualCollection(orgList, orgEntityList))) {
                change = true;
            }
        }
        return change;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ITEM_CLOSE)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)CARDSWITCH)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String oldRow = this.getPageCache().get(OLDROW);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
                DynamicObject oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow));
                DynamicObject planRow = BusinessDataServiceHelper.loadSingle((String)"itp_income_shardingplan", (String)"id,number,name,taxationsys,creator,createtime,ruleentity,ruleentity.rule,ruleentity.id,ruleentity.rule.accessproject,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oldObject.getLong("id"))});
                if (null != planRow) {
                    List<String> ruleList = planRow.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
                    List<String> orgList = planRow.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
                    oldObject.set(MAP.get(NUMBER), (Object)planRow.getString(NUMBER));
                    oldObject.set(MAP.get(NAME), (Object)planRow.getString(NAME));
                    String oid = planRow.getString("id");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(oid), (String)"itp_income_shardingplan");
                    oldObject.set(MAP.get(TAXATIONSYS), (Object)dynamicObject.getDynamicObject(TAXATIONSYS));
                    this.getModel().setEntryCurrentRowIndex(PLANENTITY, Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData(RULEENTITY);
                    ruleList.forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                        this.getModel().setValue(RULE, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData(ORGENTITY);
                    orgList.forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                        this.getModel().setValue(ORG, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView(PLANENTITY);
                }
                String number = this.getModel().getDataEntity().getString(NUMBER);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"itp_income_shardingplan", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
                if (dynamicObject == null) {
                    this.getModel().deleteEntryRow(PLANENTITY, Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get(NEWROW)));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get(OLDROW)));
            }
        } else if (TAXATIONSYS.equalsIgnoreCase(fieldKey)) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData(RULEENTITY);
                this.getModel().createNewEntryRow(RULEENTITY);
                this.getModel().deleteEntryData(ORGENTITY);
                this.getModel().createNewEntryRow(ORGENTITY);
                int selectRow = this.getSelectRows();
                this.getPageCache().put("init", "false");
                this.getPageCache().put(TAXATIONSYS_CHANGE, "false");
            } else {
                String oldTaxSys = this.getPageCache().get("old-taxationsys");
                this.getPageCache().put(TAXATIONSYS_CHANGE, "true");
                this.getModel().setValue(TAXATIONSYS, (Object)Long.parseLong(oldTaxSys));
            }
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue(NUMBER, planentities[0].get(MAP.get(NUMBER)));
            this.getModel().setValue(NAME, planentities[0].get(MAP.get(NAME)));
            this.getModel().setValue(TAXATIONSYS, planentities[0].get(MAP.get(TAXATIONSYS)));
        } else {
            this.getModel().setValue(NUMBER, (Object)"");
            this.getModel().setValue(NAME, (Object)"");
            this.getModel().setValue(TAXATIONSYS, null);
        }
        this.getView().updateView(NUMBER);
        this.getView().updateView(NAME);
        this.getView().updateView(TAXATIONSYS);
    }

    private int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(PLANENTITY);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        if (object instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
            for (DynamicObject langObj : valueCol) {
                String localeid = langObj.getString("localeid");
                String version = langObj.getString(NAME);
                if (lang == null || !lang.equals(localeid)) continue;
                value = version;
                break;
            }
        }
        return value;
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl(PLANENTITY);
        int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getSelectRows();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    private String getCodeRuleNumber() {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"itp_income_shardingplan");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.readNumber("itp_income_shardingplan", dataInfo, null);
    }

    private void loadFormData() {
        DynamicObject[] planRows = BusinessDataServiceHelper.load((String)"itp_income_shardingplan", (String)"id,number,name,taxationsys,creator,createtime,ruleentity,ruleentity.rule,ruleentity.rule.accessproject,ruleentity.id,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[0], (String)"number asc");
        if (planRows.length > 0) {
            this.getModel().deleteEntryData(PLANENTITY);
            Arrays.stream(planRows).forEach(planRow -> {
                int rowIndex = this.getModel().createNewEntryRow(PLANENTITY);
                this.getModel().setValue("id", planRow.get("id"), rowIndex);
                this.getModel().setValue(MAP.get(NUMBER), planRow.get(NUMBER), rowIndex);
                this.getModel().setValue(MAP.get(NAME), planRow.get(NAME), rowIndex);
                this.getModel().setValue(MAP.get(TAXATIONSYS), planRow.get(TAXATIONSYS), rowIndex);
                this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
                this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
                this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, rowIndex);
                DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
                ruleCol.forEach(ruleRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                    this.getModel().setValue(RULE, ruleRow.get(RULE), subRowIndex);
                    this.getModel().setValue("accessproject", ruleRow.get("rule.accessproject"), subRowIndex);
                    this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
                });
                DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
                orgCol.forEach(orgRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue(ORG, orgRow.get(ORG), subRowIndex);
                    this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
                });
            });
            this.getView().updateView(RULEENTITY);
            this.getView().updateView(ORGENTITY);
        }
        this.getPageCache().put(PLANENTITY, SerializationUtils.toJsonString(this.getPlanCacheMap(planRows)));
    }

    private Map<String, Map<String, List<String>>> getPlanCacheMap(DynamicObject[] rows) {
        HashMap<String, Map<String, List<String>>> planCacheMap = new HashMap<String, Map<String, List<String>>>();
        Arrays.stream(rows).forEach(planRow -> {
            HashMap<String, List<String>> planEntityMap = new HashMap<String, List<String>>();
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            planEntityMap.put(PLANENTITY, Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME), planRow.getString("taxationsys.id")));
            planEntityMap.put(RULEENTITY, ruleList);
            planEntityMap.put(ORGENTITY, orgList);
            planCacheMap.put(planRow.getString("id"), planEntityMap);
        });
        return planCacheMap;
    }

    private void checkPermission() {
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4730fc9f000003ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{IMPORTDATA});
        }
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4730fc9f000004ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXPORTDATA});
        }
    }

    private void save() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
                DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
                Long planId = row.getLong("id");
                DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_income_shardingplan");
                if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
                    planObject = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"itp_income_shardingplan");
                } else {
                    planObject.set("creator", row.get("creator"));
                    planObject.set("createtime", row.get("createtime"));
                }
                planObject.set(NUMBER, row.get(MAP.get(NUMBER)));
                planObject.set(NAME, row.get(MAP.get(NAME)));
                planObject.set(TAXATIONSYS, row.get(MAP.get(TAXATIONSYS)));
                planObject.set("modifier", row.get("modifier"));
                planObject.set("modifytime", row.get("modifytime"));
                planObject.set("status", (Object)"C");
                planObject.set("enable", (Object)1);
                DynamicObjectCollection ruleCol = row.getDynamicObjectCollection(RULEENTITY);
                DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection(RULEENTITY);
                ruleCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
                    DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
                    DynamicObject ruleRow = ruleCollection.addNew();
                    ruleRow.set("seq", index);
                    ruleRow.set("id", rule.get("ruleentryid"));
                    ruleRow.set(RULE, ((DynamicObject)rule.get(RULE)).get("id"));
                });
                DynamicObjectCollection orgCol = row.getDynamicObjectCollection(ORGENTITY);
                DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection(ORGENTITY);
                orgCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
                    DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
                    DynamicObject orgRow = orgCollection.addNew();
                    orgRow.set("seq", index);
                    orgRow.set("id", org.get("orgentryid"));
                    orgRow.set(ORG, ((DynamicObject)org.get(ORG)).get("id"));
                });
                forSaveObjArr.add(planObject);
                OperationResult result = OperationServiceHelper.executeOperate((String)SAVE, (String)"itp_income_shardingplan", (DynamicObject[])forSaveObjArr.toArray(new DynamicObject[forSaveObjArr.size()]), (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SharingPlanPlugin_9", (String)systemType, (Object[])new Object[0]), Integer.valueOf(3000));
                    this.getView().invokeOperation(REFRESH);
                } else {
                    List errors = result.getAllErrorInfo();
                    List vas = result.getValidateResult().getValidateErrors();
                    StringBuilder error = new StringBuilder(result.getMessage());
                    for (OperateErrorInfo opError : errors) {
                        error.append(opError.getMessage());
                    }
                    for (ValidateResult va : vas) {
                        for (OperateErrorInfo operr : va.getAllErrorInfo()) {
                            error.append(operr.getMessage());
                        }
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"SharingPlanPlugin_10", (String)systemType, (Object[])new Object[0]), error));
                }
            }
            catch (Throwable e1) {
                LOGGER.error(e1);
                h.markRollback();
                throw e1;
            }
        }
    }

    private void importData(String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)"itp_income_shardingplan");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("Enabled", Boolean.TRUE);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(showParameter);
    }

    private void showExportDataForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("itp_income_shardingplan");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setMarginRight("500");
        styleCss.setMarginLeft("500");
        styleCss.setWidth("1150");
        styleCss.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPORTDATA));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)IMPORTDATA)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void selectListRowAndPutCache() {
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cardIndexs"), Map.class);
        if (!map.isEmpty()) {
            Integer focusCardIndex = Integer.valueOf(this.getPageCache().get("focusCardIndex"));
            if (map.size() - 1 > focusCardIndex) {
                String nextFocusCardIndex = String.valueOf(focusCardIndex + 1);
                this.selectListRow((Integer)map.get(nextFocusCardIndex));
                this.getPageCache().put("focusCardIndex", nextFocusCardIndex);
            } else if (map.size() - 1 == focusCardIndex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"SharingPlanPlugin_11", (String)systemType, (Object[])new Object[0]));
            }
        }
    }

    private DataSet buildDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.IntegerType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount(PLANENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[fieldNames.length];
            DynamicObject planEntry = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(i);
            value[0] = i;
            value[1] = planEntry.getString(MAP.get(NUMBER));
            value[2] = planEntry.getString(MAP.get(NAME));
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)"itp_income_shardingplan").createDataSet(new Input[]{inputs});
    }

    private List<String> filterDataSet(String searchText) {
        ArrayList<String> list = new ArrayList<String>();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet nameDataSet = dataSet.filter(nameQ.toString());
        DataSet numberDataSet = dataSet.filter(numberQ.toString());
        if (!nameDataSet.isEmpty()) {
            nameDataSet.forEach(o -> list.add(o.getString(NAME)));
        }
        if (!numberDataSet.isEmpty()) {
            numberDataSet.forEach(o -> list.add(o.getString(NUMBER)));
        }
        nameDataSet.close();
        numberDataSet.close();
        return list;
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    protected boolean checkLock(String objectId) {
        if (StringUtil.isEmpty((CharSequence)objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, "default_netctrl", this.getSharePlanEntityName());
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SharingPlanPlugin_12", (String)systemType, (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }

    protected void requireLock(DynamicObject object) {
        if (object == null) {
            return;
        }
        this.releaseLock();
        if (object.getLong("id") == 0L) {
            return;
        }
        String objectId = String.valueOf(object.getLong("id"));
        boolean newMutexLocked = MutexHelper.require((String)this.getSharePlanEntityName(), (Object)objectId, (String)"modify", (boolean)Boolean.FALSE, (StringBuilder)new StringBuilder());
        if (!newMutexLocked) {
            if (this.checkLock(objectId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexdata"});
            }
        } else {
            this.getPageCache().put("id_lock", objectId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexdata"});
        }
    }

    protected void releaseLock() {
        DataMutexImpl dataMutex;
        Map lockInfo;
        String lockId = this.getPageCache().get("id_lock");
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", this.getSharePlanEntityName())) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)this.getSharePlanEntityName(), (String)"modify", (String)lockId);
        }
    }

    protected DynamicObject getSelectRowObj(int rowIndex) {
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity(PLANENTITY);
        if (rowIndex < 0 || rowIndex >= planEntity.size()) {
            return null;
        }
        DynamicObject row = (DynamicObject)planEntity.get(rowIndex);
        return row;
    }

    protected String getSharePlanEntityName() {
        return "itp_income_shardingplan";
    }

    static {
        fieldNames = new String[]{INDEX, NUMBER, NAME};
        MAP = new HashMap<String, String>();
        MAP.put(NAME, "carname");
        MAP.put(NUMBER, "carnumber");
        MAP.put(TAXATIONSYS, "cardtaxationsys");
    }
}

