/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.baseinfo.fetchitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FetchItemSaveOp
extends AbstractOperationServicePlugIn {
    private static final String ISLEAF = "isleaf";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList modifyDynamicObjects = new ArrayList(8);
        for (DynamicObject fetchItem : dataEntities) {
            HashSet<Long> childIds = new HashSet<Long>();
            this.getChildId(fetchItem.getLong("id"), childIds);
            DynamicObject bizType = fetchItem.getDynamicObject("biztype");
            if (!CollectionUtils.isNotEmpty(childIds)) continue;
            DynamicObject[] childFetchItemList = BusinessDataServiceHelper.load((Object[])childIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"itp_fetchitem"));
            Arrays.stream(childFetchItemList).filter(m -> m.getLong("biztype.id") != bizType.getLong("id")).forEach(object -> {
                object.set("biztype", (Object)bizType);
                modifyDynamicObjects.add(object);
            });
        }
        if (CollectionUtils.isNotEmpty(modifyDynamicObjects)) {
            SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[0]));
        }
    }

    private void getChildId(Long id, Set<Long> childIds) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject fetchItem = QueryServiceHelper.queryOne((String)"itp_fetchitem", (String)"id,number,name,isleaf", (QFilter[])new QFilter[]{idFilter});
        if (fetchItem == null) {
            return;
        }
        if (fetchItem.getBoolean(ISLEAF)) {
            childIds.add(id);
            return;
        }
        QFilter parentFilter = new QFilter("parent", "=", (Object)id);
        DynamicObjectCollection fetchItemList = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,number,name,isleaf", (QFilter[])new QFilter[]{parentFilter}, (String)"longnumber asc");
        if (fetchItemList.isEmpty()) {
            return;
        }
        Set childs = fetchItemList.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        childIds.addAll(childs);
        Set notChilds = fetchItemList.stream().filter(m -> !m.getBoolean(ISLEAF)).map(m -> m.getLong("id")).collect(Collectors.toSet());
        for (Long notChild : notChilds) {
            this.getChildId(notChild, childIds);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    boolean isSystem;
                    String dbTaxId;
                    String parentBiztypeId;
                    DynamicObject fetchItem = dataEntity.getDataEntity();
                    DynamicObject dbFetchItem = QueryServiceHelper.queryOne((String)"itp_fetchitem", (String)"name,number,taxationsys,parent,issystem,biztype", (QFilter[])new QFilter[]{new QFilter("id", "=", fetchItem.get("id"))});
                    String taxId = fetchItem.getDynamicObject("taxationsys") == null ? "0" : fetchItem.getDynamicObject("taxationsys").getString("id");
                    String biztypeId = fetchItem.getDynamicObject("biztype") == null ? "0" : fetchItem.getDynamicObject("biztype").getString("id");
                    DynamicObject parent = fetchItem.getDynamicObject("parent");
                    String parentId = parent == null ? "0" : parent.getString("id");
                    DynamicObject parentTaxationSys = parent == null ? null : parent.getDynamicObject("taxationsys");
                    DynamicObject parentBizType = parent == null ? null : parent.getDynamicObject("biztype");
                    String parentTaxId = parentTaxationSys == null ? "0" : parentTaxationSys.getString("id");
                    String string = parentBiztypeId = parentBizType == null ? "0" : parentBizType.getString("id");
                    if (dbFetchItem != null && !taxId.equals(dbTaxId = dbFetchItem.getString("taxationsys"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u65b0\u589e\u540e\uff0c\u7a0e\u6536\u5236\u5ea6\u4e0d\u53ef\u4fee\u6539\u3002", (String)"FetchItemSaveOp_0", (String)"taxc-itp", (Object[])new Object[0]));
                    }
                    if (parent != null) {
                        if (!taxId.equalsIgnoreCase(parentTaxId)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u9879\u76ee\u7a0e\u5236\u4e0e\u7a0e\u6536\u5236\u5ea6\u4e0d\u5339\u914d\u3002", (String)"FetchItemSaveOp_1", (String)"taxc-itp", (Object[])new Object[0]));
                        }
                        if (!biztypeId.equalsIgnoreCase(parentBiztypeId)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u6570\u9879\u76ee\u4e1a\u52a1\u7c7b\u522b\u4e0e\u4e0a\u7ea7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5148\u4fee\u6539\u4e0a\u7ea7\u3002", (String)"FetchItemSaveOp_2", (String)"taxc-itp", (Object[])new Object[0]));
                        }
                    }
                    if (!(isSystem = fetchItem.getBoolean("issystem")) || dbFetchItem == null) continue;
                    String number = fetchItem.getString("number");
                    String name = fetchItem.getString("name");
                    String dbNumber = dbFetchItem.getString("number");
                    String dbName = dbFetchItem.getString("name");
                    String dbTaxId2 = dbFetchItem.getString("taxationsys");
                    String dbParentId = dbFetchItem.getString("parent");
                    if (StringUtils.equals((CharSequence)name, (CharSequence)dbName) && StringUtils.equals((CharSequence)number, (CharSequence)dbNumber) && StringUtils.equals((CharSequence)taxId, (CharSequence)dbTaxId2) && StringUtils.equals((CharSequence)parentId, (CharSequence)dbParentId)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u7684\u6570\u636e\u53ea\u80fd\u4fee\u6539\u4e1a\u52a1\u7c7b\u522b\u3002", (String)"FetchItemSaveOp_3", (String)"taxc-itp", (Object[])new Object[0]));
                }
            }
        });
    }
}

