/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.baseinfo.gaap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class AccountSetOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final List<Long> validOrgIds = ItpTaxOrgCommonBusiness.queryOrgIdByViewWithPerm("10");
        final DynamicObject[] enableplans = BusinessDataServiceHelper.load((String)"itp_gaap_accountset", (String)"id,groupaccount,localaccount,entryentity.org", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject curObj = dataEntity.getDataEntity();
                    String groupaccount = curObj.getString("groupaccount");
                    String localaccount = curObj.getString("localaccount");
                    DynamicObjectCollection colls = (DynamicObjectCollection)curObj.get("entryentity");
                    HashMap<String, String> isExistByenableIdsMap = new HashMap<String, String>(12);
                    for (DynamicObject enableplan : enableplans) {
                        if (enableplan.getString("id").equalsIgnoreCase(curObj.getString("id"))) continue;
                        DynamicObjectCollection orgColls = (DynamicObjectCollection)enableplan.get("entryentity");
                        for (DynamicObject orgColl : orgColls) {
                            isExistByenableIdsMap.put(orgColl.getString("org.id"), orgColl.getString("org.number"));
                        }
                    }
                    HashMap<String, Integer> enableplansMap = new HashMap<String, Integer>(12);
                    for (DynamicObject enableplan : enableplans) {
                        if (enableplan.getString("id").equalsIgnoreCase(curObj.getString("id"))) continue;
                        StringBuilder append = new StringBuilder(enableplan.getString("groupaccount")).append("_").append(enableplan.getString("localaccount"));
                        if (enableplansMap.containsKey(append.toString())) {
                            enableplansMap.put(append.toString(), (Integer)enableplansMap.get(append.toString()) + 1);
                            continue;
                        }
                        enableplansMap.put(append.toString(), 1);
                    }
                    HashSet<Long> orgids = new HashSet<Long>(12);
                    for (DynamicObject coll : colls) {
                        long orgId = coll.getLong("org.id");
                        if ("0".equalsIgnoreCase(String.valueOf(orgId))) continue;
                        if (!validOrgIds.contains(orgId)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u53ef\u7528\u6216\u65e0\u6743\u9650\u3002", (String)"AccountSetOp_0", (String)"taxc-itp", (Object[])new Object[0]), coll.getString("org.number")));
                            continue block0;
                        }
                        if (isExistByenableIdsMap.containsKey(String.valueOf(orgId))) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7%s\u5df2\u5b58\u5728\u4e00\u4e2a\u53ef\u7528\u7684\u65b9\u6848\u3002", (String)"AccountSetOp_1", (String)"taxc-itp", (Object[])new Object[0]), isExistByenableIdsMap.get(String.valueOf(orgId))));
                            continue block0;
                        }
                        if (orgids.add(orgId)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u91cd\u590d\u5bfc\u5165\u6838\u7b97\u7ec4\u7ec7%s\u3002", (String)"AccountSetOp_3", (String)"taxc-itp", (Object[])new Object[0]), coll.getString("org.number")));
                        continue block0;
                    }
                }
            }
        });
    }
}

