/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.baseinfo.notconfimdysds;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.baseinfo.NotConfirmDysdsPlanBussiness;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class NotConfirmDysdsPlanSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashSet<Long> taxationsysIdList = new HashSet<Long>(2);
                HashMap<String, String> errorMsgMap = new HashMap<String, String>(12);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    taxationsysIdList.add(dataEntity.getDataEntity().getLong("taxationsys.id"));
                }
                Map<String, Map<String, ImmutablePair<Date, Date>>> planMap = NotConfirmDysdsPlanBussiness.queryNotConfirmDysdsPlanOrderByTaxationsys(new ArrayList<Long>(taxationsysIdList));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    String id = dynamicObject.getString("id");
                    long taxationsysId = dynamicObject.getLong("taxationsys.id");
                    Date startdate = dynamicObject.getDate("startdate");
                    Date enddate = dynamicObject.getDate("enddate");
                    if (startdate == null || !DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)startdate)).equalsIgnoreCase(DateUtils.format((Date)startdate))) {
                        errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u5fc5\u987b\u4e3a\u6708\u4efd\u7b2c\u4e00\u5929\u3002", (String)"NotConfirmDysdsPlanSaveOp_0", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    if (enddate != null && !DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)enddate)).equalsIgnoreCase(DateUtils.format((Date)enddate))) {
                        errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u4e3a\u6708\u4efd\u6700\u540e\u4e00\u5929\u3002", (String)"NotConfirmDysdsPlanSaveOp_1", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    if (enddate != null && startdate.getTime() >= enddate.getTime()) {
                        errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u622a\u6b62\u65e5\u671f\u3002", (String)"NotConfirmDysdsPlanSaveOp_5", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection entryentity_item = dynamicObject.getDynamicObjectCollection("entryentity_org");
                    if (ObjectUtils.isNotEmpty((Object)entryentity_item)) {
                        block2: for (DynamicObject item : entryentity_item) {
                            Map<String, ImmutablePair<Date, Date>> map;
                            String orgId = item.getString("org.id");
                            String mapkey = taxationsysId + "_" + orgId;
                            if (!planMap.containsKey(mapkey) || !ObjectUtils.isNotEmpty(map = planMap.get(mapkey))) continue;
                            for (Map.Entry<String, ImmutablePair<Date, Date>> next : map.entrySet()) {
                                String nextKey = next.getKey();
                                if (nextKey.equalsIgnoreCase(id)) continue;
                                ImmutablePair<Date, Date> nextValue = next.getValue();
                                Date left = (Date)nextValue.left;
                                Date right = (Date)nextValue.right;
                                boolean check = true;
                                if (ObjectUtils.isEmpty((Object)enddate) && ObjectUtils.isEmpty((Object)right)) {
                                    check = false;
                                } else if (ObjectUtils.isEmpty((Object)enddate)) {
                                    if (left.getTime() >= startdate.getTime() || right.getTime() >= startdate.getTime()) {
                                        check = false;
                                    }
                                } else if (ObjectUtils.isEmpty((Object)right)) {
                                    if (startdate.getTime() >= left.getTime() || enddate.getTime() >= left.getTime()) {
                                        check = false;
                                    }
                                } else if ((enddate.getTime() >= left.getTime() && enddate.getTime() <= right.getTime() || right.getTime() >= startdate.getTime() && right.getTime() <= enddate.getTime()) && (startdate.getTime() >= left.getTime() || enddate.getTime() >= left.getTime())) {
                                    check = false;
                                }
                                if (check) continue;
                                errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u5728\u76f8\u540c\u6709\u6548\u671f\u5185\uff0c\u540c\u4e00\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u8bbe\u7f6e\u591a\u4e2a\u65b9\u6848\u3002", (String)"NotConfirmDysdsPlanSaveOp_2", (String)"taxc-itp", (Object[])new Object[0]));
                                continue block2;
                            }
                        }
                    } else {
                        errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9002\u7528\u7ec4\u7ec7\u3002", (String)"NotConfirmDysdsPlanSaveOp_3", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("entryentity_item");
                    if (!ObjectUtils.isEmpty((Object)objectCollection)) continue;
                    errorMsgMap.put(dynamicObject.getString("id"), ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d6\u6570\u9879\u76ee\u3002", (String)"NotConfirmDysdsPlanSaveOp_4", (String)"taxc-itp", (Object[])new Object[0]));
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String id = dataEntity.getDataEntity().getString("id");
                    if (!errorMsgMap.containsKey(id)) continue;
                    this.addFatalErrorMessage(dataEntity, (String)errorMsgMap.get(id));
                }
            }
        });
    }
}

