/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.baseinfo.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.itp.business.taxationsys.ItpTaxationsysCommonBusiness;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SharedPlanOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                List<Long> taxationsysList = ItpTaxationsysCommonBusiness.queryValidTaxationsys();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    StringBuilder info;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    Long taxationsysId = dataEntity.getDataEntity().getLong("taxationsys.id");
                    DynamicObjectCollection rules = currentObj.getDynamicObjectCollection("ruleentity");
                    DynamicObjectCollection orgs = currentObj.getDynamicObjectCollection("orgentity");
                    if (ObjectUtils.isNotEmpty((Object)taxationsysId) && !taxationsysList.contains(taxationsysId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6536\u5236\u5ea6\u4e0d\u53ef\u7528\u3002", (String)"SharedPlanOp_12", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    if (rules.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_0", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    if (orgs.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_1", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)rules) && ((DynamicObject)rules.get(0)).get("rule") instanceof Long) {
                        List ruleIds = rules.stream().map(o -> o.getLong("rule")).collect(Collectors.toList());
                        Iterator qFilter = new QFilter("id", "in", ruleIds);
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_accessconfig", (String)"id,number,accessproject.id,taxationsys.id", (QFilter[])new QFilter[]{qFilter});
                        Set set = collection.stream().map(o -> o.getLong("accessproject.id")).collect(Collectors.toSet());
                        if (rules.size() > set.size()) {
                            StringBuilder info2 = new StringBuilder();
                            collection.forEach(o -> {
                                if (!set.remove(o.getLong("accessproject.id"))) {
                                    info2.append(o.getString("number")).append(' ');
                                }
                            });
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharedPlanOp_2", (String)"taxc-itp", (Object[])new Object[0]), info2));
                            continue;
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)rules) && ((DynamicObject)rules.get(0)).get("rule") instanceof DynamicObject) {
                        boolean flag = false;
                        for (DynamicObject rule : rules) {
                            if (rule.get("rule") != null && !StringUtils.isEmpty((CharSequence)((DynamicObject)rule.get("rule")).getString("number"))) continue;
                            flag = true;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_3", (String)"taxc-itp", (Object[])new Object[0]));
                        }
                        if (flag) continue;
                        Set ruleSet = rules.stream().filter(o -> null != o.getDynamicObject("rule")).map(o -> o.getDynamicObject("rule").getLong("id")).collect(Collectors.toSet());
                        if (rules.size() > ruleSet.size()) {
                            info = new StringBuilder();
                            rules.forEach(o -> {
                                if (!ruleSet.remove(o.getLong("rule.id"))) {
                                    info.append(o.getString("rule.number")).append(' ');
                                }
                            });
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharedPlanOp_2", (String)"taxc-itp", (Object[])new Object[0]), info));
                            continue;
                        }
                        rules.forEach(o -> {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)o.getString("rule.enable"), (CharSequence)"1")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u53d6\u6570\u89c4\u5219\u672a\u542f\u7528\u3002", (String)"SharedPlanOp_4", (String)"taxc-itp", (Object[])new Object[0]));
                            }
                            if (!StringUtils.equalsIgnoreCase((CharSequence)o.getString("rule.ruletype"), (CharSequence)"public")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u53ef\u4ee5\u5171\u4eab\u3002", (String)"SharedPlanOp_5", (String)"taxc-itp", (Object[])new Object[0]));
                            }
                        });
                        Long taxSys = currentObj.get("taxationsys") == null ? 0L : currentObj.getLong("taxationsys.id");
                        QFilter qFilter = new QFilter("id", "in", (Object)ruleSet);
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"itp_accessconfig", (String)"id,number,accessproject.id,taxationsys.id", (QFilter[])new QFilter[]{qFilter});
                        Set taxSysSet = collection.stream().map(m -> m.getLong("taxationsys.id")).collect(Collectors.toSet());
                        if (!CollectionUtils.isNotEmpty(taxSysSet) || taxSysSet.size() != 1 || !((Long)taxSysSet.stream().findFirst().get()).equals(taxSys)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"SharedPlanOp_10", (String)"taxc-itp", (Object[])new Object[0]));
                            continue;
                        }
                    }
                    if (orgs.isEmpty() || !(((DynamicObject)orgs.get(0)).get("org") instanceof DynamicObject)) continue;
                    boolean orgCheckResult = false;
                    for (DynamicObject org : orgs) {
                        if (org.get("org") != null && !StringUtils.isEmpty((CharSequence)((DynamicObject)org.get("org")).getString("number"))) continue;
                        orgCheckResult = true;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_6", (String)"taxc-itp", (Object[])new Object[0]));
                    }
                    if (orgCheckResult) continue;
                    Set orgSet = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
                    if (orgs.size() > orgSet.size()) {
                        info = new StringBuilder();
                        orgs.forEach(o -> {
                            if (!orgSet.remove(o.getLong("org.id"))) {
                                info.append(o.getString("org.number")).append(' ');
                            }
                        });
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u91cd\u590d\u7684\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"SharedPlanOp_7", (String)"taxc-itp", (Object[])new Object[0]), info));
                        continue;
                    }
                    List<Long> orgsList = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                    QFilter statusQ = new QFilter("status", "!=", (Object)"1");
                    QFilter idQ = new QFilter("id", "in", (Object)orgsList.toArray());
                    List<DynamicObject> collection = ItpTaxOrgCommonBusiness.queryTaxcOrgByOrgIds(orgsList);
                    Set taxOrgIds = collection.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
                    List<DynamicObject> noTaxOrg = orgs.stream().filter(m -> !taxOrgIds.contains(m.getLong("org.id"))).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(noTaxOrg)) {
                        StringBuilder info3 = new StringBuilder();
                        noTaxOrg.forEach(o -> info3.append(o.getString("org.number")).append(' '));
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u4e3a\u975e\u7a0e\u52a1\u7ec4\u7ec7\u6216\u88ab\u7981\u7528\u3002", (String)"SharedPlanOp_11", (String)"taxc-itp", (Object[])new Object[0]), info3));
                        continue;
                    }
                    Long taxSys = currentObj.get("taxationsys") == null ? 0L : currentObj.getLong("taxationsys.id");
                    ArrayList otherOrgList = new ArrayList();
                    Arrays.stream(this.dataEntities).forEach(o -> {
                        long localTaxSys;
                        DynamicObject obj = o.getDataEntity();
                        long l = localTaxSys = obj.get("taxationsys") == null ? 0L : obj.getLong("taxationsys.id");
                        if (localTaxSys != 0L && !StringUtils.equalsIgnoreCase((CharSequence)obj.getString("id"), (CharSequence)currentObj.getString("id"))) {
                            DynamicObjectCollection dynamicObjects = obj.getDynamicObjectCollection("orgentity");
                            otherOrgList.addAll(dynamicObjects.stream().map(row -> row.getLong("org.id") + "#" + localTaxSys).collect(Collectors.toList()));
                        }
                    });
                    List orgsStrList = orgs.stream().map(o -> o.getLong("org.id") + "#" + taxSys).collect(Collectors.toList());
                    List intersection = (List)CollectionUtils.intersection(otherOrgList, orgsList);
                    if (intersection.isEmpty()) {
                        QFilter idFilter = new QFilter("id", "!=", currentObj.get("id"));
                        List orgIds = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                        QFilter orgQ = new QFilter("orgentity.org", "in", orgIds);
                        QFilter taxQ = new QFilter("taxationsys", "=", (Object)taxSys);
                        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"itp_income_shardingplan", (String)"orgentity.org.id", (QFilter[])new QFilter[]{idFilter, orgQ, taxQ});
                        dynamicObjectCollection.forEach(row -> intersection.add(row.getLong("orgentity.org.id") + "#" + taxSys));
                    }
                    if (intersection.isEmpty()) continue;
                    StringBuilder error = new StringBuilder();
                    List dupOrgs = intersection.stream().map(m -> m.split("#")[0]).collect(Collectors.toList());
                    orgs.forEach(o -> {
                        if (dupOrgs.contains(o.getString("org.id")) && !error.toString().contains(o.getString("org.number"))) {
                            error.append(o.getString("org.number")).append(' ');
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u5df2\u914d\u7f6e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharedPlanOp_9", (String)"taxc-itp", (Object[])new Object[0]), error));
                }
            }
        });
    }
}

