/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.baseinfo.taxlosses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaxLossesConfigEnableOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final ArrayList succIds = new ArrayList(8);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                List ids = Arrays.stream(this.dataEntities).map(m -> m.getDataEntity().getLong("id")).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"itp_tax_losses_config", (String)"id,name,number,startdate,enddate,taxationsys,applicationscope,orgentryentity,orgentryentity.org,orgentryentity.org.id", (QFilter[])new QFilter("id", "in", ids).toArray());
                Map<Long, DynamicObject> objectMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (k1, k2) -> k1));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection dyoList;
                    DynamicObject taxLossesConfigDyo = objectMap.get(dataEntity.getDataEntity().getLong("id"));
                    if (taxLossesConfigDyo == null) continue;
                    Date startDate = taxLossesConfigDyo.getDate("startdate");
                    Date endDate = taxLossesConfigDyo.getDate("enddate");
                    long taxationsys = taxLossesConfigDyo.getLong("taxationsys.id");
                    String applicationscope = taxLossesConfigDyo.getString("applicationscope");
                    QFilter filter = new QFilter("id", "!=", dataEntity.getBillPkId()).and("taxationsys", "=", (Object)taxationsys).and("applicationscope", "=", (Object)applicationscope);
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1").or("id", "in", (Object)succIds);
                    filter.and(enableFilter);
                    if ("2".equalsIgnoreCase(applicationscope)) {
                        DynamicObjectCollection orgCollection = (DynamicObjectCollection)taxLossesConfigDyo.get("orgentryentity");
                        List orgIds = orgCollection.stream().map(m -> m.get("org.id")).collect(Collectors.toList());
                        filter.and("orgentryentity.org", "in", orgIds);
                    }
                    if (TaxLossesConfigEnableOp.this.check(dyoList = QueryServiceHelper.query((String)"itp_tax_losses_config", (String)"startdate,enddate,id", (QFilter[])filter.toArray()), startDate, endDate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u9002\u7528\u8303\u56f4\u3001\u7a0e\u6536\u5236\u5ea6\u7684\u53ef\u7528\u7a0e\u4e8f\u8bbe\u7f6e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TaxLossesConfigEnableOp_0", (String)"taxc-itp", (Object[])new Object[0]));
                        continue;
                    }
                    succIds.add(taxLossesConfigDyo.getLong("id"));
                }
            }
        });
    }

    private boolean check(DynamicObjectCollection dynamicObjects, Date startDate2, Date endDate2) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date enddate;
            Date startdate = dynamicObject.getDate("startdate");
            if (!this.chekcInterDate(startdate, enddate = dynamicObject.getDate("enddate"), startDate2, endDate2)) continue;
            return true;
        }
        return false;
    }

    private boolean chekcInterDate(Date startDate, Date endDate, Date startDateInput, Date endDateInput) {
        if (endDate == null) {
            return endDateInput == null || endDateInput.compareTo(startDate) >= 0;
        }
        if (endDateInput == null) {
            return startDateInput.compareTo(endDate) <= 0;
        }
        return startDateInput.compareTo(endDate) <= 0 && endDateInput.compareTo(startDate) >= 0;
    }
}

