/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.jtysbthan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.opplugin.multideclarelist.DeclareListDeleteOp;
import kd.taxc.itp.business.license.ItpLicenseCheckBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtysbThanDeleteOp
extends DeclareListDeleteOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object)dataEntities)) {
                    return;
                }
                ArrayList<Long> orgList = new ArrayList<Long>(12);
                for (ExtendedDataEntity objs : dataEntities) {
                    long orgId = objs.getDataEntity().getLong("org.id");
                    orgList.add(orgId);
                }
                if (ItpLicenseCheckBusiness.checkLicense().booleanValue()) {
                    Map<Long, Boolean> licenseBatchCheckMap = ItpLicenseCheckBusiness.orgLicenseBatchCheck(orgList);
                    for (ExtendedDataEntity obj : dataEntities) {
                        long orgId = obj.getDataEntity().getLong("org.id");
                        if (licenseBatchCheckMap.containsKey(orgId) && !licenseBatchCheckMap.get(orgId).booleanValue()) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u4e13\u4e1a\u8bb8\u53ef\u3002", (String)"ItpJtysbThanDeleteOp_0", (String)"taxc-itp", (Object[])new Object[0]), obj.getDataEntity().getString("org.name")));
                    }
                }
            }
        });
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected void businessDelete(List<Object> list) {
    }
}

