/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.license;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.itp.business.license.ItpLicenseCheckBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpLicenseCheckOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object)dataEntities)) {
                    return;
                }
                ArrayList<Long> orgList = new ArrayList<Long>(12);
                for (ExtendedDataEntity objs : dataEntities) {
                    long orgId = objs.getDataEntity().getLong("org.id");
                    orgList.add(orgId);
                }
                if (ItpLicenseCheckBusiness.checkLicense().booleanValue()) {
                    Map<Long, Boolean> licenseBatchCheckMap = ItpLicenseCheckBusiness.orgLicenseBatchCheck(orgList);
                    for (ExtendedDataEntity obj : dataEntities) {
                        long orgId = obj.getDataEntity().getLong("org.id");
                        if (licenseBatchCheckMap.containsKey(orgId) && !licenseBatchCheckMap.get(orgId).booleanValue()) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u4e13\u4e1a\u8bb8\u53ef\u3002", (String)"ItpLicenseCheckOp_0", (String)"taxc-itp", (Object[])new Object[0]), obj.getDataEntity().getString("org.name")));
                    }
                }
            }
        });
    }
}

