/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.papers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.itp.business.provision.impl.GenerateProvisionBillServiceImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AddOrDelProvisionByDraftOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"deletejtd")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List idList = Arrays.stream(dataEntities).map(o -> o.getPkValue()).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_declare_main_tsd"));
            Arrays.stream(dynamicObjects).forEach(row -> {
                row.set("generatebusinessdoc", (Object)Boolean.FALSE);
                row.set("businessdocno", null);
            });
            Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            ArrayList successDraftBillNoList = new ArrayList();
            HashSet sourceDraftTypeList = new HashSet();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            ArrayList successIdList = new ArrayList();
            Arrays.stream(successResult).forEach(o -> {
                successIdList.add(((DynamicObject)o).getLong("id"));
                successDraftBillNoList.add(((DynamicObject)o).getString("billno"));
                sourceDraftTypeList.add(((DynamicObject)o).getString("templatetype.name"));
            });
            QFilter billNoQ = new QFilter("entitynumber", "in", successDraftBillNoList);
            QFilter sourceDraftTypeQ = new QFilter("sourcedrafttype", "in", sourceDraftTypeList);
            QFilter entitytypeQ = new QFilter("entitytype", "=", (Object)"tpo_declare_main_tsd");
            DeleteServiceHelper.delete((String)"itp_proviston_taxes", (QFilter[])new QFilter[]{billNoQ, sourceDraftTypeQ, entitytypeQ});
            for (DynamicObject entity : dataEntities) {
                if (successIdList.contains(entity.getLong("id"))) {
                    successObjs.add(entity);
                    continue;
                }
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25", (String)"AddOrDelProvisionByDraftOp_0", (String)"taxc-itp", (Object[])new Object[0]), entity.getString("billno"));
                ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_Proviston_fail", ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"AddOrDelProvisionByDraftOp_1", (String)"taxc-itp", (Object[])new Object[0]), msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operationKey, (CharSequence)"newjtd")) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List<Long> draftIds = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
            GenerateProvisionBillServiceImpl service = new GenerateProvisionBillServiceImpl();
            Map<Boolean, Map<Long, String>> resultMap = service.generateProvisionBill(draftIds);
            HashSet successDraftIdList = new HashSet();
            for (Map.Entry<Boolean, Map<Long, String>> entry : resultMap.entrySet()) {
                successDraftIdList = entry.getKey() != false ? entry.getValue().entrySet().stream().map(o -> (Long)o.getKey()).collect(Collectors.toSet()) : successDraftIdList;
            }
            ArrayList<DynamicObject> successDraftObjectList = new ArrayList<DynamicObject>();
            ArrayList saveSuccDraftId = new ArrayList();
            if (ObjectUtils.isNotEmpty(successDraftIdList)) {
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])successDraftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.billEntityType.getName()));
                Arrays.stream(dynamicObjects).forEach(row -> row.set("generatebusinessdoc", (Object)Boolean.TRUE));
                Object[] successResult = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                Arrays.stream(successResult).forEach(o -> saveSuccDraftId.add(((DynamicObject)o).getLong("id")));
            }
            for (DynamicObject rowObject : dataEntities) {
                ValidationErrorInfo info;
                Long draftId = rowObject.getLong("id");
                if (saveSuccDraftId.contains(rowObject.getLong("id"))) {
                    successDraftObjectList.add(rowObject);
                    continue;
                }
                String title = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"AddOrDelProvisionByDraftOp_2", (String)"taxc-itp", (Object[])new Object[0]);
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AddOrDelProvisionByDraftOp_3", (String)"taxc-itp", (Object[])new Object[0]), rowObject.getString("billno"));
                Map<Long, String> failMap = resultMap.get(Boolean.FALSE);
                if (ObjectUtils.isNotEmpty((Object)failMap.get(draftId))) {
                    info = new ValidationErrorInfo("", (Object)"", 0, 0, "generate_Proviston_fail", title, failMap.get(draftId), ErrorLevel.FatalError);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                    continue;
                }
                info = new ValidationErrorInfo("", (Object)"", 0, 0, "generate_Proviston_fail", title, msg, ErrorLevel.FatalError);
                this.operationResult.addErrorInfo((OperateErrorInfo)info);
            }
            args.setDataEntities(successDraftObjectList.toArray(new DynamicObject[0]));
        }
    }
}

