/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.opplugin.papers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.opplugin.multideclarelist.DeclareListDeleteOp;
import kd.taxc.itp.business.license.ItpLicenseCheckBusiness;
import kd.taxc.itp.business.papers.ProvisionDeclarationComparisonBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftDeleteOp
extends DeclareListDeleteOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject[] adjustJtysbbdDraft;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object)dataEntities)) {
                    return;
                }
                ArrayList<Long> idList = new ArrayList<Long>(12);
                ArrayList<Long> orgList = new ArrayList<Long>(12);
                for (ExtendedDataEntity objs : dataEntities) {
                    long id = objs.getDataEntity().getLong("id");
                    long orgId = objs.getDataEntity().getLong("org.id");
                    idList.add(id);
                    orgList.add(orgId);
                }
                if (ItpLicenseCheckBusiness.checkLicense().booleanValue()) {
                    Map<Long, Boolean> licenseBatchCheckMap = ItpLicenseCheckBusiness.orgLicenseBatchCheck(orgList);
                    for (ExtendedDataEntity obj : dataEntities) {
                        long l = obj.getDataEntity().getLong("org.id");
                        if (licenseBatchCheckMap.containsKey(l) && !licenseBatchCheckMap.get(l).booleanValue()) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u4e13\u4e1a\u8bb8\u53ef\u3002", (String)"ItpJtysbThanDeleteOp_0", (String)"taxc-itp", (Object[])new Object[0]), obj.getDataEntity().getString("org.name")));
                    }
                }
                if (ObjectUtils.isEmpty((Object)(adjustJtysbbdDraft = ProvisionDeclarationComparisonBusiness.getAdjustJtysbbdDraft(idList)))) {
                    return;
                }
                ArrayList<Long> isAdjuestIdList = new ArrayList<Long>(12);
                for (DynamicObject dynamicObject : adjustJtysbbdDraft) {
                    if (ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection("entryentity")) || !"yes".equalsIgnoreCase(((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getString("isadjuest"))) continue;
                    isAdjuestIdList.add(((DynamicObject)dynamicObject.getDynamicObjectCollection("entryentity").get(0)).getLong("draftid"));
                }
                for (DynamicObject dynamicObject : dataEntities) {
                    long id = dynamicObject.getDataEntity().getLong("id");
                    if (!isAdjuestIdList.contains(id)) continue;
                    this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u5e95\u7a3f\u5df2\u6821\u51c6\u5e74\u521d\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5148\u53d6\u6d88\u6821\u51c6\u3002", (String)"ItpDraftDeleteOp_0", (String)"taxc-itp", (Object[])new Object[0]));
                }
            }
        });
    }

    public String getModelNumber() {
        return "TSD001";
    }

    protected void businessDelete(List<Object> list) {
        DeleteServiceHelper.delete((String)"itp_draft_tab", (QFilter[])new QFilter[]{new QFilter("draftid", "in", list)});
        DeleteServiceHelper.delete((String)"itp_draft_etr", (QFilter[])new QFilter[]{new QFilter("draftid", "in", list)});
    }
}

