/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.report.formplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.taxorg.ItpTaxOrgCommonBusiness;

public class EffectiveTaxRateRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final List<String> FILEDS = Arrays.asList("dqsdsfy_snsjtz", "dqsdsfy_snhjtz", "dysdsfy_snsjtz", "dysdsfy_snhjtz");
    private static final String REPORTLISTAP = "reportlistap";
    private static final String SBBID = "sbbid";
    private static final String ORGNAME = "orgname";
    private static final String BTNOK = "btnok";
    private static final String ORGS = "orgs";

    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl(REPORTLISTAP);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit tablefield = (MulBasedataEdit)this.getControl(ORGS);
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("remarks".equalsIgnoreCase(evt.getOperateKey())) {
            ReportList reportlist = (ReportList)this.getView().getControl(REPORTLISTAP);
            int[] rows = reportlist.getEntryState().getSelectedRows();
            IReportListModel model = reportlist.getReportModel();
            if (rows.length < 1 || rows[0] == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u5907\u6ce8\u3002", (String)"EffectiveTaxRateRptPlugin_0", (String)"taxc-itp", (Object[])new Object[0]));
                return;
            }
            DynamicObject object = model.getRowData(rows[0]);
            HashMap<String, String> customParams = new HashMap<String, String>(4);
            customParams.put(SBBID, object.getString(SBBID));
            customParams.put("remarks", object.getString("remarks"));
            FormShowParameter param = new FormShowParameter();
            param.setCustomParams(customParams);
            param.setFormId("itp_draft_remark");
            param.setCaption(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"EffectiveTaxRateRptPlugin_1", (String)"taxc-itp", (Object[])new Object[0]));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTNOK));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (BTNOK.equals(evt.getActionId())) {
            ReportList reportlist = (ReportList)this.getView().getControl(REPORTLISTAP);
            reportlist.refresh();
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List filterItemInfoList = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItemInfoList) {
            if (!ORGS.equalsIgnoreCase(filterItemInfo.getPropName()) || filterItemInfo.getValue() != null || !"67".equalsIgnoreCase(filterItemInfo.getCompareType())) continue;
            List<Long> taxOrgIdsWithPerm = ItpTaxOrgCommonBusiness.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
            filterItemInfo.setValue(taxOrgIdsWithPerm);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (ORGS.equalsIgnoreCase(name)) {
            List<Long> taxOrgIdsWithPerm = ItpTaxOrgCommonBusiness.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
            formShowParameter.setMultiSelect(true);
            QFilter qFilter = new QFilter("id", "in", taxOrgIdsWithPerm);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        boolean showAdj = (Boolean)this.getModel().getValue("showrtaadj");
        event.getColumns().stream().filter(m -> m instanceof ReportColumn && ((ReportColumn)m).getFieldKey().equals(SBBID)).forEach(m -> ((ReportColumn)m).setHide(true));
        if (!showAdj) {
            event.getColumns().stream().filter(m -> m instanceof ReportColumnGroup).forEach(abstractReportColumn -> {
                ReportColumnGroup reportColumnGroup = (ReportColumnGroup)abstractReportColumn;
                List children = reportColumnGroup.getChildren();
                for (AbstractReportColumn child : children) {
                    if (!(child instanceof ReportColumn)) continue;
                    ReportColumn reportColumn = (ReportColumn)child;
                    String field = reportColumn.getFieldKey();
                    reportColumn.setHide(FILEDS.contains(field));
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("skssqz", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        long org = RequestContext.get().getOrgId();
        List<Long> allPermOrgs = ItpTaxOrgCommonBusiness.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
        if (!ObjectUtils.isEmpty(allPermOrgs)) {
            if (allPermOrgs.contains(org)) {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(org).toArray());
            } else {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(allPermOrgs.get(0)).toArray());
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object taxSys = this.getModel().getValue("taxationsys");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        Object accountSetType = this.getModel().getValue("accountsettype");
        if (EmptyCheckUtils.isEmpty((Object)taxSys) || EmptyCheckUtils.isEmpty((Object)endDate) || EmptyCheckUtils.isEmpty((Object)accountSetType)) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject rowData = ((ReportList)evt.getSource()).getReportModel().getRowData(evt.getRowIndex());
        DynamicObject declareMain = BusinessDataServiceHelper.loadSingle((Object)rowData.get(SBBID), (String)"tpo_declare_main_tsd");
        if (ORGNAME.equalsIgnoreCase(evt.getFieldName())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("entryid", declareMain.getString("id"));
            customParams.put("billno", declareMain.getString("billno"));
            customParams.put("orgid", declareMain.getDynamicObject("org").getString("id"));
            customParams.put(ORGNAME, declareMain.getDynamicObject("org").getString("name"));
            Date skssqq = declareMain.getDate("skssqq");
            Date skssqz = declareMain.getDate("skssqz");
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put("skssqq", startDate);
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", declareMain.getDate("modifytime"));
            String dataType = declareMain.getString("datatype");
            customParams.put("datatype", dataType);
            customParams.put("comment", declareMain.get("remarks"));
            customParams.put("papers_status", declareMain.get("billstatus"));
            customParams.put("taxationsys", ((DynamicObject)declareMain.get("taxsystem")).getLong("id"));
            customParams.put("zt_type", declareMain.getString("accountsettype"));
            customParams.put("remarks", declareMain.getString("remarks"));
            String type = declareMain.getString("templatetype.number");
            FormShowParameter param = new FormShowParameter();
            TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
            param.setFormId(templateEnum.getDeclarePage());
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
    }
}

