/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.report.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.business.fetchitem.FetchItemsBussiness;
import kd.taxc.itp.business.systemParameter.ItpSystemParameterBussiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class EffectiveTaxRateRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(EffectiveTaxRateRptQueryPlugin.class);
    private static final String[] FIELDS = new String[]{"sbbid", "orgname", "orgnumer", "zt_type", "sqlr", "dqsdsfy_bnfy", "dqsdsfy_snsjtz", "dqsdsfy_snhjtz", "dqsdsfy_zmyjt", "dqsdsfy_zmtz", "dqsdsfy_bqtz", "dqsdsfy", "jsndqsdsfy", "dysdsfy_bnfy", "dysdsfy_snsjtz", "dysdsfy_snhjtz", "dysdsfy_zmyjt", "dysdsfy_zmtz", "dysdsfy_bqtz", "dysdsfy", "jsndysdsfy", "yxsfl", "jsnyxsfl", "remarks"};
    private static final DataType[] TYPES = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
    private static final String TAXATION_SYS = "taxationsys";
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String BD_ZT = "bdzt";
    private static final String JT_ZT = "jtzt";
    private static final RowMeta ROW_META = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])TYPES);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        String itpJtsdshjsbd;
        Collection<Long> orgIds = new ArrayList<Long>(8);
        Long taxationsysId = null;
        Date skssqz = null;
        String accountsettype = null;
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        block12: for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "orgs": {
                    Object value = filterItemInfo.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        orgIds = groups.keySet();
                        break;
                    }
                    if (value instanceof DynamicObject) {
                        orgIds = Collections.singletonList(((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List orgs = (List)value;
                    if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue block12;
                    orgIds = orgs.stream().filter(Objects::nonNull).map(m -> Long.parseLong(m.toString())).collect(Collectors.toSet());
                    break;
                }
                case "taxationsys": {
                    if (!(filterItemInfo.getValue() instanceof DynamicObject)) break;
                    taxationsysId = ((DynamicObject)filterItemInfo.getValue()).getLong("id");
                    break;
                }
                case "skssqz": {
                    skssqz = DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue()));
                    break;
                }
                case "accountsettype": {
                    accountsettype = (String)filterItemInfo.getValue();
                    break;
                }
            }
        }
        DynamicObjectCollection declareMainList = this.queryDeclareMain(orgIds, taxationsysId, skssqz, accountsettype, true);
        Map<Long, Map<String, BigDecimal>> sdsMap = this.queryDetailMap(declareMainList);
        Set<Long> sbbIds = declareMainList.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> etrInfoList = this.getEtrInfo(sbbIds);
        Date preYearSkssqz = DateUtils.stringToDate((String)(DateUtils.getYearOfDate((Date)DateUtils.addYear((Date)skssqz, (int)-1)) + "-12-31"));
        DynamicObjectCollection preDeclareMainList = this.queryDeclareMain(orgIds, taxationsysId, preYearSkssqz, accountsettype, true);
        Map<Long, Map<String, BigDecimal>> preDeclareMainMap = this.queryDetailMap(preDeclareMainList);
        List<Long> gaapZcfetchItems = FetchItemsBussiness.getFetchItemsByBiztype("YWLB0004");
        HashMap<Long, Map<String, BigDecimal>> preDbMap = new HashMap(4);
        ArrayList<Long> orgList = new ArrayList<Long>(12);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgList.addAll(orgIds);
        }
        if ("tsbd".equalsIgnoreCase(itpJtsdshjsbd = ItpSystemParameterBussiness.getItpJtsdshjsbd(ObjectUtils.isNotEmpty(orgList) ? (Long)orgList.get(0) : Long.valueOf(0L)))) {
            preDbMap = this.queryDetailMap(this.queryDeclareMain(orgIds, taxationsysId, preYearSkssqz, accountsettype, Collections.singletonList("sdhjbd")));
            for (Long orgid : orgIds) {
                Map<String, BigDecimal> gaapZcSumMap = this.getGappZcValueSum(preDbMap, orgid, gaapZcfetchItems, "sdhjbd");
                if (!preDbMap.containsKey(orgid)) continue;
                ((Map)preDbMap.get(orgid)).putAll(gaapZcSumMap);
            }
        } else if ("fkbd".equalsIgnoreCase(itpJtsdshjsbd)) {
            Iterator collection1 = this.queryDeclareMain(orgIds, taxationsysId, preYearSkssqz, accountsettype, Collections.singletonList("sdbd"));
            DynamicObjectCollection collection2 = this.queryDeclareMain(orgIds, taxationsysId, preYearSkssqz, accountsettype, Collections.singletonList("hjbd"));
            Map<Long, Map<String, BigDecimal>> longMapMap = this.queryDetailMap((DynamicObjectCollection)collection1);
            Map<Long, Map<String, BigDecimal>> longMapMap1 = this.queryDetailMap(collection2);
            for (Long orgid : orgIds) {
                BigDecimal jtysbbd_sjtz = this.getValueFromDataMap(longMapMap, orgid, "dqsds_sjynsdse#jtysbbd_sjtz");
                BigDecimal jtysbbd_hj_sjtz = this.getValueFromDataMap(longMapMap, orgid, "dqsds_zsxcy#jtysbbd_sjtz");
                Map<String, BigDecimal> sdgaapZcSumMap = this.getGappZcValueSum(longMapMap, orgid, gaapZcfetchItems, "sdbd");
                BigDecimal dqsdsfysnhjtz = this.getValueFromDataMap(longMapMap1, orgid, "dqsds_sjynsdse#jtysbbd_hjtz");
                BigDecimal jtysbbd_hj_tz = this.getValueFromDataMap(longMapMap1, orgid, "dqsds_zsxcy#jtysbbd_hjtz");
                Map<String, BigDecimal> hjgaapZcSumMap = this.getGappZcValueSum(longMapMap1, orgid, gaapZcfetchItems, "hjbd");
                if (!preDbMap.containsKey(orgid)) {
                    preDbMap.put(orgid, new HashMap(12));
                }
                ((Map)preDbMap.get(orgid)).put("dqsds_sjynsdse#jtysbbd_sjtz", jtysbbd_sjtz);
                ((Map)preDbMap.get(orgid)).put("dqsds_sjynsdse#jtysbbd_hjtz", dqsdsfysnhjtz);
                ((Map)preDbMap.get(orgid)).put("dqsds_zsxcy#jtysbbd_sjtz", jtysbbd_hj_sjtz);
                ((Map)preDbMap.get(orgid)).put("dqsds_zsxcy#jtysbbd_hjtz", jtysbbd_hj_tz);
                ((Map)preDbMap.get(orgid)).putAll(sdgaapZcSumMap);
                ((Map)preDbMap.get(orgid)).putAll(hjgaapZcSumMap);
            }
        }
        for (DynamicObject declareMain : declareMainList) {
            Object[] rowData = this.handleRowData(accountsettype, sdsMap, etrInfoList, preDbMap, declareMain, preDeclareMainMap, itpJtsdshjsbd);
            result.add(rowData);
        }
        CollectionInput inputs = new CollectionInput(ROW_META, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Object[] handleRowData(String accountSetType, Map<Long, Map<String, BigDecimal>> sdsMap, List<DynamicObject> etrInfoList, Map<Long, Map<String, BigDecimal>> preDbMap, DynamicObject declareMain, Map<Long, Map<String, BigDecimal>> preDeclareMainMap, String bdtype) {
        BigDecimal dqsdsfysnhjtz;
        DynamicObject etrInfo = null;
        long sbbId = declareMain.getLong("id");
        long orgid = declareMain.getLong("orgid");
        Optional<DynamicObject> etrInfoOption = etrInfoList.stream().filter(m -> m.getLong("draftid") == sbbId).findFirst();
        if (etrInfoOption.isPresent()) {
            etrInfo = etrInfoOption.get();
        }
        String orgName = declareMain.getString("org.name");
        String orgNumber = declareMain.getString("org.number");
        BigDecimal sqlr = null;
        if (BD_ZT.equalsIgnoreCase(accountSetType)) {
            sqlr = this.getValueFromDataMap(sdsMap, orgid, "dqsds_sqlr_bd#dqsds_hj");
        } else if (JT_ZT.equalsIgnoreCase(accountSetType)) {
            sqlr = this.getValueFromDataMap(sdsMap, orgid, "dqsds_sqlr_jt#dqsds_hj");
        }
        BigDecimal dqsdsfybnfy = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dqsdsfy_bnyjfy#sjjs_je");
        BigDecimal dqsdsfysnsjtz = this.getValueFromDataMap(preDbMap, orgid, "dqsds_sjynsdse#jtysbbd_sjtz");
        if (dqsdsfysnsjtz == null) {
            dqsdsfysnsjtz = new BigDecimal("0.00");
        }
        if ((dqsdsfysnhjtz = this.getValueFromDataMap(preDbMap, orgid, "dqsds_sjynsdse#jtysbbd_hjtz")) == null) {
            dqsdsfysnhjtz = new BigDecimal("0.00");
        }
        BigDecimal dqsdsfyzmyjt = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dqsdsfy_zmyjt#sjjs_je");
        BigDecimal dqsdsfyzmtz = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dqsdsfy_zmtz#sjjs_je");
        BigDecimal dqsdsfybqtz = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dqsdsfy_bqtz#sjjs_je");
        String dqsdsfy = etrInfo == null || etrInfo.get("dqsdsfy") == null ? null : etrInfo.getBigDecimal("dqsdsfy").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String jsndqsdsfy = etrInfo == null || etrInfo.get("jsndqsdsfy") == null ? null : etrInfo.getBigDecimal("jsndqsdsfy").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        BigDecimal dysdsfybnfy = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dysdsfy_bnyjfy#sjjs_je");
        BigDecimal dysdsSnqnjts_sl = this.getValueFromDataMap(preDeclareMainMap, orgid, "dysds_dysdsl#dysds_snqnjts");
        if (ObjectUtils.isEmpty((Object)dysdsSnqnjts_sl)) {
            dysdsSnqnjts_sl = new BigDecimal("25.00");
        }
        dysdsSnqnjts_sl = dysdsSnqnjts_sl.divide(new BigDecimal("100"), 2, 4);
        BigDecimal dqsdszsxcy = this.getValueFromDataMap(preDbMap, orgid, "dqsds_zsxcy#jtysbbd_sjtz");
        BigDecimal gaapzcjtysbbd_sjtz = null;
        BigDecimal gaapzcjtysbbd_hjtz = null;
        if ("tsbd".equalsIgnoreCase(bdtype)) {
            gaapzcjtysbbd_sjtz = this.getValueFromDataMap(preDbMap, orgid, "sdhjbd_gaapzcjtysbbd_sjtz");
            gaapzcjtysbbd_hjtz = this.getValueFromDataMap(preDbMap, orgid, "sdhjbd_gaapzcjtysbbd_hjtz");
        } else if ("fkbd".equalsIgnoreCase(bdtype)) {
            gaapzcjtysbbd_sjtz = this.getValueFromDataMap(preDbMap, orgid, "sdbd_gaapzcjtysbbd_sjtz");
            gaapzcjtysbbd_hjtz = this.getValueFromDataMap(preDbMap, orgid, "hjbd_gaapzcjtysbbd_hjtz");
        }
        BigDecimal dysdsfysnsjtz = null;
        if (dqsdszsxcy != null) {
            if (gaapzcjtysbbd_sjtz != null) {
                dqsdszsxcy = dqsdszsxcy.add(gaapzcjtysbbd_sjtz);
            }
            dysdsfysnsjtz = dqsdszsxcy.multiply(dysdsSnqnjts_sl).setScale(2, RoundingMode.HALF_UP);
        } else {
            dysdsfysnsjtz = gaapzcjtysbbd_sjtz != null ? gaapzcjtysbbd_sjtz.multiply(dysdsSnqnjts_sl).setScale(2, RoundingMode.HALF_UP) : new BigDecimal("0.00");
        }
        BigDecimal dysdsfysnhjtz = null;
        BigDecimal dqsdszsxcyhjtz = this.getValueFromDataMap(preDbMap, orgid, "dqsds_zsxcy#jtysbbd_hjtz");
        if (dqsdszsxcyhjtz != null) {
            if (gaapzcjtysbbd_hjtz != null) {
                dqsdszsxcyhjtz = dqsdszsxcyhjtz.add(gaapzcjtysbbd_hjtz);
            }
            dysdsfysnhjtz = dqsdszsxcyhjtz.multiply(dysdsSnqnjts_sl).setScale(2, RoundingMode.HALF_UP);
        } else {
            dysdsfysnhjtz = gaapzcjtysbbd_hjtz != null ? gaapzcjtysbbd_hjtz.multiply(dysdsSnqnjts_sl).setScale(2, RoundingMode.HALF_UP) : new BigDecimal("0.00");
        }
        BigDecimal dysdsfyzmyjt = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dysdsfy_zmyjt#sjjs_je");
        BigDecimal dysdsfyzmtz = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dysdsfy_zmtz#sjjs_je");
        BigDecimal dysdsfybqtz = this.getValueFromDataMap(sdsMap, orgid, "sjjs_dysdsfy_bqtz#sjjs_je");
        String dysdsfy = etrInfo == null || etrInfo.get("dysdsfy") == null ? null : etrInfo.getBigDecimal("dysdsfy").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String jsndysdsfy = etrInfo == null || etrInfo.get("jsndysdsfy") == null ? null : etrInfo.getBigDecimal("jsndysdsfy").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String yxsfl = etrInfo == null || etrInfo.get("yxsfl") == null ? null : etrInfo.getBigDecimal("yxsfl").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String jsnyxsfl = etrInfo == null || etrInfo.get("jsnyxsfl") == null ? null : etrInfo.getBigDecimal("jsnyxsfl").multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String remarks = declareMain.getString("remarks");
        return new Object[]{sbbId, orgName, orgNumber, accountSetType, sqlr, dqsdsfybnfy, dqsdsfysnsjtz, dqsdsfysnhjtz, dqsdsfyzmyjt, dqsdsfyzmtz, dqsdsfybqtz, dqsdsfy, jsndqsdsfy, dysdsfybnfy, dysdsfysnsjtz, dysdsfysnhjtz, dysdsfyzmyjt, dysdsfyzmtz, dysdsfybqtz, dysdsfy, jsndysdsfy, yxsfl, jsnyxsfl, remarks};
    }

    private Map<String, BigDecimal> getGappZcValueSum(Map<Long, Map<String, BigDecimal>> preDbMap, long orgId, List<Long> gaapZcfetchItems, String bdtype) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(12);
        if (MapUtils.isEmpty(preDbMap) || MapUtils.isEmpty(preDbMap.get(orgId)) || ObjectUtils.isEmpty(gaapZcfetchItems)) {
            return resultMap;
        }
        Map<String, BigDecimal> map = preDbMap.get(orgId);
        BigDecimal snsjtz = new BigDecimal("0.00");
        BigDecimal snhjtz = new BigDecimal("0.00");
        if (ObjectUtils.isNotEmpty(map)) {
            Set<Map.Entry<String, BigDecimal>> entries = map.entrySet();
            for (Map.Entry<String, BigDecimal> entry : entries) {
                String[] split;
                String entryKey = entry.getKey();
                BigDecimal entryValue = entry.getValue();
                if (!ObjectUtils.isNotEmpty((Object)entryKey) || (split = entryKey.split("_")).length < 2 || !split[0].matches("[0-9]+") || !gaapZcfetchItems.contains(Long.valueOf(split[0]))) continue;
                if (entryKey.endsWith("jtysbbd_sjtz")) {
                    snsjtz = snsjtz.add(entryValue);
                    continue;
                }
                if (!entryKey.endsWith("jtysbbd_hjtz")) continue;
                snhjtz = snhjtz.add(entryValue);
            }
        }
        resultMap.put(bdtype + "_gaapzcjtysbbd_sjtz", snsjtz);
        resultMap.put(bdtype + "_gaapzcjtysbbd_hjtz", snhjtz);
        return resultMap;
    }

    private List<DynamicObject> getEtrInfo(Collection<Long> sbbIds) {
        if (CollectionUtils.isEmpty(sbbIds)) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = new QFilter("draftid", "in", sbbIds);
        return Arrays.asList(BusinessDataServiceHelper.load((String)"itp_draft_etr", (String)"id,yxsfl,jsnyxsfl,dqsdsfy,jsndqsdsfy,dysdsfy,jsndysdsfy,draftid", (QFilter[])new QFilter[]{filter}));
    }

    private BigDecimal getValueFromDataMap(Map<Long, Map<String, BigDecimal>> dataMap, long orgId, String cellNumber) {
        if (MapUtils.isEmpty(dataMap) || MapUtils.isEmpty(dataMap.get(orgId))) {
            return null;
        }
        return dataMap.get(orgId).get(cellNumber);
    }

    private Map<Long, Map<String, BigDecimal>> queryDetailMap(DynamicObjectCollection declareMainList) {
        if (CollectionUtils.isEmpty((Collection)declareMainList)) {
            return new HashMap<Long, Map<String, BigDecimal>>(8);
        }
        Map<Long, Long> sbbIdOrgIdMap = declareMainList.stream().collect(Collectors.toMap(m -> m.getLong("id"), m -> m.getLong("orgid")));
        QFilter qFilter = new QFilter("entryid", "in", sbbIdOrgIdMap.keySet());
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"tpo_declare_detail_tsd", (String)"id,entryid,cellnumber,row,column,dynrowno,index,valuetype,value,version", (QFilter[])new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> groupRows = Arrays.stream(details).collect(Collectors.groupingBy(expense -> expense.getString("entryid")));
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>(8);
        for (Map.Entry<String, List<DynamicObject>> entry : groupRows.entrySet()) {
            Long id = Long.parseLong(entry.getKey());
            Long orgId = sbbIdOrgIdMap.get(id);
            List<DynamicObject> values = entry.getValue();
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(64);
            HashMap<String, String> indexMap = new HashMap<String, String>(64);
            HashMap dynValueMap = new HashMap(64);
            for (DynamicObject cellDyo : values) {
                String cellValue;
                String cellnumber;
                String dynRowNo = cellDyo.getString("dynrowno");
                if (StringUtils.isEmpty((CharSequence)dynRowNo) || !dynRowNo.contains("#")) {
                    cellnumber = cellDyo.getString("cellnumber");
                    cellValue = cellDyo.getString("value");
                    try {
                        map.put(cellnumber, new BigDecimal(cellValue).setScale(2, RoundingMode.HALF_UP));
                    }
                    catch (Exception e) {
                        logger.error("\u5e95\u7a3f\u6570\u636e\u5f02\u5e38\uff0csbbid:{},cellnumber:{},value:{}", new Object[]{id, cellnumber, cellValue});
                    }
                    continue;
                }
                if (!"dqsds_gaaptz_cyxm#1".equalsIgnoreCase(dynRowNo)) continue;
                cellnumber = cellDyo.getString("cellnumber");
                cellValue = cellDyo.getString("value");
                String index = cellDyo.getString("index");
                if (!ObjectUtils.isNotEmpty((Object)cellnumber)) continue;
                if (cellnumber.endsWith("dqsds_bbxm")) {
                    indexMap.put(index, cellValue);
                    continue;
                }
                if (!dynValueMap.containsKey(index)) {
                    dynValueMap.put(index, new HashMap(2));
                }
                ((Map)dynValueMap.get(index)).put(cellnumber, cellValue);
            }
            if (ObjectUtils.isNotEmpty(indexMap)) {
                Set entries = indexMap.entrySet();
                for (Map.Entry et : entries) {
                    String etkey = (String)et.getKey();
                    String etValue = (String)et.getValue();
                    Map dynRowValuesMap = (Map)dynValueMap.get(etkey);
                    if (!ObjectUtils.isNotEmpty((Object)dynRowValuesMap)) continue;
                    Set cellValues = dynRowValuesMap.entrySet();
                    try {
                        for (Map.Entry cellValue : cellValues) {
                            map.put(etValue + "_" + (String)cellValue.getKey(), new BigDecimal((String)cellValue.getValue()).setScale(2, RoundingMode.HALF_UP));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5e95\u7a3f\u6570\u636e\u5f02\u5e38");
                    }
                }
            }
            result.put(orgId, map);
        }
        return result;
    }

    private DynamicObjectCollection queryDeclareMain(Collection<Long> orgIds, Long taxationSysId, Date endDate, String accountSetType, Boolean isTaxAdjOrBd) {
        String templateNum = isTaxAdjOrBd != false ? (JT_ZT.equalsIgnoreCase(accountSetType) ? "INCOME-TAX-ADJ-JT" : "INCOME-TAX-ADJ-BD") : (JT_ZT.equalsIgnoreCase(accountSetType) ? "PRO-DECLARE-THAN-JT" : "PRO-DECLARE-THAN-BD");
        QFilter qFilter = new QFilter("number", "=", (Object)templateNum);
        DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_template", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty(orgIds) || taxationSysId == null || endDate == null || accountSetType == null || template == null) {
            return new DynamicObjectCollection();
        }
        QFilter mainFilter = new QFilter("org", "in", orgIds).and("taxsystem", "=", (Object)taxationSysId).and("skssqz", "=", (Object)endDate).and("templateid", "=", template.get("id"));
        return QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,org.name,org.number,org.id as orgid,skssqz,templatetype,taxsystem,remarks", (QFilter[])new QFilter[]{mainFilter}, (String)"org.number asc");
    }

    private DynamicObjectCollection queryDeclareMain(Collection<Long> orgIds, Long taxationSysId, Date endDate, String accountSetType, List<String> bdType) {
        String templateNum = JT_ZT.equalsIgnoreCase(accountSetType) ? "PRO-DECLARE-THAN-JT" : "PRO-DECLARE-THAN-BD";
        QFilter qFilter = new QFilter("number", "=", (Object)templateNum);
        DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_template", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty(orgIds) || taxationSysId == null || endDate == null || accountSetType == null || template == null) {
            return new DynamicObjectCollection();
        }
        QFilter mainFilter = new QFilter("org", "in", orgIds).and("taxsystem", "=", (Object)taxationSysId).and("skssqz", "=", (Object)endDate).and("templateid", "=", template.get("id")).and("comparisontype", "in", bdType);
        return QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,org.name,org.number,org.id as orgid,skssqz,templatetype,taxsystem,comparisontype,remarks", (QFilter[])new QFilter[]{mainFilter}, (String)"org.number asc");
    }
}

