/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.mservice.declare;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.itp.mservice.api.declare.ItpDeclareReportService;
import kd.taxc.itp.mservice.declare.strategy.AbstractCreateDeclareReportStrategy;
import kd.taxc.itp.mservice.declare.strategy.CreateDeclareReportStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDeclareReportServiceImpl
implements ItpDeclareReportService {
    private static Log logger = LogFactory.getLog(ItpDeclareReportServiceImpl.class);

    @Override
    public String generate(String request) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
        try {
            AccrualRequest requestVo = (AccrualRequest)SerializationUtils.fromJsonString((String)request, AccrualRequest.class);
            String orgId = requestVo.getOrgId();
            Long taxationsys = requestVo.getTaxsystem();
            String category = requestVo.getCategory();
            Date skssqq = requestVo.getSkssqq();
            Date skssqz = requestVo.getSkssqz();
            resultMap.put("skssqq", skssqq);
            resultMap.put("skssqz", skssqz);
            logger.info("ItpDeclareReportServiceImpl generate start orgId={}", (Object)orgId);
            logger.info("ItpDeclareReportServiceImpl generate start startDate={}", (Object)skssqq);
            logger.info("ItpDeclareReportServiceImpl generate start endDate={}", (Object)skssqz);
            logger.info("ItpDeclareReportServiceImpl generate start taxationsys={}", (Object)taxationsys);
            logger.info("ItpDeclareReportServiceImpl generate start accountsettype={}", (Object)category);
            if (ObjectUtils.isEmpty((Object)category)) {
                return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItpDeclareReportServiceImpl_0", (String)"taxc-itp-mservice", (Object[])new Object[0]), resultMap));
            }
            AbstractCreateDeclareReportStrategy strategy = CreateDeclareReportStrategyFactory.getStrategy(category);
            if (ObjectUtils.isEmpty((Object)strategy)) {
                return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u5e95\u7a3f\u751f\u6210\u670d\u52a1\u3002", (String)"ItpDeclareReportServiceImpl_1", (String)"taxc-itp-mservice", (Object[])new Object[0]), resultMap));
            }
            DeclareRequestModel declareRequest = new DeclareRequestModel();
            return strategy.doGenerate(declareRequest, requestVo);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)e.getMessage(), resultMap));
        }
    }
}

