/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.mservice.declare.strategy;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.MultiDeclareReportDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.itp.mservice.declare.pojo.DataResultVo;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractCreateDeclareReportStrategy {
    private static Log logger = LogFactory.getLog(AbstractCreateDeclareReportStrategy.class);
    private static DeclareReportSaveService declareReportSaveService;
    private static DeclareReportTreeService declareReportTreeService;

    public String doGenerate(DeclareRequestModel declareRequest, AccrualRequest requestVo) {
        DataResultVo vo = this.checkRequestParam(requestVo);
        if (!vo.getSuccess().booleanValue()) {
            HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
            resultMap.put("skssqq", requestVo.getSkssqq());
            resultMap.put("skssqz", requestVo.getSkssqz());
            return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)vo.getMessage(), resultMap));
        }
        DataResultVo initData = this.initData(declareRequest, requestVo);
        try {
            if (!initData.getSuccess().booleanValue()) {
                return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)initData.getMessage(), (Object)initData.getData()));
            }
            this.createCustomMap(declareRequest);
            return this.saveDraftData(declareRequest, initData);
        }
        catch (KDBizException exception) {
            return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)exception.getMessage(), (Object)initData.getData()));
        }
    }

    protected abstract DataResultVo checkRequestParam(AccrualRequest var1);

    protected DataResultVo initData(DeclareRequestModel declareRequest, AccrualRequest requestVo) {
        logger.info("AbstractCreateDeclareReportStrategy initData start");
        String orgId = requestVo.getOrgId();
        String startDate = DateUtils.format((Date)requestVo.getSkssqq());
        String endDate = DateUtils.format((Date)requestVo.getSkssqz());
        declareRequest.setOrgId(Long.valueOf(orgId));
        declareRequest.setSkssqq(startDate);
        declareRequest.setSkssqz(endDate);
        declareRequest.setTaxationsys(requestVo.getTaxsystem());
        declareRequest.setRefresh(Boolean.valueOf(true));
        declareRequest.setCustomEvent("add");
        declareRequest.setOperation("edit");
        declareRequest.setTemplateType(this.getTemplateType(requestVo));
        declareRequest.setId(TaxDeclarePluginService.generateSBBId((String)this.getMainTable()));
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("org", orgId);
        result.put("skssqq", startDate);
        result.put("skssqz", endDate);
        logger.info("AbstractCreateDeclareReportStrategy initData finish");
        return DataResultVo.success("create data success", result);
    }

    protected void createCustomMap(DeclareRequestModel declareRequest) {
    }

    protected String saveDraftData(DeclareRequestModel declareRequest, DataResultVo initData) {
        logger.info("AbstractCreateDeclareReportStrategy doGenerate start MultiDeclareDataServiceHelper.create");
        TaxResult taxResult = MultiDeclareReportDataServiceHelper.create((String)SerializationUtils.toJsonString((Object)declareRequest));
        logger.info("AbstractCreateDeclareReportStrategy doGenerate start MultiDeclareDataServiceHelper.create finish");
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            Map treeData = new HashMap(12);
            declareReportTreeService = DeclareReportTreeFactory.createHandler((String)declareRequest.getTemplateType());
            if (declareReportTreeService != null) {
                treeData = declareReportTreeService.loadTree(declareRequest, "", "");
            }
            logger.info("declareReportTreeService.loadTree");
            declareReportSaveService = DeclareReportSaveFactory.createHandler((String)declareRequest.getTemplateType());
            if (declareReportSaveService != null && ObjectUtils.isNotEmpty(treeData)) {
                Map treeMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(treeData), Map.class);
                BaseResult saveResult = declareReportSaveService.saveTeeData(declareRequest, treeMap);
                logger.info("declareReportSaveService.saveTeeData");
            }
            return SerializationUtils.toJsonString((Object)EngineResponse.success((String)ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u4efb\u52a1\u751f\u6210\u6210\u529f\u3002", (String)"AbstractCreateDeclareReportStrategy_0", (String)"taxc-itp-mservice", (Object[])new Object[0]), (Object)initData.getData()));
        }
        return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)taxResult.getMessage(), (Object)initData.getData()));
    }

    protected abstract String getTemplateType(AccrualRequest var1);

    protected String getMainTable() {
        return MultiTableEnum.TSD001.getDeclareMainTable();
    }
}

