/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.mservice.declare.strategy;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.itp.business.fetchdata.ItpFetchDataBussiness;
import kd.taxc.itp.mservice.declare.filter.AbstractDataCheckFilter;
import kd.taxc.itp.mservice.declare.filter.DataCheckFilterFactory;
import kd.taxc.itp.mservice.declare.pojo.DataResultVo;
import kd.taxc.itp.mservice.declare.strategy.AbstractCreateDeclareReportStrategy;
import org.apache.commons.lang3.ObjectUtils;

public class ItpJtCreateDeclareReportStrategy
extends AbstractCreateDeclareReportStrategy {
    private static Log logger = LogFactory.getLog(ItpJtCreateDeclareReportStrategy.class);
    private static DeclareReportService declareReportService;

    @Override
    protected DataResultVo checkRequestParam(AccrualRequest requestVo) {
        String orgId = requestVo.getOrgId();
        Date startDate = requestVo.getSkssqq();
        Date endDate = requestVo.getSkssqz();
        Long taxationsys = requestVo.getTaxsystem();
        String category = requestVo.getCategory();
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate) || ObjectUtils.isEmpty((Object)taxationsys) || ObjectUtils.isEmpty((Object)category)) {
            return new DataResultVo(false, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItpJtCreateDeclareReportStrategy_0", (String)"taxc-itp-mservice", (Object[])new Object[0]));
        }
        AbstractDataCheckFilter checkFilter = DataCheckFilterFactory.createDataCheckFilter();
        DataResultVo resultVo = new DataResultVo();
        checkFilter.checkData(resultVo, requestVo);
        return resultVo;
    }

    @Override
    protected DataResultVo initData(DeclareRequestModel declareRequest, AccrualRequest requestVo) {
        super.initData(declareRequest, requestVo);
        String orgId = requestVo.getOrgId();
        String startDate = DateUtils.format((Date)requestVo.getSkssqq());
        String endDate = DateUtils.format((Date)requestVo.getSkssqz());
        String category = requestVo.getCategory();
        declareRequest.setTemplateType("sdsjt_jt".equalsIgnoreCase(category) ? "sdsjt_jt" : "sdsjt_bd");
        declareReportService = DeclareReportFactory.createHandler((String)declareRequest.getTemplateType());
        if (declareReportService == null) {
            return DataResultVo.fail("declareReportService init fail");
        }
        declareRequest.setModelId(declareReportService.getModleId());
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("org", requestVo.getOrgId());
        map.put("skssqq", DateUtils.format((Date)requestVo.getSkssqq()));
        map.put("skssqz", DateUtils.format((Date)requestVo.getSkssqz()));
        map.put("accountsettype", requestVo.getCategory());
        map.put("taxsystem", requestVo.getTaxsystem().toString());
        map.put("templatetype", declareRequest.getTemplateType());
        declareRequest.setUniKey(declareReportService.getUniKey(map));
        String billNumber = declareReportService.getBillNumber(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), String.valueOf(orgId), declareRequest.getBusinessMap());
        declareRequest.setBillNo(billNumber);
        HashMap<String, String> businessMap = new HashMap<String, String>(12);
        businessMap.put("billno", declareRequest.getBillNo());
        businessMap.put("taxsystem", declareRequest.getTaxationsys().toString());
        businessMap.put("accountsettype", "sdsjt_jt".equalsIgnoreCase(declareRequest.getTemplateType()) ? "jtzt" : "bdzt");
        businessMap.put("billstatus", "A");
        businessMap.put("createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        businessMap.put("taxtype", "3");
        businessMap.put("draftpurpose", "sjjt");
        if (ObjectUtils.isNotEmpty((Object)requestVo.getTaxareagroup())) {
            businessMap.put("taxareagroup", requestVo.getTaxareagroup().toString());
        } else {
            businessMap.put("taxareagroup", "1708040530098667520");
        }
        if (ObjectUtils.isNotEmpty((Object)declareRequest.getBusinessMap())) {
            declareRequest.getBusinessMap().putAll(businessMap);
        } else {
            declareRequest.setBusinessMap(businessMap);
        }
        if (ObjectUtils.isNotEmpty((Object)declareRequest.getExtendParams())) {
            declareRequest.getExtendParams().putAll(businessMap);
        } else {
            HashMap<String, String> map2 = new HashMap<String, String>(12);
            map2.putAll(businessMap);
            declareRequest.setExtendParams(map2);
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("org", orgId);
        result.put("skssqq", startDate);
        result.put("skssqz", endDate);
        logger.info("ItpJtCreateDeclareReportStrategy initData finish");
        return DataResultVo.success("create data success", result);
    }

    @Override
    protected void createCustomMap(DeclareRequestModel declareRequest) {
        Map fetchConfigParams = ItpFetchDataBussiness.getFetchConfigParams((DeclareRequestModel)declareRequest);
        if (ObjectUtils.isNotEmpty((Object)fetchConfigParams)) {
            Map businessMap = declareRequest.getBusinessMap();
            if (ObjectUtils.isNotEmpty((Object)businessMap)) {
                declareRequest.getBusinessMap().putAll(fetchConfigParams);
            } else {
                declareRequest.setBusinessMap(fetchConfigParams);
            }
        }
    }

    @Override
    protected String getTemplateType(AccrualRequest requestVo) {
        return MultiTableEnum.TSD001.getDeclareMainTable();
    }
}

