/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.mservice.provision;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.itp.common.model.result.BaseResult;
import kd.taxc.itp.mservice.api.provision.TaxprovisionService;
import org.apache.commons.lang3.ObjectUtils;

public class TaxprovisionServiceImpl
implements TaxprovisionService {
    @Override
    public String createTaxprovision(String paramsJson) {
        List listparams = (List)SerializationUtils.fromJsonString((String)paramsJson, List.class);
        if (listparams == null) {
            return SerializationUtils.toJsonString((Object)BaseResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxprovisionServiceImpl_0", (String)"taxc-itp-mservice", (Object[])new Object[0])));
        }
        List<Map<String, String>> message = this.doCreateTaxprovision(listparams);
        if (message != null) {
            return SerializationUtils.toJsonString((Object)BaseResult.ok(message));
        }
        return SerializationUtils.toJsonString((Object)BaseResult.fail((String)ResManager.loadKDString((String)"\u8ba1\u63d0\u5355\u751f\u6210\u5931\u8d25\u3002", (String)"TaxprovisionServiceImpl_1", (String)"taxc-itp-mservice", (Object[])new Object[0])));
    }

    public List<Map<String, String>> doCreateTaxprovision(List listparams) {
        DynamicObject[] saveObjects = new DynamicObject[listparams.size()];
        ArrayList<Map<String, String>> message = new ArrayList<Map<String, String>>(listparams.size());
        for (int i = 0; i < listparams.size(); ++i) {
            LinkedHashMap params = (LinkedHashMap)listparams.get(i);
            Object taxsystem = params.get("taxsystem");
            Object taxtype = params.get("taxtype");
            Object taxorg = params.get("taxorg");
            Object accountorg = params.get("accountorg");
            Object item = params.get("provistonitem");
            Object startdate = params.get("startdate");
            Object enddate = params.get("enddate");
            Object entrydate = params.get("entrydate");
            Object coins = params.get("coins");
            Object total = params.get("total");
            Object entitytype = params.get("entitytype");
            Object entitynumber = params.get("entitynumber");
            Object creator = params.get("creator");
            Object modifier = params.get("modifier");
            Object accountsettype = params.get("accountsettype");
            Object sourcedrafttype = params.get("sourcedrafttype");
            Date date = new Date();
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"itp_proviston_taxes");
            dynamicObject.set("taxorg", taxorg);
            dynamicObject.set("accountorg", accountorg);
            dynamicObject.set("taxsystem", taxsystem);
            dynamicObject.set("taxtype", taxtype);
            dynamicObject.set("provistonitem", item);
            dynamicObject.set("startdate", null != startdate ? DateUtils.stringToDate((String)((String)startdate), (String)"yyyy-MM-dd") : null);
            dynamicObject.set("enddate", null != enddate ? DateUtils.stringToDate((String)((String)enddate), (String)"yyyy-MM-dd") : null);
            dynamicObject.set("entrydate", null != entrydate ? DateUtils.stringToDate((String)((String)entrydate), (String)"yyyy-MM-dd") : null);
            dynamicObject.set("coins", coins);
            dynamicObject.set("total", total);
            dynamicObject.set("isvoucher", (Object)"0");
            dynamicObject.set("billstatus", (Object)"A");
            dynamicObject.set("entitytype", entitytype);
            dynamicObject.set("entitynumber", entitynumber);
            dynamicObject.set("creator", creator);
            dynamicObject.set("createtime", (Object)date);
            dynamicObject.set("modifier", modifier);
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("accountsettype", accountsettype);
            if (ObjectUtils.isNotEmpty(sourcedrafttype)) {
                dynamicObject.set("sourcedrafttype", sourcedrafttype);
            } else if (ObjectUtils.isNotEmpty(entitytype)) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache(entitytype, (String)"bos_entityobject", (String)"name");
                dynamicObject.set("sourcedrafttype", (Object)object.getString("name"));
            }
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            String number = codeRuleService.getNumber("itp_proviston_taxes", dynamicObject, null);
            dynamicObject.set("billno", (Object)number);
            saveObjects[i] = dynamicObject;
        }
        Object[] successResult = SaveServiceHelper.save((DynamicObject[])saveObjects);
        if (ObjectUtils.isNotEmpty((Object)successResult)) {
            for (Object result : successResult) {
                HashMap<String, String> map = new HashMap<String, String>(1);
                DynamicObject dynamicObject = (DynamicObject)result;
                map.put(dynamicObject.getString("entitynumber"), dynamicObject.getString("billno"));
                message.add(map);
            }
        }
        return message;
    }
}

