/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.itp.mservice.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxProvisionUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxProvisionUpgradeServiceImpl.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(this.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public String doUpgrade() {
        final ArrayList params = new ArrayList(64);
        final HashMap<String, String> map = new HashMap<String, String>(64);
        String selectDisSql = " select distinct fentitytype as draftentity from t_itp_proviston_taxes where fsourcedrafttype =' ' or fsourcedrafttype is null or fsourcedrafttype = ''";
        String updateSql = " update t_itp_proviston_taxes set fsourcedrafttype = ? where fid  = ? ";
        try {
            ArrayList<Object> draftEntityList = new ArrayList<Object>();
            try (DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"taxc"), (String)selectDisSql);){
                for (Row row : dataSet) {
                    draftEntityList.add(row.get("draftentity"));
                }
            }
            if (ObjectUtils.isNotEmpty(draftEntityList)) {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append(" select fid,fname from t_meta_mainentityinfo_L where flocaleid = 'zh_CN' ", new Object[0]);
                sqlBuilder.appendIn(" and fid", draftEntityList);
                DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys.meta"), (SqlBuilder)sqlBuilder);
                Object object = null;
                try {
                    for (Row row : dataSet) {
                        map.put(row.getString("fid"), row.getString("fname"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                logger.info("\u5347\u7ea7\u7a0e\u91d1\u8ba1\u63d0\u5355 \u5f00\u59cb\u6267\u884c");
                long start = System.currentTimeMillis();
                DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)"select fid,fentitytype from t_itp_proviston_taxes where fsourcedrafttype =' ' or fsourcedrafttype is null or fsourcedrafttype = '' ", (ResultSetHandler)new ResultSetHandler<DynamicObject>(){

                    public DynamicObject handle(ResultSet resultSet) throws Exception {
                        while (resultSet.next()) {
                            String entityId = resultSet.getString("fentitytype");
                            Long id = resultSet.getLong("fid");
                            if (!StringUtil.isNotEmpty((CharSequence)((CharSequence)map.get(entityId)))) continue;
                            params.add(new Object[]{map.get(entityId), id});
                        }
                        return null;
                    }
                });
                if (ObjectUtils.isNotEmpty(params)) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, params);
                }
                logger.info("\u5347\u7ea7\u7a0e\u91d1\u8ba1\u63d0\u5355 \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            }
            return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"TaxProvisionUpgradeServiceImpl_0", (String)"taxc-itp-mservice", (Object[])new Object[0]), params.size());
        }
        catch (Throwable t) {
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u8ba1\u63d0\u5355 \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            throw t;
        }
    }
}

