/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.accrual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitor;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tam.business.accrual.TaskMessageService;
import kd.taxc.tam.business.mq.helper.BatchGenerateTaskOrgQueryHelper;
import org.apache.commons.lang.StringUtils;

public class BatchAccrualTask
extends AbstractTaskMonitor {
    private static final Log logger = LogFactory.getLog(BatchAccrualTask.class);
    private TaskMessageService taskMessageService = new TaskMessageService();

    public Map<String, Object> buildTaskParams(RequestContext requestContext, Map<String, Object> map) {
        String categoryParam = (String)map.get("category");
        String orgs = (String)map.get("orgList");
        Date executeTime = new Date();
        if (EmptyCheckUtils.isNotEmpty((Object)map.get("executeTime"))) {
            executeTime = DateUtils.stringToDate((String)((String)map.get("executeTime")));
        }
        ArrayList<AccrualListEnum> accrualListEnums = new ArrayList<AccrualListEnum>();
        Object categoryOrgList = map.get("categoryOrgList");
        List<Map<String, Object>> taxableList = categoryOrgList != null ? this.getTableListByCategoryOrgList((List)categoryOrgList, executeTime, accrualListEnums) : this.getTableList(categoryParam, map, executeTime, accrualListEnums);
        Map<Object, List<Map>> taxableMap = taxableList.stream().filter(a -> a.get("org") != null && Objects.equals(a.get("billstatus"), "nodata")).collect(Collectors.groupingBy(a -> a.getOrDefault("category", "")));
        long userid = StringUtils.isNotEmpty((String)((String)map.get("userid"))) ? Long.parseLong((String)map.get("userid")) : 0L;
        ArrayList<Map<String, Object>> subTasks = new ArrayList<Map<String, Object>>();
        for (AccrualListEnum accrualCateGory : accrualListEnums) {
            this.taskMessageService.build(accrualCateGory, taxableMap.get(accrualCateGory.getCategory()), executeTime, subTasks, userid);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("operater", userid);
        params.put("taskClassName", "kd.taxc.tam.business.accrual.BatchAccrualTask");
        params.put("appid", "bdtaxr");
        params.put("taskdefineId", "3+CVFCPJ8HAJ");
        params.put("taskName", "BatchAccrualTask");
        String executeType = (String)map.get("executeType");
        params.put("executeType", StringUtils.isNotEmpty((String)executeType) ? executeType : "1");
        params.put("businessParams", null);
        params.put("taskId", this.taskId);
        params.put("subTasks", subTasks);
        logger.info("\u4e3b\u4efb\u52a1taskId:{};\u6279\u91cf\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f\u53c2\u6570\uff1a{}", (Object)this.taskId, params);
        return params;
    }

    private List<Map<String, Object>> getTableList(String categoryParam, Map<String, Object> map, Date executeTime, List<AccrualListEnum> accrualListEnums) {
        if (StringUtils.isNotBlank((String)categoryParam)) {
            String[] categoryArray;
            for (String category : categoryArray = categoryParam.split(",")) {
                AccrualListEnum accrualCateGory = AccrualListEnum.valueOfCateGory((String)category);
                if (accrualCateGory == null || this.isExist(accrualCateGory, accrualListEnums)) continue;
                accrualListEnums.add(accrualCateGory);
            }
        } else {
            accrualListEnums.addAll(Arrays.asList(AccrualListEnum.values()));
        }
        List categoryList = accrualListEnums.stream().map(AccrualListEnum::getCategory).collect(Collectors.toList());
        List<String> orgList = BatchGenerateTaskOrgQueryHelper.getOrgList(map);
        List orgIds = orgList.stream().map(Long::parseLong).collect(Collectors.toList());
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"AccrualListQueryService", (String)"query", (Object[])new Object[]{orgIds, categoryList, executeTime});
    }

    private List<Map<String, Object>> getTableListByCategoryOrgList(List<Map<String, Object>> categoryOrgList, Date executeTime, List<AccrualListEnum> accrualListEnums) {
        for (Map<String, Object> map : categoryOrgList) {
            AccrualListEnum accrualCateGory = AccrualListEnum.valueOfCateGory((String)String.valueOf(map.get("category")));
            if (accrualCateGory == null || this.isExist(accrualCateGory, accrualListEnums)) continue;
            accrualListEnums.add(accrualCateGory);
        }
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"AccrualListQueryService", (String)"queryTaxableList", (Object[])new Object[]{categoryOrgList, executeTime});
    }

    public String buildNotification() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u8fdb\u5ea6\uff1a", (String)"BatchAccrualTask_0", (String)"taxc-tam", (Object[])new Object[0]);
    }

    private boolean isExist(AccrualListEnum accrualCateGory, List<AccrualListEnum> accrualListEnums) {
        for (AccrualListEnum accrualListEnum : accrualListEnums) {
            if (!accrualListEnum.getCategory().equals(accrualCateGory.getCategory())) continue;
            return true;
        }
        return false;
    }
}

