/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import org.apache.commons.collections4.CollectionUtils;

public class DeclareMainChangeEventService
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(DeclareMainChangeEventService.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("DeclareMainChangeEventService,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        try {
            List paramList = (List)SerializationUtils.fromJsonString((String)evt.getSource(), List.class);
            if (CollectionUtils.isEmpty((Collection)paramList)) {
                logger.error("DeclareMainChangeEventService paramList isEmpty.");
                return evt.getEventId();
            }
            if (paramList.size() > 0) {
                Map params = (Map)paramList.get(0);
                if (ObjectUtils.isEmpty((Object)params)) {
                    logger.error("DeclareMainChangeEventService params isEmpty.");
                    return evt.getEventId();
                }
                List declares = (List)params.get("declares");
                if (CollectionUtils.isEmpty((Collection)declares)) {
                    logger.error("DeclareMainChangeEventService declares isEmpty.");
                    return evt.getEventId();
                }
                DeclareOperationEnum operate = DeclareOperationEnum.getEnumByKey((String)((String)params.get("operate")));
                ModelVersionEnum version = ModelVersionEnum.getEnumByKey((String)((String)params.get("version")));
                Object sourceAppid = params.get("source");
                this.doBusiness(declares, operate, version, sourceAppid);
            }
        }
        catch (Exception e) {
            logger.error("DeclareMainChangeEventService error." + e.getMessage(), (Throwable)e);
        }
        return evt.getEventId();
    }

    protected void doBusiness(List<Map<String, Object>> declares, DeclareOperationEnum operate, ModelVersionEnum version, Object sourceAppid) {
        if ("tsate".equals(sourceAppid) && this.getSqzlOperateList().contains(operate)) {
            this.doWriteBackYbqd(declares, operate, version);
        }
    }

    private List<DeclareOperationEnum> getSqzlOperateList() {
        return Arrays.asList(DeclareOperationEnum.DIRECTDECLARE, DeclareOperationEnum.DIRECTPAY, DeclareOperationEnum.CANCELAPPLY, DeclareOperationEnum.CANCELPAY, DeclareOperationEnum.INVALID, DeclareOperationEnum.APPLY, DeclareOperationEnum.PAY);
    }

    private void doWriteBackYbqd(List<Map<String, Object>> declares, DeclareOperationEnum operate, ModelVersionEnum version) {
        for (Map<String, Object> declare : declares) {
            DeclareMQMessage message = this.newDeclareMQMessage(declare, operate, version);
            DeclareMQSender.send((String)"taxc.common.declare.taxableList", (String)JsonUtil.toJson((Object)message));
        }
    }

    private DeclareMQMessage newDeclareMQMessage(Map<String, Object> declare, DeclareOperationEnum operate, ModelVersionEnum version) {
        DeclareMQMessage message = new DeclareMQMessage();
        String entityType = ModelVersionEnum.MODEL3 == version ? (String)declare.get("templatetype") : (String)declare.get("type");
        message.setTax(TemplateTypeConstant.getTypeByValue((String)entityType));
        message.setTopic(DeclareMQType.DECLARE.name());
        message.setEvent(DeclareMQEvent.match((String)operate.getOperation()));
        message.setSbbid(String.valueOf(declare.get("id")));
        if (declare.get("org") != null && declare.get("org") instanceof Long) {
            message.setOrg(Long.valueOf(String.valueOf(declare.get("org"))));
        }
        message.setSkssqq(String.valueOf(declare.get("skssqq")));
        message.setSkssqz(String.valueOf(declare.get("skssqz")));
        message.setDeclareType(entityType);
        message.setBillno(String.valueOf(declare.get("billno")));
        message.setDeclarestatus(String.valueOf(declare.get("declarestatus")));
        message.setPaystatus(String.valueOf(declare.get("paystatus")));
        if (declare.get("taxauthority") != null && declare.get("taxauthority") instanceof Long) {
            message.setTaxauthority(Long.valueOf(String.valueOf(declare.get("taxauthority"))));
        }
        return message;
    }
}

