/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class TaskMessageBuilder {
    public static Map<String, Object> buildSonDeclareTaskMessageByList(DeclareCateGory declareCateGory, List<Map<String, Object>> taxableList, Date executeTime, Boolean combineDeclare, List<Map<String, Object>> subTasks, long currUserId) {
        HashMap<String, Object> param;
        block4: {
            param = new HashMap<String, Object>();
            if (taxableList == null || taxableList.size() <= 0) break block4;
            if (DeclareCateGory.CCXWS == declareCateGory || DeclareCateGory.QTSFTYSBB == declareCateGory) {
                Function<Map, String> groupCondition = a -> String.valueOf(a.get("org")) + String.valueOf(a.get("taxauthority"));
                Map<String, List<Map>> collect = taxableList.stream().collect(Collectors.groupingBy(groupCondition));
                for (List<Map> mapList : collect.values()) {
                    Map taxable = mapList.get(0);
                    HashMap<String, Object> businessParams = new HashMap<String, Object>();
                    businessParams.put("taxauthority", taxable.get("taxauthority") == null ? "0" : String.valueOf(taxable.get("taxauthority")));
                    Map<String, Object> subTask = TaskMessageBuilder.fillDeclareParams(declareCateGory, executeTime, combineDeclare, currUserId, taxable, businessParams);
                    subTasks.add(subTask);
                }
            } else {
                for (Map<String, Object> taxable : taxableList) {
                    HashMap<String, Object> businessParams = new HashMap<String, Object>();
                    businessParams.put("startdate", taxable.get("skssqq") != null ? DateUtils.format((Date)((Date)taxable.get("skssqq"))) : null);
                    businessParams.put("enddate", taxable.get("skssqz") != null ? DateUtils.format((Date)((Date)taxable.get("skssqz"))) : null);
                    businessParams.put("taxcatetory", taxable.get("taxcatetory"));
                    businessParams.put("taxauthority", taxable.get("taxauthority") == null ? "0" : String.valueOf(taxable.get("taxauthority")));
                    Map<String, Object> subTask = TaskMessageBuilder.fillDeclareParams(declareCateGory, executeTime, combineDeclare, currUserId, taxable, businessParams);
                    subTasks.add(subTask);
                }
            }
        }
        return param;
    }

    private static Map<String, Object> fillDeclareParams(DeclareCateGory declareCateGory, Date executeTime, Boolean combineDeclare, long currUserId, Map<String, Object> taxable, Map<String, Object> businessParams) {
        HashMap<String, Object> subTask = new HashMap<String, Object>();
        subTask.put("operater", currUserId);
        subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleDeclareTask");
        subTask.put("appid", "bdtaxr");
        subTask.put("taskdefineId", "3DGAL77IM9A/");
        Object org = taxable.get("org");
        subTask.put("taxorg", org);
        subTask.put("taskName", "SingleDeclareTask");
        businessParams.put("category", declareCateGory.getCategory());
        businessParams.put("appid", declareCateGory.getAppId());
        businessParams.put("datatype", "schedule");
        businessParams.put("orgid", org.toString());
        businessParams.put("executetime", DateUtils.format((Date)executeTime));
        businessParams.put("combinedeclare", combineDeclare.toString());
        subTask.put("businessParams", businessParams);
        return subTask;
    }

    public static Map<String, Object> buildSonDraftTaskMessageByList(DraftCateGory draftCateGory, List<Map<String, Object>> taxableList, Date executeTime, List<Map<String, Object>> subTasks, Long userId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (taxableList != null && taxableList.size() > 0) {
            for (Map<String, Object> taxable : taxableList) {
                HashMap<String, Object> subTask = new HashMap<String, Object>();
                subTask.put("operater", userId);
                subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleDaftTask");
                subTask.put("appid", "bdtaxr");
                subTask.put("taskdefineId", "36XFN9HT+/O=");
                Object org = taxable.get("org");
                subTask.put("taxorg", org);
                subTask.put("taskName", "SingleDaftTask");
                HashMap<String, Object> businessParams = new HashMap<String, Object>();
                businessParams.put("category", draftCateGory.getCategory());
                businessParams.put("appid", draftCateGory.getAppId());
                businessParams.put("datatype", "schedule");
                businessParams.put("orgid", org.toString());
                businessParams.put("executetime", DateUtils.format((Date)executeTime));
                businessParams.put("taxationsys", taxable.get("taxationsys"));
                businessParams.put("taxareagroup", taxable.get("taxareagroup"));
                businessParams.put("taxcatetory", taxable.get("taxcatetory"));
                businessParams.put("startdate", taxable.get("skssqq") != null ? DateUtils.format((Date)((Date)taxable.get("skssqq"))) : null);
                businessParams.put("enddate", taxable.get("skssqz") != null ? DateUtils.format((Date)((Date)taxable.get("skssqz"))) : null);
                subTask.put("businessParams", businessParams);
                subTasks.add(subTask);
            }
        }
        return param;
    }

    public static void buildSonDeclareTaskMessage(DynamicObjectCollection draftList, List<Map<String, Object>> subTasks, long currUserId) {
        for (DynamicObject object : draftList) {
            HashMap<String, Object> subTask = new HashMap<String, Object>();
            subTask.put("operater", currUserId);
            subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleDeclareTask");
            subTask.put("skssqq", object.getDate("startdate"));
            subTask.put("skssqz", object.getDate("enddate"));
            subTask.put("appid", "bdtaxr");
            subTask.put("taskdefineId", "3DGAL77IM9A/");
            subTask.put("taxorg", object.getLong("org"));
            subTask.put("taskName", "SingleDeclareTask");
            HashMap<String, String> businessParams = new HashMap<String, String>();
            businessParams.put("category", object.getString("drafttype"));
            businessParams.put("appid", DraftCateGory.valueOfCode((String)object.getString("drafttype")).getAppId());
            businessParams.put("datatype", "schedule");
            businessParams.put("orgid", object.getString("org"));
            businessParams.put("executetime", DateUtils.format((Date)new Date()));
            businessParams.put("startdate", DateUtils.format((Date)object.getDate("startdate")));
            businessParams.put("enddate", DateUtils.format((Date)object.getDate("enddate")));
            businessParams.put("combinedeclare", "false");
            subTask.put("businessParams", businessParams);
            subTasks.add(subTask);
        }
    }

    public static void buildSonYbqdTbTaskMessage(List<String> orgList, List<Map<String, Object>> subTasks, long currUserId, Date executeTime) {
        List partition = Lists.partition(orgList, (int)10);
        for (List orgs : partition) {
            HashMap<String, Object> subTask = new HashMap<String, Object>();
            subTask.put("operater", currUserId);
            subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleYbqdSjtbTask");
            subTask.put("taskName", "SingleYbqdSjtbTask");
            subTask.put("queryDate", DateUtils.format((Date)executeTime));
            subTask.put("appid", "bdtaxr");
            subTask.put("taskdefineId", "3G4YPSHGGCMZ");
            subTask.put("orgs", orgs);
            HashMap<String, Object> businessParams = new HashMap<String, Object>();
            businessParams.put("queryDate", DateUtils.format((Date)executeTime));
            businessParams.put("orgs", orgs);
            subTask.put("businessParams", businessParams);
            subTasks.add(subTask);
        }
    }

    public static void buildSonYjtqdTbTaskMessage(List<String> orgList, List<Map<String, Object>> subTasks, long currUserId, Date executeTime) {
        List partition = Lists.partition(orgList, (int)10);
        for (List orgs : partition) {
            HashMap<String, Object> subTask = new HashMap<String, Object>();
            subTask.put("operater", currUserId);
            subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleYjtqdSjtbTask");
            subTask.put("taskName", "SingleYjtqdSjtbTask");
            subTask.put("queryDate", DateUtils.format((Date)executeTime));
            subTask.put("appid", "bdtaxr");
            subTask.put("taskdefineId", "3Q3EBH=M+QXT");
            subTask.put("orgs", orgs);
            HashMap<String, Object> businessParams = new HashMap<String, Object>();
            businessParams.put("queryDate", DateUtils.format((Date)executeTime));
            businessParams.put("orgs", orgs);
            subTask.put("businessParams", businessParams);
            subTasks.add(subTask);
        }
    }

    public static void buildSonSjjsTaskMessage(List<TaxableListDto> list, List<Map<String, Object>> subTasks, long currUserId, Date executeTime) {
        Map<String, List<TaxableListDto>> entityFieldMap = list.stream().collect(Collectors.groupingBy(TaxableListDto::getSbbcategory));
        for (Map.Entry<String, List<TaxableListDto>> map : entityFieldMap.entrySet()) {
            if (map.getKey().equals(DeclareCateGory.CCXWS.getCategory()) || map.getKey().equals(DeclareCateGory.QTSFTYSBB.getCategory()) || map.getKey().equals(DeclareCateGory.QTSF_FSSTYSBB.getCategory())) {
                Map<String, List<TaxableListDto>> collect = map.getValue().stream().collect(Collectors.groupingBy(a -> String.valueOf(a.getOrg()) + String.valueOf(a.getTaxauthority())));
                for (List<TaxableListDto> listDtos : collect.values()) {
                    List taxcatetoryList = listDtos.stream().map(a -> a.getTaxcatetory()).collect(Collectors.toList());
                    String taxcatetoryListString = StringUtils.join(taxcatetoryList, (String)",");
                    TaxableListDto taxable = listDtos.get(0);
                    HashMap<String, Object> businessParams = new HashMap<String, Object>();
                    businessParams.put("taxauthority", taxable.getTaxauthority());
                    businessParams.put("taxcatetory", taxcatetoryListString);
                    Map<String, Object> subTask = TaskMessageBuilder.fillSjjsParams(taxable, businessParams, currUserId, executeTime);
                    subTasks.add(subTask);
                }
                continue;
            }
            for (TaxableListDto dto : map.getValue()) {
                HashMap<String, Object> businessParams = new HashMap<String, Object>();
                businessParams.put("taxcatetory", String.valueOf(dto.getTaxcatetory()));
                businessParams.put("startdate", DateUtils.format((Date)dto.getSkssqq()));
                businessParams.put("enddate", DateUtils.format((Date)dto.getSkssqz()));
                businessParams.put("taxauthority", dto.getTaxauthority());
                Map<String, Object> subTask = TaskMessageBuilder.fillSjjsParams(dto, businessParams, currUserId, executeTime);
                subTasks.add(subTask);
            }
        }
    }

    private static Map<String, Object> fillSjjsParams(TaxableListDto dto, Map<String, Object> businessParams, long currUserId, Date executeTime) {
        HashMap<String, Object> subTask = new HashMap<String, Object>();
        subTask.put("operater", currUserId);
        subTask.put("taskClassName", "kd.taxc.bdtaxr.business.task.SingleSjjsTask");
        subTask.put("skssqq", dto.getSkssqq());
        subTask.put("skssqz", dto.getSkssqz());
        subTask.put("appid", "bdtaxr");
        subTask.put("taskdefineId", "3F8W+SD+W9I+");
        subTask.put("taxorg", dto.getOrg());
        subTask.put("taskName", "SingleSjjsTask");
        businessParams.put("dgcategory", dto.getDgcategory());
        businessParams.put("sbbcategory", dto.getSbbcategory());
        businessParams.put("draftstatus", dto.getDraftstatus());
        businessParams.put("appid", DeclareCateGory.valueOfCode((String)dto.getSbbcategory()).getAppId());
        businessParams.put("datatype", "schedule");
        businessParams.put("orgid", String.valueOf(dto.getOrg()));
        businessParams.put("executetime", DateUtils.format((Date)executeTime));
        businessParams.put("combinedeclare", "false");
        subTask.put("businessParams", businessParams);
        return subTask;
    }
}

