/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq.datasynchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitor;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tam.business.mq.TaskMessageBuilder;
import org.apache.commons.lang.StringUtils;

public class BatchYjtqdSjtbTask
extends AbstractTaskMonitor {
    private static final Log logger = LogFactory.getLog(BatchYjtqdSjtbTask.class);

    private List<String> queryOrgList() {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer();
        return ((List)result.getData()).stream().map(o -> o.getString("taxorg.id")).collect(Collectors.toList());
    }

    public Map<String, Object> buildTaskParams(RequestContext requestContext, Map<String, Object> map) {
        String orgs;
        long userid = StringUtils.isNotEmpty((String)((String)map.get("userid"))) ? Long.parseLong((String)map.get("userid")) : 0L;
        Date executeTime = new Date();
        if (EmptyCheckUtils.isNotEmpty((Object)map.get("executeTime"))) {
            executeTime = DateUtils.stringToDate((String)((String)map.get("executeTime")));
        }
        List<String> orgList = StringUtils.isBlank((String)(orgs = (String)map.get("orgList"))) ? this.queryOrgList() : Arrays.stream(orgs.split(",")).collect(Collectors.toList());
        ArrayList<Map<String, Object>> subTasks = new ArrayList<Map<String, Object>>();
        if (orgList.size() > 0) {
            TaskMessageBuilder.buildSonYjtqdTbTaskMessage(orgList, subTasks, userid, executeTime);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("operater", userid);
        params.put("taskClassName", "kd.taxc.tam.business.mq.datasynchronize.BatchYjtqdSjtbTask");
        params.put("appid", "tam");
        params.put("taskdefineId", "3Q3E9A86BZ3M");
        params.put("taskName", "BatchYjtqdSjtbTask");
        String executeType = (String)map.get("executeType");
        params.put("executeType", StringUtils.isNotEmpty((String)executeType) ? executeType : "1");
        params.put("businessParams", null);
        params.put("taskId", this.taskId);
        params.put("subTasks", subTasks);
        logger.info("\u4e3b\u4efb\u52a1taskId:{};\u6279\u91cf\u66f4\u65b0\u5e94\u8ba1\u63d0\u6e05\u5355\u53c2\u6570\uff1a{};\u5b50\u4efb\u52a1\u6570\u91cf\uff1a{}", new Object[]{this.taskId, params, subTasks.size()});
        return params;
    }

    public String buildNotification() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u8fdb\u5ea6\uff1a", (String)"BatchYbqdSjtbTask_0", (String)"taxc-tam", (Object[])new Object[0]);
    }
}

