/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq.datasynchronize;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tam.business.synchronize.impl.DataSynchronizeServiceImpl;

public class DataSynchronizeConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(DataSynchronizeConsumer.class);
    private DataSynchronizeServiceImpl dataSynchronizeService = new DataSynchronizeServiceImpl();

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String str = (String)message;
        logger.info("DataSynchronize message:" + str);
        SynchronizeParam synchronizeParam = (SynchronizeParam)SerializationUtils.fromJsonString((String)str, SynchronizeParam.class);
        try {
            EngineResponse response = this.dataSynchronizeService.dataSynchronize(synchronizeParam);
            if (response.getSuccess().booleanValue()) {
                acker.ack(messageId);
            } else {
                acker.discard(messageId);
            }
        }
        catch (Throwable throwable) {
            logger.error("DataSynchronize execute error", throwable);
            acker.discard(messageId);
        }
    }
}

