/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitor;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tam.business.mq.TaskMessageBuilder;
import kd.taxc.tam.business.mq.helper.BatchGenerateTaskOrgQueryHelper;
import org.apache.commons.lang.StringUtils;

public class BatchDeclareTask
extends AbstractTaskMonitor {
    private static final Log logger = LogFactory.getLog(BatchDeclareTask.class);

    public Map<String, Object> buildTaskParams(RequestContext requestContext, Map<String, Object> map) {
        long userid = StringUtils.isNotEmpty((String)((String)map.get("userid"))) ? Long.parseLong((String)map.get("userid")) : 0L;
        ArrayList<Map<String, Object>> subTasks = new ArrayList<Map<String, Object>>();
        String ids = (String)map.get("tamDraftBillIds");
        if (StringUtils.isNotEmpty((String)ids)) {
            List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
            DynamicObjectCollection draftList = QueryServiceHelper.query((String)"tam_draft_bill", (String)"org,startdate,enddate,drafttype", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            TaskMessageBuilder.buildSonDeclareTaskMessage(draftList, subTasks, userid);
        } else {
            String categoryParam = (String)map.get("category");
            List<Object> categorys = new ArrayList();
            if (StringUtils.isNotBlank((String)categoryParam)) {
                String[] categoryArray;
                for (String category : categoryArray = categoryParam.split(",")) {
                    DeclareCateGory declareCateGory = DeclareCateGory.valueOfCode((String)category);
                    if (declareCateGory == null) continue;
                    categorys.add(declareCateGory);
                }
            } else {
                categorys = Arrays.asList(DeclareCateGory.values());
            }
            List<String> orgList = BatchGenerateTaskOrgQueryHelper.getOrgList(map);
            Date executeTime = new Date();
            if (EmptyCheckUtils.isNotEmpty((Object)map.get("executeTime"))) {
                executeTime = DateUtils.stringToDate((String)((String)map.get("executeTime")));
            }
            Boolean combineDeclare = Boolean.FALSE;
            if (EmptyCheckUtils.isNotEmpty((Object)map.get("combineDeclare"))) {
                combineDeclare = Boolean.parseBoolean((String)map.get("combineDeclare"));
            }
            List categorySet = categorys.stream().map(a -> a.getCategory()).collect(Collectors.toList());
            List orgCollect = orgList.stream().map(Long::parseLong).collect(Collectors.toList());
            List taxableList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxableListService", (String)"queryTimely", (Object[])new Object[]{orgCollect, categorySet, null, executeTime, 2});
            Map<Object, List<Map>> taxableMap = taxableList.stream().filter(a -> a.get("org") != null && Objects.equals(a.get("declarestatus"), TaxableListDto.DECLARESTATUS_WBZ)).collect(Collectors.groupingBy(a -> a.getOrDefault("sbbcategory", "")));
            for (DeclareCateGory declareCateGory : categorys) {
                TaskMessageBuilder.buildSonDeclareTaskMessageByList(declareCateGory, taxableMap.get(declareCateGory.getCategory()), executeTime, combineDeclare, subTasks, userid);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("operater", userid);
        params.put("taskClassName", "kd.taxc.tam.business.mq.draft.BatchDraftTask");
        params.put("appid", "bdtaxr");
        params.put("taskdefineId", "2NQ73WR=MKQU");
        params.put("taskName", "BatchDeclareTask");
        String executeType = (String)map.get("executeType");
        params.put("executeType", StringUtils.isNotEmpty((String)executeType) ? executeType : "1");
        params.put("businessParams", null);
        params.put("taskId", this.taskId);
        params.put("subTasks", subTasks);
        logger.info("\u4e3b\u4efb\u52a1taskId:{};\u6279\u91cf\u751f\u6210\u7533\u62a5\u8868\u53c2\u6570\uff1a{};\u5b50\u4efb\u52a1\u6570\u91cf\uff1a{}", new Object[]{this.taskId, params, subTasks.size()});
        return params;
    }

    public String buildNotification() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u8fdb\u5ea6\uff1a", (String)"BatchDeclareTask_0", (String)"taxc-tam", (Object[])new Object[0]);
    }
}

