/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitor;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.json.JsonUtil;
import kd.taxc.tam.business.mq.TaskMessageBuilder;
import org.apache.commons.lang.StringUtils;

public class BatchSjjsTask
extends AbstractTaskMonitor {
    private static final Log logger = LogFactory.getLog(BatchSjjsTask.class);

    private List<String> queryOrgList() {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer();
        return ((List)result.getData()).stream().map(o -> o.getString("taxorg.id")).collect(Collectors.toList());
    }

    public Map<String, Object> buildTaskParams(RequestContext requestContext, Map<String, Object> map) {
        long userid = StringUtils.isNotEmpty((String)((String)map.get("userid"))) ? Long.parseLong((String)map.get("userid")) : 0L;
        ArrayList<Map<String, Object>> subTasks = new ArrayList<Map<String, Object>>();
        List list = JsonUtil.fromJsonList((String)map.get("taxableList").toString(), TaxableListDto.class);
        Date executeTime = new Date();
        if (EmptyCheckUtils.isNotEmpty((Object)map.get("executeTime"))) {
            executeTime = DateUtils.stringToDate((String)((String)map.get("executeTime")));
        }
        if (list.size() > 0) {
            TaskMessageBuilder.buildSonSjjsTaskMessage(list, subTasks, userid, executeTime);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("operater", userid);
        params.put("taskClassName", "kd.taxc.tam.business.mq.declare.BatchSjjsTask");
        params.put("appid", "bdtaxr");
        params.put("taskdefineId", "3F9Q9BWFTBHY");
        params.put("taskName", "BatchSjjsTask");
        String executeType = (String)map.get("executeType");
        params.put("executeType", StringUtils.isNotEmpty((String)executeType) ? executeType : "1");
        params.put("businessParams", null);
        params.put("taskId", this.taskId);
        params.put("subTasks", subTasks);
        logger.info("\u4e3b\u4efb\u52a1taskId:{};\u6279\u91cf\u7a0e\u91d1\u8ba1\u7b97\u53c2\u6570\uff1a{};\u5b50\u4efb\u52a1\u6570\u91cf\uff1a{}", new Object[]{this.taskId, params, subTasks.size()});
        return params;
    }

    public String buildNotification() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u8fdb\u5ea6\uff1a", (String)"BatchSjjsTask_0", (String)"taxc-tam", (Object[])new Object[0]);
    }
}

