/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.mq.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitor;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tam.business.mq.TaskMessageBuilder;
import kd.taxc.tam.business.mq.helper.BatchGenerateTaskOrgQueryHelper;
import org.apache.commons.lang.StringUtils;

public class BatchDraftTask
extends AbstractTaskMonitor {
    private static final Log logger = LogFactory.getLog(BatchDraftTask.class);

    public Map<String, Object> buildTaskParams(RequestContext requestContext, Map<String, Object> map) {
        String categoryParam = (String)map.get("category");
        List<Object> categorys = new ArrayList();
        if (StringUtils.isNotBlank((String)categoryParam)) {
            String[] categoryArray;
            for (String category : categoryArray = categoryParam.split(",")) {
                DraftCateGory draftCateGory = DraftCateGory.valueOfCode((String)category);
                if (draftCateGory == null) continue;
                categorys.add(draftCateGory);
            }
        } else {
            categorys = Arrays.asList(DraftCateGory.values());
        }
        List<String> orgList = BatchGenerateTaskOrgQueryHelper.getOrgList(map);
        Date executeTime = new Date();
        if (EmptyCheckUtils.isNotEmpty((Object)map.get("executeTime"))) {
            executeTime = DateUtils.stringToDate((String)((String)map.get("executeTime")));
        }
        long userid = StringUtils.isNotEmpty((String)((String)map.get("userid"))) ? Long.parseLong((String)map.get("userid")) : requestContext.getCurrUserId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> subTasks = new ArrayList<Map<String, Object>>();
        List categorySet = categorys.stream().map(a -> a.getCategory()).collect(Collectors.toList());
        List orgCollect = orgList.stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
        List taxableList = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxableListService", (String)"queryTimely", (Object[])new Object[]{orgCollect, null, categorySet, executeTime, 1});
        Map<Object, List<Map>> taxableMap = taxableList.stream().filter(a -> a.get("org") != null && Objects.equals(a.get("draftstatus"), TaxableListDto.DRAFTSTATUS_WBZ)).collect(Collectors.groupingBy(a -> a.getOrDefault("dgcategory", "")));
        for (DraftCateGory draftCateGory : categorys) {
            TaskMessageBuilder.buildSonDraftTaskMessageByList(draftCateGory, taxableMap.get(draftCateGory.getCategory()), executeTime, subTasks, userid);
        }
        params.put("operater", userid);
        params.put("taskClassName", "kd.taxc.tam.business.mq.draft.BatchDraftTask");
        params.put("appid", "bdtaxr");
        params.put("taskdefineId", "2O/+75P9AO8U");
        params.put("taskName", "batchDraftTask111");
        String executeType = (String)map.get("executeType");
        params.put("executeType", StringUtils.isNotEmpty((String)executeType) ? executeType : "1");
        params.put("businessParams", null);
        params.put("taskId", this.taskId);
        params.put("subTasks", subTasks);
        logger.info("\u4e3b\u4efb\u52a1taskId:{};\u6279\u91cf\u751f\u6210\u5e95\u7a3f\u53c2\u6570\uff1a{}", (Object)this.taskId, params);
        return params;
    }

    public String buildNotification() {
        return ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u8fdb\u5ea6\uff1a", (String)"BatchDraftTask_0", (String)"taxc-tam", (Object[])new Object[0]);
    }

    private List<String> queryOrgList() {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer();
        return ((List)result.getData()).stream().map(o -> o.getString("taxorg.id")).collect(Collectors.toList());
    }
}

