/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.synchronize.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.mq.datasynchronize.SynchronizeParam;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tam.business.synchronize.DataSynchronizeService;
import kd.taxc.tam.common.enums.TaxTypeZeroDeclareEnum;

public class DataSynchronizeServiceImpl
implements DataSynchronizeService {
    private static final Map<String, String> taxTypeMap = new HashMap<String, String>(){
        {
            this.put(ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"DataSynchronizeServiceImpl_0", (String)"taxc-tam", (Object[])new Object[0]), "cztdsys");
            this.put(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"DataSynchronizeServiceImpl_1", (String)"taxc-tam", (Object[])new Object[0]), "yhs");
            this.put(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"DataSynchronizeServiceImpl_2", (String)"taxc-tam", (Object[])new Object[0]), "fcs");
            this.put(ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"DataSynchronizeServiceImpl_3", (String)"taxc-tam", (Object[])new Object[0]), "hbs");
            this.put(ResManager.loadKDString((String)"\u8f66\u8239\u7a0e", (String)"DataSynchronizeServiceImpl_4", (String)"taxc-tam", (Object[])new Object[0]), "ccs");
            this.put(ResManager.loadKDString((String)"\u5951\u7a0e", (String)"DataSynchronizeServiceImpl_5", (String)"taxc-tam", (Object[])new Object[0]), "qs");
            this.put(ResManager.loadKDString((String)"\u8015\u5730\u5360\u7528\u7a0e", (String)"DataSynchronizeServiceImpl_6", (String)"taxc-tam", (Object[])new Object[0]), "gdzys");
            this.put(ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"DataSynchronizeServiceImpl_7", (String)"taxc-tam", (Object[])new Object[0]), "zys");
            this.put(ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"DataSynchronizeServiceImpl_8", (String)"taxc-tam", (Object[])new Object[0]), "tdzzs");
            this.put(ResManager.loadKDString((String)"\u70df\u53f6\u7a0e", (String)"DataSynchronizeServiceImpl_9", (String)"taxc-tam", (Object[])new Object[0]), "yys");
        }
    };
    private static final List<String> CWBB_TEMPLATETYPE = Lists.newArrayList((Object[])new String[]{"FR0001", "FR0002", "FR0003", "FR0004", "FR0011"});

    @Override
    public EngineResponse dataSynchronize(SynchronizeParam synchronizeParam) {
        Long id = synchronizeParam.getId();
        String templateType = synchronizeParam.getTemplateType();
        Long orgId = synchronizeParam.getOrgId();
        if (id == null || StringUtil.isBlank((CharSequence)templateType)) {
            return EngineResponse.fail((String)"parameters cannot be null!", null);
        }
        if (templateType.startsWith("zzs")) {
            return this.synchronizeTcvat(id, orgId);
        }
        if (templateType.equals("ccxws")) {
            return this.synchronizeTcret(id, orgId);
        }
        if (templateType.startsWith("qtsf")) {
            return this.synchronizeTotf(id, orgId);
        }
        if (templateType.startsWith("qysds")) {
            return this.synchronizeTccit(id, orgId);
        }
        if (templateType.equals("whsyjsf")) {
            return this.synchronizeWhsyjsf(id, orgId);
        }
        if (templateType.startsWith("szys")) {
            return this.synchronizeSzys(id, templateType, orgId);
        }
        if (CWBB_TEMPLATETYPE.contains(templateType)) {
            return this.synchronizeCwbb(id, orgId);
        }
        return EngineResponse.success((String)"success", null);
    }

    private EngineResponse synchronizeCwbb(Long id, Long orgId) {
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        DynamicObject object = this.synchronizeCwbbToTamEntry(id, 0, orgId);
        tamEntryList.add(object);
        return this.saveDate(id, tamEntryList);
    }

    private EngineResponse synchronizeSzys(Long id, String templateType, Long orgId) {
        this.syncSzysQueryReportEntity(id);
        String tcvatEntry = "tcwat_declare_a_tax";
        DynamicObject entry = QueryServiceHelper.queryOne((String)tcvatEntry, (String)" bqynse,bqjmse,bqyjse,bqybtse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(id)), new QFilter("ewblxh", "=", (Object)"sum")});
        if (entry == null) {
            return EngineResponse.success((String)"success", null);
        }
        String name = (String)TemplateTypeConstant.getMap().get(templateType);
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        DynamicObject object = this.synchronizeDataToTamEntry(id, name, entry.getBigDecimal("bqybtse"), 0, orgId);
        tamEntryList.add(object);
        return this.saveDate(id, tamEntryList);
    }

    private EngineResponse synchronizeWhsyjsf(Long id, Long orgId) {
        String tcvatEntry = "tctb_declare_entry";
        DynamicObjectCollection entryList = QueryServiceHelper.query((String)tcvatEntry, (String)"ewblxh,ewblname,bqdybtse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)id)});
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entryList) {
            int seq = StringUtil.isEmpty((CharSequence)entry.getString("ewblxh")) ? 0 : Integer.parseInt(entry.getString("ewblxh"));
            DynamicObject object = this.synchronizeDataToTamEntry(id, this.getWhsyjsfTaxtype(entry.getString("ewblxh")), entry.getBigDecimal("bqdybtse"), seq, orgId);
            tamEntryList.add(object);
        }
        return this.saveDate(id, tamEntryList);
    }

    private EngineResponse synchronizeTccit(Long id, Long orgId) {
        String taxtype = ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"DataSynchronizeServiceImpl_16", (String)"taxc-tam", (Object[])new Object[0]);
        String tccitEntry = "tcvat_nsrxx";
        DynamicObject tccitObject = QueryServiceHelper.queryOne((String)tccitEntry, (String)"bqybtse", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (tccitObject == null) {
            return EngineResponse.success((String)"success", null);
        }
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        DynamicObject object = this.synchronizeDataToTamEntry(id, taxtype, tccitObject.getBigDecimal("bqybtse"), 0, orgId);
        tamEntryList.add(object);
        return this.saveDate(id, tamEntryList);
    }

    private EngineResponse synchronizeTotf(Long id, Long orgId) {
        String totfEntry = "totf_sjfzsf_dtb";
        DynamicObjectCollection entryList = QueryServiceHelper.query((String)totfEntry, (String)"zspm,ybse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)id)});
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        int seq = 0;
        for (DynamicObject entry : entryList) {
            DynamicObject object = this.synchronizeDataToTamEntry(id, entry.getString("zspm"), entry.getBigDecimal("ybse"), seq, orgId);
            tamEntryList.add(object);
            ++seq;
        }
        return this.saveDate(id, tamEntryList);
    }

    private EngineResponse synchronizeTcret(Long id, Long orgId) {
        this.syncTcretQqueryReportEntity(id);
        String tcretEntry = "tcret_ccxws_zb_hb";
        DynamicObjectCollection entryList = QueryServiceHelper.query((String)tcretEntry, (String)"taxtype,ybse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(id))});
        HashMap mergeObject = Maps.newHashMap();
        for (DynamicObject object : entryList) {
            String key = object.getString("taxtype");
            DynamicObject haveObject = (DynamicObject)mergeObject.get(key);
            if (haveObject != null) {
                haveObject.set("ybse", (Object)haveObject.getBigDecimal("ybse").add(object.getBigDecimal("ybse")));
                continue;
            }
            mergeObject.put(key, object);
        }
        int seq = 0;
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>(mergeObject.size());
        for (DynamicObject entry : mergeObject.values()) {
            DynamicObject object = this.synchronizeDataToTamEntry(id, entry.getString("taxtype"), entry.getBigDecimal("ybse"), seq, orgId);
            tamEntryList.add(object);
            ++seq;
        }
        return this.saveDate(id, tamEntryList);
    }

    private void syncTcretQqueryReportEntity(Long id) {
        boolean exists = QueryServiceHelper.exists((String)"tcret_query_report", (Object)id);
        if (exists) {
            DynamicObject nsrxxObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcret_query_report");
            DynamicObjectCollection entryentity = nsrxxObj.getDynamicObjectCollection("entryentity");
            Map<String, Object> idMap = entryentity.stream().collect(Collectors.toMap(a -> a.getString("taxtype") + DateUtils.format((Date)a.getDate("startdate")) + DateUtils.format((Date)a.getDate("enddate")), b -> b.get("id"), (m, n) -> m));
            entryentity.clear();
            DynamicObject[] tcretmain = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"id,taxtype,startdate,enddate,ynse,jmse,yjse,ybse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(id))}, (String)"taxtype");
            Map<String, List<DynamicObject>> tcretmainGroupByMap = Arrays.stream(tcretmain).collect(Collectors.groupingBy(p -> p.getString("taxtype") + DateUtils.format((Date)p.getDate("startdate")) + DateUtils.format((Date)p.getDate("enddate"))));
            for (List<DynamicObject> groupByList : tcretmainGroupByMap.values()) {
                BigDecimal ynse = groupByList.stream().map(a -> a.getBigDecimal("ynse")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal jmse = groupByList.stream().map(a -> a.getBigDecimal("jmse")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal yjse = groupByList.stream().map(a -> a.getBigDecimal("yjse")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal ybse = groupByList.stream().map(a -> a.getBigDecimal("ybse")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                Object entryid = idMap.get(taxTypeMap.get(groupByList.get(0).getString("taxtype")) + DateUtils.format((Date)groupByList.get(0).getDate("startdate")) + DateUtils.format((Date)groupByList.get(0).getDate("enddate")));
                DynamicObject entryObject = entryentity.addNew();
                if (entryid != null) {
                    entryObject.set("id", entryid);
                }
                entryObject.set("taxtype", (Object)taxTypeMap.get(groupByList.get(0).getString("taxtype")));
                entryObject.set("startdate", (Object)groupByList.get(0).getDate("startdate"));
                entryObject.set("enddate", (Object)groupByList.get(0).getDate("enddate"));
                entryObject.set("ynse", (Object)ynse);
                entryObject.set("jmse", (Object)jmse);
                entryObject.set("yjse", (Object)yjse);
                entryObject.set("ybse", (Object)ybse);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nsrxxObj});
        }
    }

    private void syncSzysQueryReportEntity(Long id) {
        boolean exists = QueryServiceHelper.exists((String)"tcwat_declare_query", (Object)id);
        if (exists) {
            DynamicObject nsrxxObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcwat_declare_query");
            DynamicObjectCollection entryentity = nsrxxObj.getDynamicObjectCollection("entryentity");
            Object entryid = entryentity.size() > 0 ? ((DynamicObject)entryentity.get(0)).get("id") : null;
            entryentity.clear();
            DynamicObject[] szysMain = BusinessDataServiceHelper.load((String)"tcwat_declare_a_tax", (String)"sbbid,bqynse,bqjmse,bqyjse,bqybtse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(id)), new QFilter("ewblxh", "=", (Object)"sum")});
            if (szysMain.length > 0) {
                DynamicObject entryObject = entryentity.addNew();
                if (entryid != null) {
                    entryObject.set("id", entryid);
                }
                entryObject.set("ynse", szysMain[0].get("bqynse"));
                entryObject.set("jmse", szysMain[0].get("bqjmse"));
                entryObject.set("yjse", szysMain[0].get("bqyjse"));
                entryObject.set("bqdybtse", szysMain[0].get("bqybtse"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nsrxxObj});
            }
        }
    }

    private EngineResponse synchronizeTcvat(Long id, Long orgId) {
        String tcvatEntry = "tctb_declare_entry";
        DynamicObjectCollection entryList = QueryServiceHelper.query((String)tcvatEntry, (String)"ewblxh,ewblname,bqdybtse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)id)});
        ArrayList<DynamicObject> tamEntryList = new ArrayList<DynamicObject>();
        for (DynamicObject entry : entryList) {
            int seq = StringUtil.isEmpty((CharSequence)entry.getString("ewblxh")) ? 0 : Integer.parseInt(entry.getString("ewblxh"));
            DynamicObject object = this.synchronizeDataToTamEntry(id, this.getZzsTaxtype(entry.getString("ewblxh")), entry.getBigDecimal("bqdybtse"), seq, orgId);
            tamEntryList.add(object);
        }
        return this.saveDate(id, tamEntryList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EngineResponse saveDate(Long id, List<DynamicObject> tamEntryList) {
        String lockKey = "tamdeclareentrysavelockkey:" + id.toString();
        DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tam.business.synchronize.impl.DataSynchronizeServiceImpl.saveDate");
        reentrant.fastMode();
        boolean b = reentrant.tryLock(1500L);
        if (!b) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868[%s]\u5df2\u6709\u4fdd\u5b58\u64cd\u4f5c\u5728\u6267\u884c\u3002", (String)"DataSynchronizeServiceImpl_17", (String)"taxc-tam", (Object[])new Object[0]), id.toString());
            throw new KDBizException(msg);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                String tamEntry = "tam_declare_entry";
                DeleteServiceHelper.delete((String)tamEntry, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)id)});
                SaveServiceHelper.save((DynamicObject[])tamEntryList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                h.markRollback();
                EngineResponse engineResponse = EngineResponse.fail((String)String.format("Failed to save data! cause : %s", e.getMessage()), null);
                if (h != null) {
                    if (var7_8 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                reentrant.unlock();
                return engineResponse;
            }
        }
        finally {
            reentrant.unlock();
        }
        return EngineResponse.success((String)"success", null);
    }

    private String getWhsyjsfTaxtype(String key) {
        String whsyjsf = ResManager.loadKDString((String)"\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", (String)"DataSynchronizeServiceImpl_10", (String)"taxc-tam", (Object[])new Object[0]);
        if ("1".equals(key)) {
            return whsyjsf;
        }
        return whsyjsf;
    }

    private String getZzsTaxtype(String key) {
        String zzs = ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DataSynchronizeServiceImpl_11", (String)"taxc-tam", (Object[])new Object[0]);
        String fjsf = ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"DataSynchronizeServiceImpl_12", (String)"taxc-tam", (Object[])new Object[0]);
        String cswhjss = ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"DataSynchronizeServiceImpl_13", (String)"taxc-tam", (Object[])new Object[0]);
        String jyffj = ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"DataSynchronizeServiceImpl_14", (String)"taxc-tam", (Object[])new Object[0]);
        String dfjyfj = ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"DataSynchronizeServiceImpl_15", (String)"taxc-tam", (Object[])new Object[0]);
        switch (key) {
            case "1": {
                return zzs;
            }
            case "2": {
                return fjsf;
            }
            case "3": {
                return cswhjss;
            }
            case "4": {
                return jyffj;
            }
            case "5": {
                return dfjyfj;
            }
        }
        return zzs;
    }

    private DynamicObject synchronizeDataToTamEntry(Long id, String taxtype, BigDecimal bqybtse, int seq, Long orgId) {
        String tamEntry = "tam_declare_entry";
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)tamEntry);
        object.set("sbbid", (Object)id);
        object.set("taxtype", (Object)taxtype);
        object.set("bqybtse", (Object)bqybtse);
        object.set("sequence", (Object)seq);
        if (!StringUtil.isBlank((CharSequence)TaxTypeZeroDeclareEnum.getAppNumberBytaxType(taxtype))) {
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)TaxTypeZeroDeclareEnum.getAppNumberBytaxType(taxtype), (String)TaxTypeZeroDeclareEnum.getParamKeyBytaxType(taxtype), (long)orgId);
            object.set("zerodeclare", (Object)Boolean.toString(zerodeclare));
        } else {
            object.set("zerodeclare", (Object)Boolean.FALSE.toString());
        }
        return object;
    }

    private DynamicObject synchronizeCwbbToTamEntry(Long id, int seq, Long orgId) {
        String tamEntry = "tam_declare_entry";
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)tamEntry);
        object.set("sbbid", (Object)id);
        object.set("sequence", (Object)seq);
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)TaxTypeZeroDeclareEnum.CWBB.getAppNumber(), (String)TaxTypeZeroDeclareEnum.CWBB.getParamKey(), (long)orgId);
        object.set("zerodeclare", (Object)Boolean.toString(zerodeclare));
        return object;
    }
}

