/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareReportServiceImpl;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaskCenterFormRecalTask
extends AbstractTask {
    private String message;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        List draftIds = (List)params.get("draftIds");
        DynamicObject[] drafts = BusinessDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tam_draft_bill"));
        List<String> sbbnos = Arrays.stream(drafts).filter(d -> d.getBoolean("isdeclare") && StringUtil.isNotEmpty((CharSequence)d.getString("sbbno"))).map(d -> d.getString("sbbno")).collect(Collectors.toList());
        List<String> stashSbbnos = this.doQueryStashStatusDeclare(sbbnos);
        List needRecalDrafts = Arrays.stream(drafts).filter(d -> this.needGenerateDeclare((DynamicObject)d, stashSbbnos)).collect(Collectors.toList());
        int total = needRecalDrafts.size();
        int count = 0;
        TaxDeclareReportServiceImpl taxDeclareReportService = new TaxDeclareReportServiceImpl();
        DeclareRequestServiceImpl declareRequestService = new DeclareRequestServiceImpl();
        for (DynamicObject obj : needRecalDrafts) {
            TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)obj.getString("templatetype"));
            DeclareRequestModel declareRequest = declareRequestService.buildFromParams(String.valueOf(obj.getLong("org.id")), templateEnum.getDeclareType(), obj.getString("startdate"), obj.getString("enddate"));
            taxDeclareReportService.recalDeclare(SerializationUtils.toJsonString((Object)declareRequest));
            this.feedbackProgress(++count * 100 / total, ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"TaskCenterFormRecalTask_0", (String)"taxc-tam", (Object[])new Object[0]), null);
        }
        if (StringUtil.isEmpty((CharSequence)this.message)) {
            params.put("success", "true");
        }
        params.put("success", "false");
        params.put("message", this.message);
        this.feedbackCustomdata(params);
    }

    private List<String> doQueryStashStatusDeclare(List<String> sbbnos) {
        QFilter qfilter = new QFilter("billno", "in", sbbnos).and(new QFilter("billstatus", "in", (Object)"A"));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"billno", (QFilter[])new QFilter[]{qfilter});
        if (objs.length == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(objs).stream().map(o -> o.getString("billno")).collect(Collectors.toList());
    }

    private boolean needGenerateDeclare(DynamicObject d, List<String> stashSbbnos) {
        if ("false".equals(d.getString("isdeclare")) || stashSbbnos.contains(d.getString("sbbno"))) {
            this.message = null;
            return true;
        }
        this.message = String.format(ResManager.loadKDString((String)"\u201c%1$S\u201d\u5728\u201c%2$S\u201d\u81f3\u201c%3$S\u201d\u7684\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u4e0d\u652f\u6301\u4fee\u6539", (String)"TaskCenterFormRecalTask_1", (String)"taxc-tam", (Object[])new Object[0]), d.getString("org.name"), d.getString("startdate"), d.getString("enddate"));
        return false;
    }
}

