/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tam.business.job.JobDispatchFormHelper;

public class TaskCenterService {
    private static final String BDTAXR_ACCRUAL_LISTING = "bdtaxr_accrual_listing";
    public static final String PROVISTON_TAXES = "itp_proviston_taxes";

    public static Map<String, Object> calcSjjtStat(List<Long> orgList, Date startDate, Date endDate) {
        String accrualListEntity = BDTAXR_ACCRUAL_LISTING;
        QFilter orgQFilter = new QFilter("org", "in", orgList);
        QFilter jtDateQFilter = new QFilter("month", ">=", (Object)startDate).and(new QFilter("month", "<=", (Object)endDate));
        DynamicObjectCollection allOrgTaxableList = QueryServiceHelper.query((String)accrualListEntity, (String)"id,org,billno,billstatus", (QFilter[])new QFilter[]{jtDateQFilter});
        ArrayList<String> billnoList = new ArrayList<String>(allOrgTaxableList.size());
        int accrualDraftCount = 0;
        int wjtDraftCount = 0;
        for (DynamicObject obj : allOrgTaxableList) {
            billnoList.add(obj.getString("billno"));
            if (!orgList.contains(obj.getLong("org"))) continue;
            ++accrualDraftCount;
            if (!"nodata".equals(obj.getString("billstatus"))) continue;
            ++wjtDraftCount;
        }
        int yjtDraftCount = accrualDraftCount - wjtDraftCount;
        String formula = "if({accrualDraftCount} == 0, 0, DataFormatUtils.decimalFormat(({yjtDraftCount} / {accrualDraftCount}) * 100,\"#0\"))";
        formula = formula.replaceAll("\\{yjtDraftCount}", yjtDraftCount + "").replaceAll("\\{accrualDraftCount}", accrualDraftCount + "");
        Object jtwcl = FelService.evalWithKey((String)formula, null);
        QFilter taxorgQFilter = new QFilter("taxorg", "in", orgList);
        QFilter lydgbhQFilter = new QFilter("entitynumber", "in", billnoList);
        QFilter scpzQFilter = new QFilter("isvoucher", "in", Arrays.asList("0", "1"));
        DynamicObjectCollection sjjtd = QueryServiceHelper.query((String)PROVISTON_TAXES, (String)"id,isvoucher,total", (QFilter[])new QFilter[]{taxorgQFilter, lydgbhQFilter, scpzQFilter});
        int yrzsjjtCount = 0;
        BigDecimal yrzsjhj = BigDecimal.ZERO;
        int wrzsjjtCount = 0;
        BigDecimal wrzsjhj = BigDecimal.ZERO;
        for (DynamicObject obj : sjjtd) {
            if ("1".equals(obj.getString("isvoucher"))) {
                ++yrzsjjtCount;
                yrzsjhj = yrzsjhj.add(obj.getBigDecimal("total"));
                continue;
            }
            ++wrzsjjtCount;
            wrzsjhj = wrzsjhj.add(obj.getBigDecimal("total"));
        }
        String rzwclFormula = "if({yrzsjjtCount} + {wrzsjjtCount} == 0, 0, DataFormatUtils.decimalFormat(({yrzsjjtCount} / ({yrzsjjtCount} + {wrzsjjtCount})) * 100,\"#0\"))";
        rzwclFormula = rzwclFormula.replaceAll("\\{yrzsjjtCount}", yrzsjjtCount + "").replaceAll("\\{wrzsjjtCount}", wrzsjjtCount + "");
        Object rzwcl = FelService.evalWithKey((String)rzwclFormula, null);
        String jtdgzbEntity = "tpo_declare_main_tsd";
        QFilter dgbhQFilter = new QFilter("billno", "in", billnoList);
        QFilter scjtdQFilter = new QFilter("generatebusinessdoc", "=", (Object)false);
        DynamicObjectCollection wscjtd = QueryServiceHelper.query((String)jtdgzbEntity, (String)"id,jtynsesum", (QFilter[])new QFilter[]{orgQFilter, dgbhQFilter, scjtdQFilter});
        double wscjtdhjw = wscjtd.stream().mapToDouble(e -> Double.parseDouble(e.getString("jtynsesum"))).sum();
        BigDecimal yjtsj = yrzsjhj.add(wrzsjhj).add(new BigDecimal(String.valueOf(wscjtdhjw)));
        HashMap<String, Object> obj = new HashMap<String, Object>(26);
        obj.put("nsztsl2", orgList.size());
        obj.put("jtdgsl", accrualDraftCount);
        obj.put("jtwcl", jtwcl);
        obj.put("yjt", yjtDraftCount);
        obj.put("wjt", wjtDraftCount);
        obj.put("rzwcl", rzwcl);
        obj.put("yrz", yrzsjjtCount);
        obj.put("wrz", wrzsjjtCount);
        obj.put("yjtsj", yjtsj);
        return obj;
    }

    public static void setSjjtListFilter(String listKey, List<Long> orgList, Date startDate, Date endDate, List<QFilter> qFilters) {
        if ("billlistap4".equals(listKey)) {
            QFilter orgQFilter = new QFilter("org", "in", orgList);
            QFilter jtDateQFilter = new QFilter("month", ">=", (Object)startDate).and(new QFilter("month", "<=", (Object)endDate));
            QFilter billStatusQFilter = new QFilter("billstatus", "=", (Object)"nodata");
            qFilters.add(orgQFilter.and(jtDateQFilter).and(billStatusQFilter));
        } else {
            QFilter sbQFilter;
            String accrualListEntity = BDTAXR_ACCRUAL_LISTING;
            QFilter jtDateQFilter = new QFilter("month", ">=", (Object)startDate).and(new QFilter("month", "<=", (Object)endDate));
            DynamicObjectCollection allOrgTaxableList = QueryServiceHelper.query((String)accrualListEntity, (String)"id,org,billno,billstatus", (QFilter[])new QFilter[]{jtDateQFilter});
            List billNoList = allOrgTaxableList.stream().map(e -> e.getString("billno")).collect(Collectors.toList());
            if ("billlistap5".equals(listKey)) {
                sbQFilter = new QFilter("org", "in", orgList).and("billno", "in", billNoList).and("generatebusinessdoc", "=", (Object)false);
                qFilters.add(sbQFilter);
            }
            if ("billlistap6".equals(listKey)) {
                sbQFilter = new QFilter("taxorg", "in", orgList).and("entitynumber", "in", billNoList).and("isvoucher", "=", (Object)"0");
                qFilters.add(sbQFilter);
            }
            if ("billlistap7".equals(listKey)) {
                sbQFilter = new QFilter("taxorg", "in", orgList).and("entitynumber", "in", billNoList).and("isvoucher", "=", (Object)"1");
                qFilters.add(sbQFilter);
            }
        }
    }

    public static void doSjjt(Object[] primaryKeyValues, Date jtDate, IFormView view) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection selectedTaxableList = QueryServiceHelper.query((String)BDTAXR_ACCRUAL_LISTING, (String)"id,org,taxtype,category", (QFilter[])new QFilter("id", "in", (Object)primaryKeyValues).toArray());
        for (DynamicObject obj : selectedTaxableList) {
            String category = obj.getString("category");
            Long taxtype = obj.getLong("taxtype");
            Long org = obj.getLong("org");
            if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{category}) || taxtype == null || org == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("category", category);
            map.put("taxtype", taxtype);
            map.put("org", org);
            list.add(map);
        }
        JobDispatchFormHelper.sendAccrualMsgByCategoryOrgList(list, jtDate, view, "sjjt", "kd.taxc.tam.formplugin.task.TaskCenterFormPlugin");
    }
}

