/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.common.enums;

import java.util.Arrays;
import java.util.List;

public enum TemplateTypeMetadataEnum {
    QYSDSJB("qysdsjb", "tccit_query_report", Arrays.asList("qysdsjb", "qysds_hdzs_jb")),
    QYSDSNB("qysdsnb", "tccit_quarterly_report", Arrays.asList("qysdsnb", "qysds_hdzs_nb", "qysdsnb_fzjg")),
    ZZS("zzs", "tcvat_zzs_declare_list"),
    ZZSYJSKB("zzsyjskb", "tcvat_prepay_declare_bill"),
    CCXWS("ccxws", "tcret_query_report"),
    TYSF("qtsf", "totf_tysb_declare_main"),
    WHSYJSF("whsyjsf", "totf_whsyjs_declare_query"),
    FR("FR", "tcvvt_main_declare_list"),
    SZYS("szys", "tcwat_declare_query");

    private String type;
    private String metadata;
    private List<String> nsrTypes;

    public String getType() {
        return this.type;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public List<String> getNsrTypes() {
        return this.nsrTypes;
    }

    private TemplateTypeMetadataEnum(String type, String metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    private TemplateTypeMetadataEnum(String type, String metadata, List<String> nsrTypes) {
        this.type = type;
        this.metadata = metadata;
        this.nsrTypes = nsrTypes;
    }

    public static String getMetadataByType(String type) {
        for (TemplateTypeMetadataEnum value : TemplateTypeMetadataEnum.values()) {
            if (!value.type.equals(type)) continue;
            return value.metadata;
        }
        return "";
    }

    public static TemplateTypeMetadataEnum getEnumByType(String type) {
        for (TemplateTypeMetadataEnum value : TemplateTypeMetadataEnum.values()) {
            if (!value.type.equals(type)) continue;
            return value;
        }
        return null;
    }
}

