/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class DeclareCommonUtil {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String APPLY = "apply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";

    public static void dealFail(OperationResult opResult, IFormView view, IFormPlugin plugin) {
        String msg = opResult.getMessage();
        if (msg == null) {
            return;
        }
        String[] messages = msg.split(SEPARATOR);
        String showMsg = Arrays.stream(messages).filter(e -> !e.contains("fzybhz:")).collect(Collectors.joining(SEPARATOR));
        String zzsMsg = Arrays.stream(messages).filter(e -> e.contains("fzybhz:")).collect(Collectors.joining());
        messages = showMsg.split(SEPARATOR);
        if (StringUtil.isNotBlank((CharSequence)zzsMsg)) {
            zzsMsg = zzsMsg.substring(7);
            view.showConfirm(zzsMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(APPLY, plugin));
        }
        if (messages.length == 1 && StringUtil.isNotBlank((CharSequence)showMsg)) {
            if (showMsg.equals(ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868\u4e0d\u6d89\u53ca\u7f34\u6b3e", (String)"DeclareCommonUtil_0", (String)"taxc-tam", (Object[])new Object[0]))) {
                view.showErrorNotification(showMsg);
            } else {
                view.showOperationResult(opResult);
            }
            return;
        }
        if (messages.length > 1) {
            view.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(showMsg);
            view.showOperationResult(operationResult);
        }
    }

    public static void pay(BillList billlist, Object[] pkIds, Date payDate, IPageCache pageCache, IFormView view) {
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)(DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING + ",entryentity.deferpayapply1"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
            for (DynamicObject declare : declares) {
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[0]));
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"DeclareCommonUtil_1", (String)"taxc-tam", (Object[])new Object[0]));
                billlist.refresh();
                DeclareCommonUtil.calcElement(modifyDynamicObjects, PAY, pageCache);
            }
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    private static void calcElement(List<DynamicObject> modifyDynamicObjects, String act, IPageCache pageCache) {
        for (DynamicObject modifyob : modifyDynamicObjects) {
            if (CANCELPAY.equals(act)) {
                Date paydate = DateUtils.stringToDate((String)pageCache.get(modifyob.getString("id")));
                DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)paydate, (String)DeclareMQType.PAY.name(), (String)act);
                continue;
            }
            DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)DeclareCommonUtil.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)act);
        }
    }
}

