/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.accrual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class AccrualQueryListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"checkjtd", (CharSequence)((Donothing)args.getSource()).getOperateKey()) && ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"AccrualQueryListPlugin_1", (String)"taxc-tam", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        if ("billno".equals(fieldName)) {
            this.openAccrualPage(list);
        }
    }

    private void openAccrualPage(BillList list) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject current = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tam_declare_main_tsd");
        String drafttype = current.getString("templatetype");
        if ("draft_qysdsjb".equals(drafttype) || "sdsjt_bd".equals(drafttype) || "sdsjt_jt".equals(drafttype) || TemplateTypeConstant.TCVAT_SJJT_TYPES.contains(drafttype)) {
            this.openDraftPageOrDeclarePage(list, true);
        } else {
            String formId = "tcret_fcs_accrual_draft";
            switch (drafttype) {
                case "fcs": {
                    formId = "tcret_fcs_accrual_draft";
                    break;
                }
                case "cztdsys": {
                    formId = "tcret_fcs_accrual_draft";
                    break;
                }
                case "yhs": {
                    formId = "tcret_yhs_acccrual";
                    break;
                }
                case "hjbhs": {
                    formId = "tcret_hbs_accrual_draft";
                    break;
                }
                case "ccs": {
                    formId = "tcret_ccs_accrual_draft";
                    break;
                }
                case "szys": {
                    formId = "tcret_szys_accrual_draft";
                }
            }
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("drafttype", drafttype);
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)formId, (Object)current.get("id"), (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
        }
    }

    private void openDraftPageOrDeclarePage(BillList list, boolean openDraftPage) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tam_declare_main_tsd");
        String templatetype = object.getString("templatetype");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("orgid", object.getDynamicObject("org").getString("id"));
        customParams.put("orgname", object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("templatetype", templatetype);
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("taxationsys", object.getLong("taxsystem.id"));
        customParams.put("billno", object.getString("billno"));
        customParams.put("zt_type", object.getString("accountsettype"));
        customParams.put("draftpurpose", "sjjt");
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
        FormShowParameter param = new FormShowParameter();
        if (openDraftPage) {
            param.setFormId(draftEnum.getDraftPage());
        } else {
            param.setFormId(draftEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"AccrualQueryListPlugin_3", (String)"taxc-tam", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = evt.getOperateKey();
        if ("new".equals(evt.getOperateKey())) {
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tam_add_accrual", (IFormView)this.getView(), null, (IFormPlugin)this);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") || StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
            billlist.refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"checkjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            List ids = evt.getOperationResult().getSuccessPkIds();
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId, (String)"billno,org.id ,taxsystem.id,drafttype");
                this.openProvistonBillPage(dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"));
            }
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList value = Lists.newArrayList((Object[])new String[]{"draft_qysdsjb", "sdsjt_bd", "sdsjt_jt", "yhs", "fcs", "cztdsys", "ccs", "hjbhs", "szys"});
        value.addAll(TemplateTypeConstant.TCVAT_SJJT_TYPES);
        e.getQFilters().add(new QFilter("templatetype", "in", (Object)value));
    }
}

