/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.accrual;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tam.business.job.JobDispatchFormHelper;

public class TamAddAccrualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        MulBasedataEdit control = (MulBasedataEdit)this.getControl("org");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("org");
        List selectOrgList = orgs.stream().map(m -> m.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIds(selectOrgList).getData();
        List unableOrgNameList = orgs.stream().filter(m -> !orgList.contains(m.getDynamicObject("fbasedataid").getLong("id"))).map(m -> m.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
        selectOrgList.removeAll(orgList);
        if (selectOrgList.size() > 0) {
            StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7", (String)"TamAddAccrualPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            for (String object : unableOrgNameList) {
                builder.append(String.format(ResManager.loadKDString((String)"\u3010%s\u3011", (String)"TamAddAccrualPlugin_4", (String)"taxc-tam", (Object[])new Object[0]), object));
            }
            builder.append(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TamAddAccrualPlugin_3", (String)"taxc-tam", (Object[])new Object[0]));
            this.getView().showErrorNotification(builder.toString());
            return;
        }
        Date accrualDate = (Date)this.getModel().getValue("accrualdate");
        String category = (String)this.getModel().getValue("category");
        JobDispatchFormHelper.sendAccrualMsg(orgList, category, accrualDate, this.getView().getParentView(), "categorydispatch", "kd.taxc.tam.formplugin.accrual.TamAddAccrualPlugin");
        this.getView().close();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((String)"tam", (String)"itp_draft_query_list", (String)"47156aff000000ac");
        if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            List permorgList = permOrgResult.getHasPermOrgs();
            List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIds((List)permorgList).getData();
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
        }
    }
}

