/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.accrual;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class WorkflowViewAccrualPlugin
extends AbstractBillPlugIn {
    private List<String> ccxwsTemplateList = Arrays.asList("fcs", "cztdsys", "yhs", "hjbhs", "ccs");

    public void afterLoadData(EventObject e) {
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        customParams.put("orgid", org.getString("id"));
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        String templatetype = (String)this.getModel().getValue("templatetype");
        if ("draft_qysdsjb".equals(templatetype)) {
            customParams.put("templatetype", templatetype);
            customParams.put("draftpurpose", "sjjt");
            customParams.put("skssqq", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
            customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            FormShowParameter param = new FormShowParameter();
            param.setFormId(TemplateEnum.getEnumByDraftType((String)templatetype).getDraftPage());
            param.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"WorkflowViewAccrualPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(param);
        } else if (this.ccxwsTemplateList.contains(templatetype)) {
            String formId = "tcret_fcs_accrual_draft";
            switch (templatetype) {
                case "fcs": {
                    formId = "tcret_fcs_accrual_draft";
                    break;
                }
                case "cztdsys": {
                    formId = "tcret_fcs_accrual_draft";
                    break;
                }
                case "yhs": {
                    formId = "tcret_yhs_acccrual";
                    break;
                }
                case "hjbhs": {
                    formId = "tcret_hbs_accrual_draft";
                    break;
                }
                case "ccs": {
                    formId = "tcret_ccs_accrual_draft";
                }
            }
            customParams.put("taxtype", templatetype);
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)formId, (Object)this.getModel().getValue("id"), (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.VIEW);
        }
    }
}

