/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.declare;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.taxorg.TaxNameUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tam.common.util.DeclareCommonUtil;

public class TamDeclareListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(TamDeclareListPlugin.class);
    private static final String BILL_LIST = "billlistap";
    private static final String APPLY = "apply";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private DeclareReportHideService declareReportHideService;
    private static final String INVALID = "invalid";
    private static final String RECTIFY = "rectify";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        billlist.setOrderBy("org desc,skssqq desc,id desc");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("skssqq");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put("skssqq", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        List<String> templates = this.getTemplateTypeList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(templates.size());
        for (String template : templates) {
            ComboItem item = new ComboItem();
            item.setValue(template);
            item.setCaption(new LocaleString((String)TemplateTypeConstant.getNsrtypemap().get(template)));
            combos.add(item);
        }
        for (FilterColumn column : filterColumnList) {
            String nolimit;
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (CommonFilterColumn)column;
            String querytype = (String)customParams.get("querytype");
            if (!StringUtils.isEmpty((CharSequence)querytype)) {
                typeColumn.setDefaultValue(querytype);
            }
            if ("false".equals(nolimit = (String)customParams.get("nolimit"))) {
                typeColumn.setMustInput(true);
            }
            typeColumn.setComboItems(combos);
        }
        for (FilterColumn column : schemeColumnList) {
            if (!"type".equals(column.getFieldName())) continue;
            typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(combos);
            break;
        }
        QFilter typeFilter = new QFilter("type", "in", templates);
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        billlist.setFilter(typeFilter);
        billlist.getQueryFilterParameter().setOrderBy("id desc");
    }

    private List<String> getTemplateTypeList() {
        String taxtype = (String)this.getView().getFormShowParameter().getCustomParam("taxtype");
        String querytype = (String)this.getView().getFormShowParameter().getCustomParam("querytype");
        if (EmptyCheckUtils.isNotEmpty((Object)taxtype)) {
            return Arrays.stream(taxtype.split(",")).map(String::trim).collect(Collectors.toList());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyCheckUtils.isEmpty((Object)appId)) {
            LOGGER.info("taxDeclareQueryParams --- appid: {}", (Object)appId);
            appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        } else {
            if ("qysdsjb".equals(querytype)) {
                appId = "tccit_yj";
            }
            if ("qysdsnb".equals(querytype)) {
                appId = "tccit_hj";
            }
        }
        LOGGER.info("taxDeclareQueryParams --- taxtype: {}, appid: {}", (Object)taxtype, (Object)appId);
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId((String)appId);
        if (taxTypeEnum != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String type = data.getString("type");
        if ("taxtype".equals(columnDesc.getKey())) {
            if (!(type == null || type.startsWith("zzs") || type.equals("ccxws") || type.equals("whsyjsf") || type.equals("qtsf_tysbb") || type.equals("qtsf_fsstysbb") || type.startsWith("qysds"))) {
                if (type.startsWith("FR")) {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"-", (String)"TamDeclareListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                } else {
                    e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, "-"));
                }
            }
        } else if ("type".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if ("fseq".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if (type.contains("szys") && "bqybtse".equals(columnDesc.getKey())) {
            BigDecimal ybtse = data.getBigDecimal("entryentity.ybtse");
            e.setFormatValue((Object)BigDecimalUtil.format((Object)ybtse, (String)",##0.00#"));
        } else if ("riskcontent".equals(columnDesc.getKey()) && "normal".equals(e.getFormatValue())) {
            e.getNoLinkKey().add("riskcontent");
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("skssqq".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("skssqz", "<=", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId((String)appId);
        if (taxTypeEnum != null) {
            List filterList = Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
            resultFilter.add(new QFilter("type", "in", filterList));
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (args.getSource() instanceof Donothing) {
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            if (("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey)) && (list == null || list.isEmpty())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u8bb0\u5f55", (String)"TamDeclareListPlugin_1", (String)"taxc-tam", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (INVALID.equals(operateKey) || RECTIFY.equals(operateKey)) {
                this.beforeDoInvalid(args, list, operateKey);
            }
        }
        if (args.getSource() instanceof Delete || args.getSource() instanceof Donothing && ("submit".equals(((Donothing)args.getSource()).getOperateKey()) || "unsubmit".equals(((Donothing)args.getSource()).getOperateKey()) || "audit".equals(((Donothing)args.getSource()).getOperateKey()) || "unaudit".equals(((Donothing)args.getSource()).getOperateKey()))) {
            Set strCollect = list.stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.toSet());
            DynamicObjectCollection mutexCollection = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid,user.name", (QFilter[])new QFilter[]{new QFilter("objectid", "in", strCollect)});
            if (mutexCollection == null) {
                return;
            }
            Map<Long, String> mutexMap = mutexCollection.stream().collect(Collectors.toMap(e -> Long.valueOf(e.getString("objectid")), e -> e.getString("user.name"), (k, v) -> k));
            DynamicObjectCollection nsrxxCollection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
            ArrayList errList = new ArrayList();
            StringBuilder stringBuilder = new StringBuilder();
            nsrxxCollection.stream().forEach(e -> {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"TamDeclareListPlugin_2", (String)"taxc-tam", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
                errList.add(msg);
                stringBuilder.append(msg);
            });
            if (errList.size() > 0) {
                args.setCancel(true);
                if (errList.size() == 1) {
                    this.getView().showTipNotification((String)errList.get(0));
                } else {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TamDeclareListPlugin_3", (String)"taxc-tam", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OK;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TamDeclareListPlugin_4", (String)"taxc-tam", (Object[])new Object[0]), stringBuilder.toString(), options, ConfirmTypes.Save, null, btnNameMaps);
                }
            }
        }
    }

    private void beforeDoInvalid(BeforeDoOperationEventArgs args, ListSelectedRowCollection list, String operateKey) {
        String keyStr;
        Object source = args.getSource();
        String opreateType = "";
        try {
            FormOperate operate = (FormOperate)source;
            opreateType = operate.getOption().getVariableValue("type");
        }
        catch (Exception operate) {
            // empty catch block
        }
        if ("msgInput".equals(opreateType)) {
            return;
        }
        Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        String string = keyStr = INVALID.equals(operateKey) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TamDeclareListPlugin_21", (String)"taxc-tam", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TamDeclareListPlugin_22", (String)"taxc-tam", (Object[])new Object[0]);
        if (collect.size() != 1) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e%s\u7533\u62a5\u3002", (String)"TamDeclareListPlugin_24", (String)"taxc-tam", (Object[])new Object[0]), keyStr));
            args.setCancel(true);
            return;
        }
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)"tcvat_nsrxx");
        String type = declare.getString("type");
        List<String> other_type = Arrays.asList("qtsf_tysbb", "qtsf_fsstysbb", "whsyjsf", "ccxws");
        if (!type.startsWith("zzs") && !type.startsWith("qysds") && !other_type.contains(type) || Arrays.asList("zzsyjskb", "qysdsjb").contains(type)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u201c\u66f4\u6b63\u7533\u62a5\u201d\u53ca\u201c\u4f5c\u5e9f\u7533\u62a5\u201d\u3002", (String)"TamDeclareListPlugin_25", (String)"taxc-tam", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String msg = DeclareUtils.checkGzZfInfo((String)operateKey, (Object)list.get(0).getPrimaryKeyValue());
        if (msg != null) {
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e0d\u53ef\u64a4\u9500\uff0c\u5982\u786e\u8ba4\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5f55\u5165\u539f\u56e0\u8bf4\u660e", (String)"TamDeclareListPlugin_26", (String)"taxc-tam", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
        args.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String appId = this.getView().getFormShowParameter().getAppId();
        OperationResult opResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        if (opResult == null) {
            return;
        }
        if (!opResult.isSuccess()) {
            if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey) || "delete".equals(evt.getOperateKey()) || PAY.equals(operateKey) || APPLY.equals(operateKey) || CANCELAPPLY.equals(operateKey) || CANCELPAY.equals(operateKey)) {
                if (evt.getSource() instanceof FormOperate) {
                    FormOperate source = (FormOperate)evt.getSource();
                    String custom_opplugin_fail = source.getOption().getVariableValue("custom_opplugin_fail", "0");
                    if ("1".equals(custom_opplugin_fail)) {
                        DeclareCommonUtil.dealFail(opResult, this.getView(), (IFormPlugin)this);
                    }
                } else {
                    DeclareCommonUtil.dealFail(opResult, this.getView(), (IFormPlugin)this);
                }
            }
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            billlist.refresh();
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("submit".equals(evt.getOperateKey()) || "unsubmit".equals(evt.getOperateKey()) || "audit".equals(evt.getOperateKey()) || "unaudit".equals(evt.getOperateKey()) || "delete".equals(evt.getOperateKey())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TamDeclareListPlugin_5", (String)"taxc-tam", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if ("viewflowchart".equals(evt.getOperateKey())) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55", (String)"TamDeclareListPlugin_6", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c", (String)"TamDeclareListPlugin_7", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
            }
            catch (Exception e) {
                LOGGER.error(ThrowableHelper.toString((Exception)e));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TamDeclareListPlugin_8", (String)"taxc-tam", (Object[])new Object[0]));
            }
        } else if (Arrays.asList(APPLY, CANCELAPPLY, CANCELPAY, INVALID, RECTIFY).contains(evt.getOperateKey())) {
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TamDeclareListPlugin_5", (String)"taxc-tam", (Object[])new Object[0]));
            billlist.refresh();
        } else if (PAY.equals(evt.getOperateKey())) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("bdtaxr_paydate_confirm");
            param.getOpenStyle().setShowType(ShowType.NonModal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payDateConfirm");
            param.setCloseCallBack(closeCallBack);
            this.getView().showForm(param);
        } else if (IMPORT.equals(operateKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("bdtaxr_import_dialog_new");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
            parameter.setCustomParam("source", (Object)"declare");
            parameter.setCustomParam("templatetypelist", this.getTemplateTypeList());
            String operateName = ResManager.loadKDString((String)"\u5f15\u5165", (String)"TamDeclareListPlugin_9", (String)"taxc-tam", (Object[])new Object[0]);
            String operateDescription = ResManager.loadKDString((String)"\u6253\u5f00\u5f15\u5165\u7533\u62a5\u8868\u6570\u636e\u5f39\u7a97\u6210\u529f", (String)"TamDeclareListPlugin_10", (String)"taxc-tam", (Object[])new Object[0]);
            String taxName = TaxNameUtil.getTaxName((String)appId);
            OperatorDialogUtils.operateDialog((String)taxName, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
            this.getView().showForm(parameter);
        } else if (EXPORT.equals(operateKey)) {
            boolean zerodeclare;
            String orgName;
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa", (String)"TamDeclareListPlugin_12", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            String pk = list.get(0).getPrimaryKeyValue().toString();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"tcvat_nsrxx");
            DynamicObject org = obj.getDynamicObject("org");
            Long orgId = org.getLong("id");
            String type = obj.getString("type");
            String billno = obj.getString("billno");
            String string = orgName = org != null ? org.getString("name") : "";
            if (!"qtsf_tysbb".equals(type) && !"qtsf_fsstysbb".equals(type) && (zerodeclare = obj.getBoolean("zerodeclare"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7533\u62a5\u8868\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u8868\uff0c\u4e0d\u652f\u6301\u5f15\u51fa", (String)"TamDeclareListPlugin_13", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("type", "=", (Object)type);
            boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
            String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(type, type) + "_" + orgName;
            Date date = (Date)obj.get("skssqq");
            Date endDate = (Date)obj.get("skssqz");
            DynamicObject template = null;
            String templateid = obj.getString("templateid");
            if (StringUtils.isNotEmpty((CharSequence)templateid)) {
                DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectById((String)type, (String)templateid) : TemplateUtilsOld.getTemplateObjectById((String)type, (String)templateid);
            }
            if (template == null && org != null) {
                DynamicObject dynamicObject = template = isNewTemplate ? TemplateUtils.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date) : TemplateUtilsOld.getTemplateObjectByConfig((String)type, (String)org.getString("id"), (Date)date, (Date)date);
            }
            if (template == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728", (String)"TamDeclareListPlugin_14", (String)"taxc-tam", (Object[])new Object[0]));
                return;
            }
            fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
            String operateName = ResManager.loadKDString((String)"\u5f15\u51fa", (String)"TamDeclareListPlugin_15", (String)"taxc-tam", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u7533\u62a5\u8868,\u5f15\u51fa\u6210\u529f", (String)"TamDeclareListPlugin_16", (String)"taxc-tam", (Object[])new Object[0]), billno);
            String taxName = TaxNameUtil.getTaxName((String)appId);
            OperatorDialogUtils.operateDialog((String)taxName, (String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")), (String)operateName, (String)operateDescription);
            Map valMap = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.queryData((Long)template.getLong("id"), (String)pk, (String)"_") : TemplateShowUtils.queryData((String)type, (String)pk, (String)"_");
            List hideSheets = null;
            this.declareReportHideService = DeclareReportHideFactory.createHandler((String)type);
            if (this.declareReportHideService != null) {
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.setOrgId(orgId);
                requestModel.setTemplateId(Long.valueOf(templateid));
                requestModel.setTemplateType(type);
                requestModel.setSkssqq(DateUtils.format((Date)date));
                requestModel.setSkssqz(DateUtils.format((Date)endDate));
                hideSheets = this.declareReportHideService.hideSheets(requestModel);
            }
            try (InputStream in = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, hideSheets, (Map)valMap) : TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, hideSheets, (Map)valMap);){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
                String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                String entityNum = ((IListView)this.getView()).getBillFormId();
                PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                this.getView().openUrl(urls);
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("new".equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("tam_add_confirm");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addDeclare"));
            parameter.setCustomParam("type", (Object)"declare");
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("payDateConfirm")) {
            Date payDate = (Date)closedCallBackEvent.getReturnData();
            if (payDate == null) {
                return;
            }
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection list = billList.getSelectedRows();
            DeclareCommonUtil.pay(billList, list.getPrimaryKeyValues(), payDate, this.getPageCache(), this.getView());
            this.updatePrepayDeclareBill(list.getPrimaryKeyValues(), payDate);
        }
    }

    private void updatePrepayDeclareBill(Object[] primaryKeyValues, Date payDate) {
        DynamicObject[] prepayList = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"org,skssqq,skssqz,sblx,billstatus,declarestatus,paystatus,payer,paydate,modifytime,modifier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Arrays.stream(prepayList).forEach(e -> {
            e.set("paystatus", (Object)"1");
            e.set("payer", (Object)RequestContext.get().getUserId());
            e.set("paydate", (Object)payDate);
            e.set("modifytime", (Object)new Date());
            e.set("modifier", (Object)RequestContext.get().getUserId());
        });
        SaveServiceHelper.save((DynamicObject[])prepayList);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ((INVALID.equals(event.getCallBackId()) || RECTIFY.equals(event.getCallBackId())) && event.getResult() == MessageBoxResult.Yes) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String keyStr = INVALID.equals(event.getCallBackId()) ? ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"TamDeclareListPlugin_21", (String)"taxc-tam", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u6b63", (String)"TamDeclareListPlugin_22", (String)"taxc-tam", (Object[])new Object[0]);
            customParams.put("customCaption", String.format(ResManager.loadKDString((String)"%s\u7533\u62a5", (String)"TamDeclareListPlugin_23", (String)"taxc-tam", (Object[])new Object[0]), keyStr));
            customParams.put("inputType", event.getCallBackId());
            BillList billlist = (BillList)this.getControl(BILL_LIST);
            ListSelectedRowCollection list = billlist.getSelectedRows();
            Object[] pkIds = list.getPrimaryKeyValues();
            customParams.put("pkid", pkIds[0]);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"bdtaxr_declare_msg_input", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        if ("skssqq".equals(args.getFieldName())) {
            DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)currentSelectedRowInfo.getPrimaryKeyValue());
        }
        if ("riskcontent".equals(args.getFieldName())) {
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        }
    }
}

