/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class TamDraftListPlugin
extends AbstractListPlugin {
    private static Log LOGGER = LogFactory.getLog(TamDraftListPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";

    public void initialize() {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.setOrderBy("org desc,startdate desc");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblnew".equals(itemKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("tam_add_confirm");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addDraft"));
            parameter.setCustomParam("type", (Object)"draft");
            this.getView().showForm(parameter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List schemeColumnList = args.getSchemeFilterColumns();
        List<String> templates = this.getTemplateTypeList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(templates.size());
        for (String template : templates) {
            ComboItem item = new ComboItem();
            item.setValue(template);
            item.setCaption(new LocaleString((String)TemplateTypeConstant.getNsrtypemap().get(template)));
            combos.add(item);
        }
        for (FilterColumn column : schemeColumnList) {
            if (!"templatetype".equals(column.getFieldName())) continue;
            SchemeFilterColumn typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(combos);
            break;
        }
        QFilter typeFilter = new QFilter("templatetype", "in", templates);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.getFilterParameter().setFilter(typeFilter);
    }

    private List<String> getTemplateTypeList() {
        String draftType;
        DraftTypeEnum taxTypeEnum;
        String appId = this.getView().getFormShowParameter().getAppId();
        LOGGER.info("DraftQueryListPlugin --- system_appid: {}", (Object)appId);
        if (EmptyCheckUtils.isEmpty((Object)appId)) {
            appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
            LOGGER.info("DraftQueryListPlugin --- custom_appid: {}", (Object)appId);
        }
        if ((taxTypeEnum = DraftTypeEnum.valueOfAppId((String)appId, (String)(draftType = (String)this.getView().getFormShowParameter().getCustomParam("drafttype")))) != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        if ("itp".equals(appId) && "qysdsjb".equals(draftType)) {
            return Stream.of(DraftTypeEnum.valueOfAppId((String)"tccit", (String)"qysdsjb").getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("templatetype".equals(columnDesc.getKey())) {
            String templatetype = data.getString("templatetype");
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(templatetype, ""));
        } else if ("startdate".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("startdate"), (Date)data.getDate("enddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                Map taxrefundableMap = TamDraftListPlugin.this.getTaxrefundable(data);
                for (DynamicObject datum : data) {
                    DynamicObjectType dynamicObjectType = datum.getDynamicObjectType();
                    DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
                    if (!properties.containsKey((Object)"taxrefundable")) {
                        dynamicObjectType.addProperty((DynamicProperty)new DynamicSimpleProperty("taxrefundable", BigDecimal.class, (Object)BigDecimal.ZERO));
                    }
                    datum.set("taxrefundable", taxrefundableMap.get(datum.getString("id")));
                }
                return data;
            }
        });
    }

    private Map<String, BigDecimal> getTaxrefundable(DynamicObjectCollection data) {
        List qysdsjbIds = data.stream().filter(e -> "draft_qysdsjb".equals(e.getString("templatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        List qysdsnbIds = data.stream().filter(e -> "draft_qysdsnb".equals(e.getString("templatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        List zzsybnsrIds = data.stream().filter(e -> "draft_zzsybnsr".equals(e.getString("templatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        List zzsxgmnsrIds = data.stream().filter(e -> "draft_zzsxgmnsr".equals(e.getString("templatetype"))).map(e -> e.getLong("id")).collect(Collectors.toList());
        List zzsybnsrYbhzIds = data.stream().filter(e -> "#draft_zzsybnsr_yz_zjg#draft_zzsybnsr_ybhz#draft_zzsybnsr_hz_zjg#".contains("#" + e.getString("templatetype") + "#")).map(e -> e.getLong("id")).collect(Collectors.toList());
        DynamicObject[] qysdsjb = BusinessDataServiceHelper.load((String)"tccit_seasonal_dg_bill", (String)"entryentity.bqybtse", (QFilter[])new QFilter[]{new QFilter("id", "in", qysdsjbIds)});
        DynamicObject[] qysdsnb = BusinessDataServiceHelper.load((String)"tccit_year_dg_bill", (String)"entryentity.bnybtsdse", (QFilter[])new QFilter[]{new QFilter("id", "in", qysdsnbIds)});
        DynamicObject[] zzsybnsr = BusinessDataServiceHelper.load((String)"tcvat_query_ybnsr", (String)"entryentity.ybtse", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsybnsrIds)});
        DynamicObject[] zzsxgmnsr = BusinessDataServiceHelper.load((String)"tcvat_query_ybnsr", (String)"xgmnsrentryentity.xgmnsrybtse", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsxgmnsrIds)});
        DynamicObject[] zzsybnsrYbhz = BusinessDataServiceHelper.load((String)"tcvat_query_ybnsr", (String)"ybhzentryentity.ybhzybtse", (QFilter[])new QFilter[]{new QFilter("id", "in", zzsybnsrYbhzIds)});
        Map<String, BigDecimal> map = Arrays.stream(qysdsjb).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getDynamicObjectCollection("entryentity").size() > 0 ? ((DynamicObject)e.getDynamicObjectCollection("entryentity").get(0)).getBigDecimal("bqybtse") : BigDecimal.ZERO));
        Map<String, BigDecimal> id = Arrays.stream(qysdsnb).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getDynamicObjectCollection("entryentity").size() > 0 ? ((DynamicObject)e.getDynamicObjectCollection("entryentity").get(0)).getBigDecimal("bnybtsdse") : BigDecimal.ZERO));
        Map<String, BigDecimal> id1 = Arrays.stream(zzsybnsr).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getDynamicObjectCollection("entryentity").size() > 0 ? ((DynamicObject)e.getDynamicObjectCollection("entryentity").get(0)).getBigDecimal("ybtse") : BigDecimal.ZERO));
        Map<String, BigDecimal> id2 = Arrays.stream(zzsxgmnsr).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getDynamicObjectCollection("xgmnsrentryentity").size() > 0 ? ((DynamicObject)e.getDynamicObjectCollection("xgmnsrentryentity").get(0)).getBigDecimal("xgmnsrybtse") : BigDecimal.ZERO));
        Map<String, BigDecimal> id3 = Arrays.stream(zzsybnsrYbhz).collect(Collectors.toMap(e -> e.getString("id"), e -> e.getDynamicObjectCollection("ybhzentryentity").size() > 0 ? ((DynamicObject)e.getDynamicObjectCollection("ybhzentryentity").get(0)).getBigDecimal("ybhzybtse") : BigDecimal.ZERO));
        map.putAll(id);
        map.putAll(id1);
        map.putAll(id2);
        map.putAll(id3);
        return map;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        this.openDraftPageOrDeclarePage(list, true);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("startdate".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("enddate", "<=", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                resultFilter.add(filter);
            }
        }
        resultFilter.add(new QFilter("draftpurpose", "=", (Object)"nssb"));
        String appId = this.getView().getFormShowParameter().getAppId();
        DraftTypeEnum taxTypeEnum = DraftTypeEnum.valueOfAppId((String)appId, null);
        if (taxTypeEnum != null) {
            List filterList = Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
            resultFilter.add(new QFilter("templatetype", "in", filterList));
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("createsbb".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"TamDraftListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            } else if (list.size() > 1) {
                this.batchGeneration(list.getPrimaryKeyValues());
            } else {
                this.openDraftPageOrDeclarePage(billlist, false);
            }
        }
    }

    private void batchGeneration(Object[] primaryKeyValues) {
        String collect = Arrays.stream(primaryKeyValues).map(s -> s.toString()).collect(Collectors.joining(","));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("tam");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("BatchDeclareTask");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.taxc.tam.business.mq.declare.BatchDeclareTask");
        HashMap<String, Object> businessParams = new HashMap<String, Object>();
        businessParams.put("tamDraftBillIds", collect);
        businessParams.put("executeType", "2");
        businessParams.put("combinedeclare", false);
        businessParams.put("userid", RequestContext.get().getUserId());
        jobInfo.setParams(businessParams);
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tam_declare_bill", (IFormView)this.getView(), null, (String)ResManager.loadKDString((String)"\u7533\u62a5\u8868\u4efb\u52a1\u5217\u8868", (String)"TamDraftListPlugin_1", (String)"taxc-tam", (Object[])new Object[0]), null);
        this.getView().showMessage(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u65b0\u589e\u7a0b\u5e8f\u5df2\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u7533\u62a5\u8868\u4efb\u52a1\u5217\u8868", (String)"TamDraftListPlugin_2", (String)"taxc-tam", (Object[])new Object[0]));
    }

    private void openDraftPageOrDeclarePage(BillList list, boolean openDraftPage) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tctb_draft_main");
        String templatetype = object.getString("templatetype");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("startdate");
        Date skssqz = object.getDate("enddate");
        customParams.put("templatetype", templatetype);
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("draftpurpose", object.getString("draftpurpose"));
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
        FormShowParameter param = new FormShowParameter();
        if (openDraftPage) {
            param.setFormId(draftEnum.getDraftPage());
        } else {
            param.setFormId(draftEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

