/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.draft;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tam.business.job.JobDispatchFormHelper;

public class TamHandAddConfirmDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void initialize() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String type = (String)customParams.get("type");
        if ("draft".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"declaretype"});
            this.setMustInput("drafttype");
        } else if ("declare".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"drafttype"});
            this.setMustInput("declaretype");
            LocaleString title = new LocaleString();
            title.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u65b0\u589e\u7533\u62a5\u8868", (String)"TamHandAddConfirmDialogPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            this.getView().setFormTitle(title);
        }
        MulBasedataEdit control = (MulBasedataEdit)this.getControl("org");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void setMustInput(String fieldKey) {
        FieldEdit control = (FieldEdit)this.getControl(fieldKey);
        control.setMustInput(true);
        FieldProp property = (FieldProp)this.getModel().getProperty(fieldKey);
        property.setMustInput(true);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String type = (String)customParams.get("type");
        if ("btnok".equals(itemKey)) {
            MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue("org");
            List selectOrgList = orgs.stream().map(m -> m.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            List orgList = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIds(selectOrgList).getData();
            List unableOrgNameList = orgs.stream().filter(m -> !orgList.contains(m.getDynamicObject("fbasedataid").getLong("id"))).map(m -> m.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList());
            selectOrgList.removeAll(orgList);
            if (selectOrgList.size() > 0) {
                StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7", (String)"TamHandAddConfirmDialogPlugin_1", (String)"taxc-tam", (Object[])new Object[0]));
                for (String object : unableOrgNameList) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u3010%s\u3011 ", (String)"TamHandAddConfirmDialogPlugin_5", (String)"taxc-tam", (Object[])new Object[0]), object));
                }
                builder.append(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TamHandAddConfirmDialogPlugin_4", (String)"taxc-tam", (Object[])new Object[0]));
                this.getView().showErrorNotification(builder.toString());
                return;
            }
            Date executetime = (Date)this.getModel().getValue("executetime");
            IFormView view = this.getView();
            IFormView parentView = this.getView().getParentView();
            IFormView parentView1 = this.getView().getParentView().getParentView();
            if ("draft".equals(type)) {
                String drafttype = (String)this.getModel().getValue("drafttype");
                JobDispatchFormHelper.sendDraftMsg(orgList, drafttype, executetime, parentView1, "draftdispatch2", "kd.taxc.tam.formplugin.draft.TamHandAddConfirmDialogPlugin");
            } else if ("declare".equals(type)) {
                String declaretype = (String)this.getModel().getValue("declaretype");
                JobDispatchFormHelper.sendDeclareMsg(orgList, declaretype, executetime, parentView1, "declaredispatch2", "kd.taxc.tam.formplugin.draft.TamHandAddConfirmDialogPlugin");
            }
            parentView.close();
            view.close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        HasPermOrgResult permOrgResult;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String type = (String)customParams.get("type");
        String entity = "tam_draft_bill";
        if ("declare".equals(type)) {
            entity = "tam_declare_bill";
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(permOrgResult = PermissionUtils.getAllPermOrgs((String)"tam", (String)entity, (String)"47156aff000000ac"))) && !permOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)permOrgResult.getHasPermOrgs())) {
            List orgList = permOrgResult.getHasPermOrgs();
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
        }
    }
}

