/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftStepsUtils;

public class BaseInitConfigPlugin
extends AbstractFormPlugin {
    protected static final String ORG_SEL = "org";
    private static String BAR_KEY = "toolbarap";
    private static String TOOL_BAR_MARK = "toolbarmark";
    private static final String CONTENT_TAB = "tabcontent";
    private static final String NEXT_KEY = "next";
    private static final String FORWARD_KEY = "forward";
    private static final String MARK_FINISH = "markfinish";
    private static final String MARK_FETCHTYPE = "markfetchtype";
    private static final String MARK_SUMMARYTYPE = "marksummarytype";
    private static final String SYNC_MAPPING = "syncmapping";
    private static final String SYNC_SUMMARY = "syncsummary";
    private static final String SYNC_APPLYFORM = "syncapplyform";
    private static final String CLOSE = "close";
    protected static final String FOCUS_PAGE = "focuspage";
    protected static final String PAGE_STATUS = "pagestatus";

    public void registerListener(EventObject e) {
        for (int step = 1; step <= TaxStepsConstant.TAM_BASE_INIT.size(); ++step) {
            this.addClickListeners(new String[]{"step" + step});
        }
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_MARK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(ORG_SEL, customParams.get(ORG_SEL));
        DynamicObject obj = this.queryBaseInitConfig(customParams.get(ORG_SEL));
        if (obj == null) {
            return;
        }
        String pageStatus = obj.getString(PAGE_STATUS);
        String isOrgComplete = obj.getString("isorgcomplete");
        this.getPageCache().put(PAGE_STATUS, pageStatus);
        if ("1".equals(isOrgComplete) && Integer.parseInt(pageStatus) < 5) {
            pageStatus = String.valueOf(Integer.parseInt(pageStatus) + 1);
        }
        if (Integer.parseInt(pageStatus) == 5) {
            pageStatus = "1";
        }
        this.loadContent(pageStatus, customParams.get(ORG_SEL));
    }

    private void loadContent(String focusPage, Object orgId) {
        DynamicObject obj = this.queryBaseInitConfig(orgId);
        this.lightenForStatus(focusPage, obj);
        DeclarePageType declarePageType = (DeclarePageType)TaxStepsConstant.TAM_BASE_INIT.get(focusPage);
        String entity = declarePageType.getEntity();
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
        param.setFormId(formConfig.getListFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put(ORG_SEL, orgId);
        param.setCustomParams(customParams);
        QFilter qFilter = new QFilter(ORG_SEL, "=", orgId);
        param.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        this.getView().showForm((FormShowParameter)param);
        this.getPageCache().put(CONTENT_TAB, param.getPageId());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "next": 
            case "forward": {
                this.lastOrNextStep(itemKey);
                break;
            }
            case "close": {
                BillList billList;
                IFormView parentView = this.getView().getParentView();
                if (parentView == null || (billList = (BillList)parentView.getControl("billlistap")) == null) break;
                billList.refreshData();
                this.getView().sendFormAction(parentView);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.doChildViewClick(args.getOperateKey());
    }

    private void doChildViewClick(String itemKey) {
        IFormView childView = this.getView().getView(this.getPageCache().get(CONTENT_TAB));
        if (childView == null) {
            return;
        }
        BillList billList = (BillList)childView.getControl("billlistap");
        billList.itemClick(itemKey, itemKey);
        this.getView().sendFormAction(childView);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        if (name.equals(ORG_SEL)) {
            DynamicObject obj;
            if (changeData[0].getNewValue() == null) {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            }
            if ((obj = (DynamicObject)this.getModel().getValue(ORG_SEL)) != null) {
                this.loadContent("1", obj.get("id"));
                this.getPageCache().put(FOCUS_PAGE, "1");
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("step")) {
            String focusPage;
            String step = key.replace("step", "");
            if (step.equals(focusPage = this.getPageCache().get(FOCUS_PAGE))) {
                return;
            }
            DynamicObject obj = (DynamicObject)this.getModel().getValue(ORG_SEL);
            this.loadContent(step, obj.get("id"));
            this.getPageCache().put(FOCUS_PAGE, step);
        }
    }

    private void lightenForStatus(String focusPage, DynamicObject mainConfig) {
        String pageStatus = "1";
        if (mainConfig != null) {
            pageStatus = mainConfig.getString(PAGE_STATUS);
        }
        DraftStepsUtils.resetSteps((int)TaxStepsConstant.TAM_BASE_INIT.size(), (String)focusPage, (String)pageStatus, (IFormView)this.getView());
        this.setButtonVisibleByStep(focusPage);
        if (mainConfig == null) {
            return;
        }
        this.getPageCache().put(FOCUS_PAGE, focusPage);
        String billStatus = mainConfig.getString("billstatus");
        String isOrgComplete = mainConfig.getString("isorgcomplete");
        String isTaxMainComplete = mainConfig.getString("istaxmaincomplete");
        this.setButtonVisibleByBillStatus(billStatus);
        this.setButtonEnableByFinishStatus(focusPage, isOrgComplete, isTaxMainComplete);
    }

    private void setButtonEnableByFinishStatus(String focusPage, String isOrgComplete, String isTaxMainComplete) {
        if ("1".equals(isOrgComplete)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{MARK_FINISH, "cancelfinish"});
            if ("5".equals(focusPage)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{MARK_FINISH, "cancelfinish"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SYNC_MAPPING, SYNC_SUMMARY, SYNC_APPLYFORM, MARK_FETCHTYPE, "fetch_none", "fetch_match", MARK_SUMMARYTYPE, "summary_none", "summary_group"});
            if (!"1".equals(focusPage)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{MARK_FINISH, "cancelfinish"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{MARK_FINISH, "cancelfinish"});
            }
        }
        if ("1".equals(isTaxMainComplete)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{MARK_FINISH, "cancelfinish", SYNC_MAPPING, SYNC_SUMMARY, SYNC_APPLYFORM, MARK_FETCHTYPE, "fetch_none", "fetch_match", MARK_SUMMARYTYPE, "summary_none", "summary_group"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SYNC_MAPPING, SYNC_SUMMARY, SYNC_APPLYFORM, MARK_FETCHTYPE, "fetch_none", "fetch_match", MARK_SUMMARYTYPE, "summary_none", "summary_group"});
        }
    }

    private void setButtonVisibleByBillStatus(String billStatus) {
        if (!"A".equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MARK_FINISH, SYNC_MAPPING, SYNC_SUMMARY, SYNC_APPLYFORM, MARK_FETCHTYPE, MARK_SUMMARYTYPE});
        }
    }

    private void setButtonVisibleByStep(String focuspage) {
        switch (focuspage) {
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY, MARK_FETCHTYPE, MARK_SUMMARYTYPE, SYNC_APPLYFORM, SYNC_MAPPING, SYNC_SUMMARY});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_KEY, MARK_FINISH, CLOSE});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.FALSE, new String[]{MARK_FETCHTYPE, MARK_SUMMARYTYPE, SYNC_APPLYFORM, SYNC_MAPPING, SYNC_SUMMARY});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, MARK_FINISH, CLOSE});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.FALSE, new String[]{MARK_SUMMARYTYPE, SYNC_APPLYFORM, SYNC_SUMMARY, MARK_FINISH});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, MARK_FETCHTYPE, SYNC_MAPPING, CLOSE});
                break;
            }
            case "4": {
                this.getView().setVisible(Boolean.FALSE, new String[]{MARK_FETCHTYPE, SYNC_APPLYFORM, SYNC_MAPPING, MARK_FINISH});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, MARK_SUMMARYTYPE, SYNC_SUMMARY, CLOSE});
                break;
            }
            case "5": {
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_KEY, MARK_FETCHTYPE, MARK_SUMMARYTYPE, SYNC_APPLYFORM, SYNC_MAPPING, SYNC_SUMMARY});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, MARK_FINISH, SYNC_APPLYFORM, CLOSE});
                break;
            }
        }
    }

    private void lastOrNextStep(String itemKey) {
        String focusPage = this.getPageCache().get(FOCUS_PAGE);
        DynamicObject obj = (DynamicObject)this.getModel().getValue(ORG_SEL);
        if (obj == null) {
            return;
        }
        String newFocusPage = NEXT_KEY.equals(itemKey) ? String.valueOf(Integer.parseInt(focusPage) + 1) : String.valueOf(Integer.parseInt(focusPage) - 1);
        this.loadContent(newFocusPage, obj.get("id"));
        this.getPageCache().put(FOCUS_PAGE, newFocusPage);
    }

    private DynamicObject queryBaseInitConfig(Object orgId) {
        QFilter orgFilter = new QFilter(ORG_SEL, "=", orgId);
        return QueryServiceHelper.queryOne((String)"tam_base_init_config", (String)"id,billstatus,pagestatus,isorgcomplete,istaxmaincomplete", (QFilter[])new QFilter[]{orgFilter});
    }
}

