/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orggroup.TaxcOrgGroupDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.pinyin.PinYinUtil;

public class BaseInitOrgGroupListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String operateKey;
            FormOperate source = (FormOperate)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "summary_none": {
                    this.doMarkSummaryTypeNone();
                    break;
                }
                case "summary_group": {
                    this.doMarkSummaryTypeGroup();
                    break;
                }
                case "syncsummary": {
                    this.doSyncSummary();
                }
            }
            this.getView().updateView();
        }
    }

    private void doSyncSummary() {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = this.getSelected()) {
            if ("1".equals(obj.getString("summarytype"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u7c7b\u578b\u4e3a\u201c\u6c47\u603b\u7533\u62a5\u201d\u65f6\u624d\u9700\u8981\u7ef4\u62a4\u6c47\u603b\u65b9\u6848\uff0c\u8bf7\u6807\u8bb0\u6216\u786e\u8ba4\u6c47\u603b\u7c7b\u578b\u3002", (String)"BaseInitOrgGroupListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            return;
        }
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        TaxResult result = TaxcOrgGroupDataServiceHelper.queryOrgGroupByOrgIds(Collections.singletonList(Long.parseLong(String.valueOf(org))));
        HashMap<String, DynamicObject> taxTypeGroupMap = new HashMap(4);
        if (result.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            List data = (List)result.getData();
            taxTypeGroupMap = data.stream().collect(Collectors.groupingBy(t -> t.getString("taxtype"), Collectors.reducing(null, (m, n) -> n)));
        }
        Date nextYearToday = DateUtils.addYear((Date)new Date(), (int)1);
        TaxResult qysdsGroups = TaxcOrgGroupDataServiceHelper.queryOrgGroupByOrgIdAndTaxTypeWithValidDate((Long)Long.parseLong(String.valueOf(org)), (String)"qysds", (Date)nextYearToday, (Date)DateUtils.getDayLast((Date)nextYearToday));
        if (qysdsGroups.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)qysdsGroups.getData()))) {
            taxTypeGroupMap.put("qysds", (DynamicObject)((DynamicObjectCollection)qysdsGroups.getData()).get(0));
        }
        if (!CollectionUtils.isEmpty(taxTypeGroupMap)) {
            this.updateBaseInitOrgGroup(taxTypeGroupMap);
        }
    }

    private void updateBaseInitOrgGroup(Map<String, DynamicObject> orgGroupMap) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = this.getSelected()) {
            DynamicObject orgGroup = orgGroupMap.get(this.convertTaxType(obj.getString("basedataname")));
            if (orgGroup == null) continue;
            String orgGroupNumber = orgGroup.getString("number");
            obj.set("glhzfa", (Object)orgGroupNumber);
            obj.set("status", (Object)(StringUtils.isBlank((CharSequence)orgGroupNumber) ? "0" : "1"));
        }
        SaveServiceHelper.update((DynamicObject[])objs);
        this.updateBaseInitConfig();
    }

    private void doMarkSummaryTypeGroup() {
        try (TXHandle h = TX.required();){
            try {
                this.updateBaseInitOrgSummaryStatus("1");
                this.updateBaseInitConfig();
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void doMarkSummaryTypeNone() {
        try (TXHandle h = TX.required();){
            try {
                this.updateBaseInitOrgSummaryStatus("0");
                this.updateBaseInitConfig();
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void updateBaseInitOrgSummaryStatus(String summarytype) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = this.getSelected()) {
            obj.set("summarytype", (Object)summarytype);
            if ("0".equals(summarytype)) {
                obj.set("status", (Object)"1");
                obj.set("glhzfa", (Object)"");
                continue;
            }
            if (!"1".equals(summarytype)) continue;
            obj.set("status", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject[])objs);
    }

    private DynamicObject[] getSelected() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        String billFormId = ((ListView)this.getView()).getBillFormId();
        List ids = rows.stream().map(r -> r.getPrimaryKeyValue()).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)billFormId));
    }

    private void updateBaseInitConfig() {
        DynamicObject obj;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)((ListView)this.getView()).getBillFormId(), (String)"id,status", (QFilter[])new QFilter[]{qFilter});
        boolean isFinish = Arrays.stream(groups).noneMatch(g -> g.getString("status").equals("0"));
        String finishStatus = isFinish ? "1" : "0";
        if (finishStatus.equals((obj = BusinessDataServiceHelper.loadSingle((String)"tam_base_init_config", (String)"id,isorggroupcomplete,pagestatus,modifytime,modifier", (QFilter[])new QFilter[]{qFilter})).get("isorggroupcomplete"))) {
            return;
        }
        obj.set("isorggroupcomplete", (Object)finishStatus);
        if (obj.getInt("pagestatus") < 4) {
            obj.set("pagestatus", (Object)("1".equals(finishStatus) ? "4" : "3"));
        }
        obj.set("modifytime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object focusRowId = billList.getFocusRowPkId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)focusRowId, (String)((ListView)this.getView()).getBillFormId());
        String eventFieldValue = obj.getString(fieldName);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (fieldName.equals("basedataname")) {
            this.drillListPage(customParams, eventFieldValue);
        }
        if (fieldName.equals("glhzfa")) {
            this.drillEditPage(customParams, eventFieldValue);
        }
    }

    private void drillListPage(Map<String, Object> customParams, String selectedBaseData) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("tctb_org_group_latest");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("taxtype", "=", this.convertTaxType(selectedBaseData));
        param.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        this.getView().showForm((FormShowParameter)param);
    }

    private Object convertTaxType(String selectedBaseData) {
        String pinYinHeadChar = PinYinUtil.getPinYinHeadChar((String)selectedBaseData);
        if (pinYinHeadChar.startsWith("zzs")) {
            return "zzs";
        }
        if (pinYinHeadChar.startsWith("qysds")) {
            return "qysds";
        }
        if (pinYinHeadChar.contains("sljsjj")) {
            return "sljsjj";
        }
        return "";
    }

    private void drillEditPage(Map<String, Object> customParams, String selectedGroup) {
        BillShowParameter param = new BillShowParameter();
        param.setPkId((Object)this.queryGroupIdByCode(selectedGroup));
        param.setFormId("tctb_org_group_latest");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private Long queryGroupIdByCode(String selectedGroup) {
        TaxResult result = TaxcOrgGroupDataServiceHelper.queryOrgGroupByNumber((String)selectedGroup);
        if (!result.isSuccess() || result.getData() == null) {
            return 0L;
        }
        DynamicObject data = (DynamicObject)result.getData();
        return data.getLong("id");
    }
}

