/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.formplugin.init.OrgInitConfigItemEnum;

public class BaseInitOrgListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarmark"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String operateKey;
            FormOperate source = (FormOperate)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "markfinish": {
                    this.doMarkFinish();
                    break;
                }
                case "cancelfinish": {
                    this.doCancelFinish();
                }
            }
            this.getView().updateView();
        }
    }

    private void doCancelFinish() {
        Throwable throwable;
        TXHandle h;
        block17: {
            block18: {
                block19: {
                    h = TX.required();
                    throwable = null;
                    if (this.updateBaseInitOrg("0")) break block17;
                    if (h == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                this.updateBaseInitTaxMainStatus("0");
                this.updateBaseInitConfig(true, "0");
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    private void doMarkFinish() {
        Throwable throwable;
        TXHandle h;
        block19: {
            block20: {
                block21: {
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    Object org = customParams.get("org");
                    if (!this.isOrgExists(org)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u8fd8\u672a\u540c\u6b65\u81f3\u7a0e\u52a1\u7ec4\u7ec7\u5217\u8868\u6216\u672a\u542f\u7528\uff0c\u8bf7\u5148\u524d\u5f80\u201c\u7a0e\u52a1\u4e91-\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u201d\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u5e76\u542f\u7528", (String)"BaseInitOrgListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
                        return;
                    }
                    h = TX.required();
                    throwable = null;
                    if (this.updateBaseInitOrg("1")) break block19;
                    if (h == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        h.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                h.close();
            }
            return;
        }
        try {
            try {
                boolean isOrgVirtual = this.isOrgVirtual();
                if (isOrgVirtual) {
                    this.updateBaseInitTaxMainStatus("1");
                }
                this.updateBaseInitConfig(isOrgVirtual, "1");
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    private void updateBaseInitTaxMainStatus(String finishStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)OrgInitConfigItemEnum.TAX_MAIN.getMeta(), (String)"id,status,modifydate,modifier", (QFilter[])new QFilter[]{qFilter});
        obj.set("status", (Object)finishStatus);
        obj.set("modifydate", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    private boolean isOrgVirtual() {
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        TaxResult result = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(String.valueOf(org)));
        DynamicObject orgObj = (DynamicObject)result.getData();
        if (orgObj == null) {
            return false;
        }
        return orgObj.getBoolean("isvirtual");
    }

    private void updateBaseInitConfig(boolean isOrgVirtual, String finishStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"tam_base_init_config", (String)"id,isorgcomplete,istaxmaincomplete,pagestatus,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        obj.set("isorgcomplete", (Object)finishStatus);
        if (isOrgVirtual) {
            obj.set("istaxmaincomplete", (Object)finishStatus);
            obj.set("pagestatus", (Object)("1".equals(finishStatus) ? "2" : "1"));
        } else {
            obj.set("pagestatus", (Object)"1");
        }
        obj.set("modifytime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    private boolean updateBaseInitOrg(String finishStatus) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)billFormId);
        if (finishStatus.equals(obj.getString("status"))) {
            return false;
        }
        obj.set("status", (Object)finishStatus);
        SaveServiceHelper.update((DynamicObject)obj);
        return true;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        if (this.isOrgExists(org)) {
            this.drillEditPage(customParams, org);
        } else {
            this.drillListPage(customParams, org);
        }
    }

    private void drillListPage(Map<String, Object> customParams, Object org) {
        ListShowParameter param = new ListShowParameter();
        String orgId = String.valueOf(org);
        customParams.put("listOrgId", orgId);
        customParams.put("cmborttypeId", this.getPageCache().get("cmborgtype_" + orgId));
        param.setFormId("bos_list");
        param.setBillFormId("bastax_taxorg");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        this.getView().showForm((FormShowParameter)param);
    }

    private boolean isOrgExists(Object org) {
        TaxResult result = TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)Long.parseLong(String.valueOf(org)));
        return (Boolean)result.getData();
    }

    private void drillEditPage(Map<String, Object> customParams, Object org) {
        BillShowParameter param = new BillShowParameter();
        String orgId = String.valueOf(org);
        param.setPkId((Object)orgId);
        param.setFormId("bastax_taxorg");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.NonModal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bastax_taxorg");
        param.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)param);
    }
}

