/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tam.formplugin.init;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;

public class BaseInitOrgMappingListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            String operateKey;
            FormOperate source = (FormOperate)args.getSource();
            switch (operateKey = source.getOperateKey()) {
                case "fetch_none": {
                    this.doMarkFetchTypeNone();
                    break;
                }
                case "fetch_match": {
                    this.doMarkFetchTypeMatch();
                    break;
                }
                case "syncmapping": {
                    this.doSyncMapping();
                }
            }
            this.getView().updateView();
        }
    }

    private void doSyncMapping() {
        DynamicObject obj = this.getCurrentOrg();
        if (!"1".equals(obj.getString("fetchtype"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"{\u53d6\u6570\u7c7b\u578b\u4e3a\u201c\u6620\u5c04\u53d6\u6570\u201d\u65f6\u624d\u9700\u8981\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u6807\u8bb0\u6216\u786e\u8ba4\u53d6\u6570\u7c7b\u578b\u3002", (String)"BaseInitOrgMappingListPlugin_0", (String)"taxc-tam", (Object[])new Object[0]));
            return;
        }
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        TaxResult result = TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIds(Collections.singletonList(Long.parseLong(String.valueOf(org))));
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return;
        }
        List data = (List)result.getData();
        List mappingList = data.stream().map(d -> d.getString("number")).collect(Collectors.toList());
        String mappings = String.join((CharSequence)";", mappingList);
        try (TXHandle h = TX.required();){
            try {
                this.updateBaseInitOrgMapping(mappings);
                this.updateBaseInitConfig(StringUtils.isBlank((CharSequence)mappings) ? "0" : "1");
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void updateBaseInitOrgMapping(String mappings) {
        DynamicObject obj = this.getCurrentOrg();
        obj.set("glysfa", (Object)mappings);
        obj.set("status", (Object)(StringUtils.isBlank((CharSequence)mappings) ? "0" : "1"));
        SaveServiceHelper.update((DynamicObject)obj);
    }

    private void doMarkFetchTypeMatch() {
        try (TXHandle h = TX.required();){
            try {
                if (this.updateBaseInitOrgMappingStatus("1")) {
                    this.updateBaseInitConfig("0");
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private void doMarkFetchTypeNone() {
        try (TXHandle h = TX.required();){
            try {
                if (this.updateBaseInitOrgMappingStatus("0")) {
                    this.updateBaseInitConfig("1");
                }
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private boolean updateBaseInitOrgMappingStatus(String fetchType) {
        DynamicObject obj = this.getCurrentOrg();
        if (fetchType.equals(obj.getString("fetchtype"))) {
            return false;
        }
        obj.set("fetchtype", (Object)fetchType);
        if ("0".equals(fetchType)) {
            obj.set("status", (Object)"1");
            obj.set("glysfa", (Object)"");
        } else if ("1".equals(fetchType)) {
            obj.set("status", (Object)"0");
        }
        SaveServiceHelper.update((DynamicObject)obj);
        return true;
    }

    private DynamicObject getCurrentOrg() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        String billFormId = ((ListView)this.getView()).getBillFormId();
        return BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)billFormId);
    }

    private void updateBaseInitConfig(String finishStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        QFilter qFilter = new QFilter("org", "=", org);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"tam_base_init_config", (String)"id,isorgmappingcomplete,pagestatus,modifytime,modifier", (QFilter[])new QFilter[]{qFilter});
        obj.set("isorgmappingcomplete", (Object)finishStatus);
        if (obj.getInt("pagestatus") < 3) {
            obj.set("pagestatus", (Object)("1".equals(finishStatus) ? "3" : "2"));
        }
        obj.set("modifytime", (Object)new Date());
        obj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("org");
        this.drillListPage(customParams, org);
    }

    private void drillListPage(Map<String, Object> customParams, Object org) {
        ListShowParameter param = new ListShowParameter();
        String orgId = String.valueOf(org);
        customParams.put("listOrgId", orgId);
        param.setFormId("bos_templatetreelist");
        param.setBillFormId("tctb_orgmaprelation");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter qFilter = new QFilter("useorg", "=", (Object)Long.parseLong(orgId));
        param.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        this.getView().showForm((FormShowParameter)param);
    }
}

